/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.wizard.WizardPage;

public class AuthorInfoPage
extends WizardPage {
    private JFileChooser jfc = null;
    private static final String[] licenses = new String[]{"Custom", "CDDL", "Sun Public License", "Apache License", "BSD License", "GNU Public License", "LGPL", "Perl Artistic License"};
    private static final String[] licenseFiles = new String[]{null, "cddl.txt", "spl.txt", "apache.txt", "bsd.txt", "gpl.txt", "lgpl.txt", "artistic.txt"};
    private JTextField authorField;
    private JLabel authorLabel;
    private JButton browseButton;
    private JTextField homePageField;
    private JLabel homePageLabel;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea licenseField;
    private JLabel licenseLabel;

    public AuthorInfoPage() {
        this.initComponents();
        this.licenseField.setFont(this.authorField.getFont());
    }

    public static String getStep() {
        return "authorInfo";
    }

    public static String getDescription() {
        return "Author & License";
    }

    public void requestFocus() {
        this.authorField.requestFocus();
    }

    protected String validateContents(Component component, Object event) {
        String s = this.homePageField.getText();
        if (!"".equals(s)) {
            try {
                URL url = new URL(s);
            }
            catch (MalformedURLException e) {
                return "Not a valid URL " + s + " (you can leave it blank)";
            }
        }
        if ("".equals((s = this.licenseField.getText()).trim())) {
            return "Enter a license, or choose one from the combo box";
        }
        s = this.authorField.getText();
        if ("".equals(s.trim())) {
            return "Enter a name or company in the author field";
        }
        return null;
    }

    private void initComponents() {
        this.authorLabel = new JLabel();
        this.authorField = new JTextField();
        this.homePageLabel = new JLabel();
        this.homePageField = new JTextField();
        this.licenseLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.licenseField = new JTextArea();
        this.browseButton = new JButton();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.authorLabel.setLabelFor(this.authorField);
        this.authorLabel.setText("Author");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 5, 0);
        this.add((Component)this.authorLabel, gridBagConstraints);
        this.authorField.setName("author");
        this.authorField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AuthorInfoPage.this.authorFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.authorField, gridBagConstraints);
        this.homePageLabel.setLabelFor(this.homePageField);
        this.homePageLabel.setText("Home Page");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.homePageLabel, gridBagConstraints);
        this.homePageField.setName("homepage");
        this.homePageField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AuthorInfoPage.this.authorFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.homePageField, gridBagConstraints);
        this.licenseLabel.setLabelFor(this.licenseField);
        this.licenseLabel.setText("License");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        this.add((Component)this.licenseLabel, gridBagConstraints);
        this.licenseField.setColumns(20);
        this.licenseField.setFont(UIManager.getFont("Label.font") == null ? new Font("SansSerif", 12, 1) : UIManager.getFont("Label.font"));
        this.licenseField.setLineWrap(true);
        this.licenseField.setRows(5);
        this.licenseField.setWrapStyleWord(true);
        this.licenseField.setName("license");
        this.jScrollPane1.setViewportView(this.licenseField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 167;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.browseButton.setText("Browse for License File");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthorInfoPage.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Custom", "CDDL", "Apache License", "BSD License", "GNU Public License", "LGPL", "Perl Artistic License"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthorInfoPage.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabel1.setText("Common Licenses");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (this.jfc == null) {
            this.jfc = new JFileChooser();
        }
        if (this.jfc.showOpenDialog(this) == 0) {
            this.jComboBox1.setSelectedItem("Custom");
            this.putWizardData("licenseFile", this.jfc.getSelectedFile().getPath());
            this.putWizardData("licenseName", null);
            this.loadLicense(this.jfc.getSelectedFile());
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        JComboBox box = (JComboBox)evt.getSource();
        String sel = (String)box.getSelectedItem();
        int ix = Arrays.asList(licenses).indexOf(sel);
        if (ix >= 0) {
            String filename = licenseFiles[ix];
            if (filename == null) {
                this.licenseField.setText("");
            } else {
                this.putWizardData("licenseFile", null);
                int pix = filename.lastIndexOf(".");
                String lname = filename.substring(0, pix);
                this.putWizardData("licenseName", lname.toLowerCase());
                this.loadLicense(filename);
            }
        }
    }

    private void loadLicense(String filename) {
        BufferedInputStream is = new BufferedInputStream(AuthorInfoPage.class.getResourceAsStream("resources/" + filename));
        this.loadLicense(is);
    }

    private void loadLicense(File file) {
        if (!file.isFile() || !file.canRead()) {
            JOptionPane.showMessageDialog(this, "Cannot read " + file.getName(), "Error reading license file", 0);
            return;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            this.loadLicense(is);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Could not open " + file.getName());
        }
    }

    private void loadLicense(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            AuthorInfoPage.copy(is, baos);
            String s = new String(baos.toByteArray(), "UTF-8");
            this.licenseField.setText(s);
            this.jScrollPane1.setIgnoreRepaint(true);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BoundedRangeModel mdl = AuthorInfoPage.this.jScrollPane1.getVerticalScrollBar().getModel();
                    mdl.setValue(mdl.getMinimum());
                    mdl = AuthorInfoPage.this.jScrollPane1.getHorizontalScrollBar().getModel();
                    mdl.setValue(mdl.getMinimum());
                    AuthorInfoPage.this.jScrollPane1.setIgnoreRepaint(false);
                    AuthorInfoPage.this.jScrollPane1.repaint();
                }
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = is.read(BUFFER)) != -1) {
            os.write(BUFFER, 0, len);
        }
        return;
    }

    private void authorFieldFocusGained(FocusEvent evt) {
        JTextComponent jtc = (JTextComponent)evt.getSource();
        jtc.selectAll();
    }

    static {
        assert (licenses.length == licenseFiles.length);
    }
}

