/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import beans2nbm.gen.FileModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class NbmFileModel
implements FileModel {
    private final String path;
    private List entries = new ArrayList();

    public NbmFileModel(String path) {
        this.path = path;
    }

    static String genClassnameDots(String classname) {
        assert (classname.endsWith(".class"));
        StringBuffer sb = new StringBuffer(classname.substring(0, classname.length() - ".class".length()));
        for (int i = 0; i < sb.length(); ++i) {
            if ('/' != sb.charAt(i)) continue;
            sb.setCharAt(i, '.');
        }
        return sb.toString();
    }

    static String genSimpleClassname(String classname) {
        int start = classname.lastIndexOf(47);
        int end = classname.lastIndexOf(46);
        if (start == -1 || end == -1) {
            throw new IllegalArgumentException(classname);
        }
        return classname.substring(start, end);
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream stream) throws IOException {
        List l = this.buildEntries();
        JarOutputStream jos = new JarOutputStream(stream);
        jos.setLevel(9);
        try {
            for (FileModel file : l) {
                JarEntry entry = new JarEntry(file.getPath());
                jos.putNextEntry(entry);
                file.write(jos);
                jos.closeEntry();
            }
        }
        finally {
            jos.close();
        }
    }

    public void add(FileModel mdl) {
        this.entries.add(mdl);
    }

    private List buildEntries() {
        ArrayList l = new ArrayList(this.entries);
        return l;
    }
}

