/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import beans2nbm.gen.FileModel;
import java.io.IOException;
import java.io.OutputStream;

public class ModuleXMLModel
implements FileModel {
    private final String moduleName;
    private final String version;
    private static final String MXML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\" \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n";

    public ModuleXMLModel(String moduleNameDots, String version) {
        this.moduleName = moduleNameDots;
        this.version = version;
    }

    private String moduleNameDashes() {
        char[] c = this.moduleName.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != '.') continue;
            c[i] = 45;
        }
        return new String(c);
    }

    public String getPath() {
        return "netbeans/config/Modules/" + this.moduleNameDashes() + ".xml";
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.toString().getBytes("UTF-8"));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(MXML_HEADER);
        buf.append("<module name=\"");
        String indent = "    ";
        buf.append(this.moduleName);
        buf.append("\">\n");
        buf.append(indent);
        buf.append("<param name=\"eager\">false</param>\n");
        buf.append(indent);
        buf.append("<param name=\"enabled\">true</param>\n");
        buf.append(indent);
        buf.append("<param name=\"jar\">modules/");
        buf.append(this.moduleNameDashes());
        buf.append(".jar</param>\n");
        buf.append(indent);
        buf.append("<param name=\"reloadable\">false</param>\n");
        buf.append(indent);
        buf.append("<param name=\"specversion\">" + this.version + "</param>\n");
        buf.append("</module>\n");
        return buf.toString();
    }
}

