/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import beans2nbm.gen.FileModel;
import beans2nbm.gen.PropertiesFileModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class ModuleModel
implements FileModel {
    private final String displayName;
    private final String codeName;
    private final String description;
    private final String version;
    private final String minJDK;
    private final String moduleJarPath;
    private Map filesToDisplayNames = new HashMap();
    private List entries = new ArrayList();

    public ModuleModel(String moduleJarPath, String codeName, String description, String version, String displayName, String minJDK) {
        this.codeName = codeName;
        this.description = description;
        this.version = version;
        this.displayName = displayName;
        this.moduleJarPath = moduleJarPath;
        this.minJDK = minJDK;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getPath() {
        return this.moduleJarPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream stream) throws IOException {
        Manifest manifest = this.getManifest();
        List l = this.buildEntries();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream((OutputStream)baos, manifest);
        jos.setLevel(0);
        try {
            for (FileModel file : l) {
                JarEntry entry = new JarEntry(file.getPath());
                jos.putNextEntry(entry);
                file.write(jos);
                jos.closeEntry();
            }
        }
        finally {
            jos.flush();
            jos.close();
        }
        stream.write(baos.toByteArray());
    }

    private Manifest getManifest() {
        Manifest m = new Manifest();
        Attributes atts = m.getMainAttributes();
        atts.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        atts.putValue("OpenIDE-Module", this.codeName);
        atts.putValue("OpenIDE-Module-Public-Packages", "-");
        atts.putValue("OpenIDE-Module-Specification-Version", this.version);
        atts.putValue("OpenIDE-Module-Localizing-Bundle", this.getBasePackageSlashes() + "Bundle.properties");
        atts.putValue("OpenIDE-Module-Layer", this.getBasePackageSlashes() + "layer.xml");
        atts.putValue("OpenIDE-Module-Requires", "org.openide.modules.ModuleFormat1");
        if (!"1.4".equals(this.minJDK)) {
            atts.putValue("OpenIDE-Module-Java-Dependencies", "Java > " + this.minJDK + ", VM > 1.0");
        }
        return m;
    }

    public String getManifestXML() {
        StringBuffer sb = new StringBuffer("<manifest OpenIDE-Module=\"");
        sb.append(this.codeName);
        sb.append("\"\n");
        sb.append("OpenIDE-Module-Implementation-Version=\"1\"\n");
        sb.append("OpenIDE-Module-Name=\"");
        sb.append(this.displayName);
        sb.append("\"\n");
        sb.append("OpenIDE-Module-Requires=\"org.openide.modules.ModuleFormat1\"\n");
        sb.append("OpenIDE-Module-Specification-Version=\"");
        sb.append(this.version);
        sb.append("\"\n");
        if (!"1.4".equals(this.minJDK)) {
            sb.append("OpenIDE-Module-Java-Dependencies=\"");
            sb.append("Java &gt; " + this.minJDK + ", VM &gt; 1.0\"\n");
        }
        sb.append("/>\n");
        return sb.toString();
    }

    private String getBasePackageSlashes() {
        StringBuffer sb = new StringBuffer(this.codeName);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '.') continue;
            sb.setCharAt(i, '/');
        }
        if (!sb.toString().endsWith("/")) {
            sb.append('/');
        }
        return sb.toString();
    }

    public void addFileDisplayName(String pathInJar, String displayName) {
        this.filesToDisplayNames.put(pathInJar, displayName);
    }

    public void addFileEntry(FileModel fi) {
        this.entries.add(fi);
    }

    private List buildEntries() {
        ArrayList<PropertiesFileModel> result = new ArrayList<PropertiesFileModel>(this.entries);
        PropertiesFileModel pfm = new PropertiesFileModel(this.getBasePackageSlashes() + "Bundle.properties");
        result.add(pfm);
        pfm.put("OpenIDE-Module-Display-Name", this.displayName);
        pfm.put("OpenIDE-Module-Short-Description", this.description);
        pfm.put("OpenIDE-Module-Display-Category", "Swing Components");
        pfm.putAll((Map<?, ?>)this.filesToDisplayNames);
        return result;
    }
}

