/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import beans2nbm.gen.FileModel;
import beans2nbm.gen.ModuleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class ModuleInfoModel
implements FileModel {
    private final ModuleModel module;
    private final Date date = new Date();
    private final String license;
    private final String author;
    private final String homepage;
    private static final String MI_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Autoupdate Module Info 2.3//EN\" \"http://www.netbeans.org/dtds/autoupdate-info-2_3.dtd\">\n";

    public ModuleInfoModel(ModuleModel module, String homepage, String author, String license) {
        this.module = module;
        this.author = author == null ? "" : author;
        this.homepage = homepage == null ? "" : homepage;
        this.license = license == null ? "No license" : license;
    }

    public String getPath() {
        return "Info/info.xml";
    }

    private String getDateString() {
        int y = this.date.getYear() + 1900;
        int m = this.date.getMonth() + 1;
        int d = this.date.getDay() + 1;
        return y + "/" + ModuleInfoModel.twoDigit(m) + "/" + ModuleInfoModel.twoDigit(d);
    }

    private static String twoDigit(int i) {
        StringBuffer result = new StringBuffer();
        result.append(i);
        if (result.length() == 1) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.toString().getBytes("UTF-8"));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(MI_HEADER);
        String indent = "        ";
        sb.append("<module codenamebase=\"" + this.module.getCodeName() + "\"\n");
        sb.append(indent);
        sb.append("homepage=\"");
        sb.append(this.homepage);
        sb.append("\"\n");
        sb.append(indent);
        sb.append("distribution=\"\"\n");
        sb.append(indent);
        sb.append("license=\"license.txt\"\n");
        sb.append(indent);
        sb.append("downloadsize=\"0\"\n");
        sb.append(indent);
        sb.append("needsrestart=\"false\"\n");
        sb.append(indent);
        sb.append("moduleauthor=\"");
        sb.append(this.author);
        sb.append("\"\n");
        sb.append(indent);
        sb.append("releasedate=\"");
        sb.append(this.getDateString());
        sb.append("\"\n");
        sb.append(">\n  ");
        sb.append(this.module.getManifestXML());
        sb.append('\n');
        sb.append("<license name=\"license.txt\"><![CDATA[");
        sb.append(this.license);
        sb.append("]]></license>\n</module>");
        return sb.toString();
    }
}

