/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import beans2nbm.gen.FileModel;
import java.io.IOException;
import java.io.OutputStream;

public class LibDescriptorModel
implements FileModel {
    private final String path;
    private final String jarNameSimple;
    private final String srcJarNameSimple;
    private final String docsJarNameSimple;
    private final String basePackageDots;
    private final String libName;
    private static final String LIB_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">\n";

    public LibDescriptorModel(String path, String libName, String basePackageDots, String jarNameSimple, String srcJarNameSimple, String docsJarNameSimple) {
        this.path = path;
        this.jarNameSimple = jarNameSimple;
        assert (path != null);
        assert (jarNameSimple != null);
        this.srcJarNameSimple = srcJarNameSimple;
        this.docsJarNameSimple = docsJarNameSimple;
        this.basePackageDots = basePackageDots;
        this.libName = libName;
    }

    public String getPath() {
        return this.path;
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.toString().getBytes("UTF-8"));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(LIB_HEADER);
        sb.append("<library version=\"1.0\">\n");
        sb.append("  <name>");
        sb.append(this.libName);
        sb.append("</name>\n");
        sb.append("  <type>j2se</type>\n");
        sb.append("  <localizing-bundle>");
        sb.append(this.basePackageDots);
        sb.append(".Bundle</localizing-bundle>\n");
        sb.append("    <volume>\n");
        sb.append("      <type>classpath</type>\n");
        sb.append("      <resource>jar:nbinst:///libs/");
        sb.append(this.jarNameSimple);
        sb.append("!/</resource>\n");
        sb.append("    </volume>\n");
        if (this.srcJarNameSimple != null && !"".equals(this.srcJarNameSimple)) {
            sb.append("    <volume>\n");
            sb.append("      <type>src</type>\n");
            sb.append("      <resource>jar:nbinst:///sources/");
            sb.append(this.srcJarNameSimple);
            sb.append("!/</resource>\n");
            sb.append("    </volume>\n");
        }
        if (this.docsJarNameSimple != null && !"".equals(this.docsJarNameSimple)) {
            sb.append("    <volume>\n");
            sb.append("      <type>javadoc</type>\n");
            sb.append("      <resource>jar:nbinst:///docs/");
            sb.append(this.docsJarNameSimple);
            sb.append("!/</resource>\n");
            sb.append("    </volume>\n");
        }
        sb.append("</library>\n");
        return sb.toString();
    }
}

