/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import beans2nbm.gen.FileModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayerFileModel
implements FileModel {
    private final String path;
    private final String basePackageDots;
    private final String paletteFolder;
    private static final String LAYER_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE filesystem PUBLIC \"-//NetBeans//DTD Filesystem 1.1//EN\" \"http://www.netbeans.org/dtds/filesystem-1_1.dtd\">\n<filesystem>\n";
    private List libraryNames = new ArrayList();
    private Map folders2paletteEntries = new HashMap();

    public LayerFileModel(String path, String paletteFolder, String basePackageDots) {
        this.path = path;
        this.paletteFolder = paletteFolder;
        this.basePackageDots = basePackageDots;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(LAYER_HEADER);
        sb.append("   <folder name=\"FormDesignerPalette\">\n");
        for (String fld : this.folders2paletteEntries.keySet()) {
            List items = (List)this.folders2paletteEntries.get(fld);
            sb.append("        <folder name=\"");
            sb.append(fld);
            sb.append("\">\n");
            sb.append("            <attr name=\"SystemFileSystem.localizingBundle\" stringvalue=\"" + this.basePackageDots + ".Bundle\"/>\n");
            for (String palEntry : items) {
                sb.append("            <file name=\"");
                sb.append(palEntry);
                sb.append(".palette_item\" url=\"");
                sb.append(palEntry);
                sb.append("_paletteItem.xml\"/>\n");
            }
            sb.append("        </folder>\n");
        }
        sb.append("    </folder>\n");
        sb.append("    <folder name=\"org-netbeans-api-project-libraries\">\n");
        sb.append("        <folder name=\"Libraries\">\n");
        for (String libId : this.libraryNames) {
            sb.append("            <file name=\"");
            sb.append(libId);
            sb.append(".xml\" url=\"");
            sb.append(libId);
            sb.append(".xml\">\n");
            sb.append("                <attr name=\"SystemFileSystem.localizingBundle\" stringvalue=\"" + this.basePackageDots + ".Bundle\"/>\n");
            sb.append("            </file>\n");
        }
        sb.append("        </folder>\n    </folder>\n");
        sb.append("</filesystem>\n");
        return sb.toString();
    }

    public void addLibraryName(String libName) {
        this.libraryNames.add(libName);
    }

    public void addBeanEntry(String folder, String filename) {
        ArrayList<String> l = (ArrayList<String>)this.folders2paletteEntries.get(folder);
        if (l == null) {
            l = new ArrayList<String>();
            this.folders2paletteEntries.put(folder, l);
        }
        l.add(filename);
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(this.toString().getBytes("UTF-8"));
    }
}

