/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import beans2nbm.gen.FileModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JarToCopyModel
implements FileModel {
    private final String pathToJarOnDisk;
    private final String destPath;

    public JarToCopyModel(String destPath, String pathToJarOnDisk) {
        this.destPath = destPath;
        this.pathToJarOnDisk = pathToJarOnDisk;
        if (pathToJarOnDisk.equals("")) {
            throw new IllegalArgumentException("Empty path name");
        }
    }

    public String getPath() {
        return this.destPath;
    }

    public void write(OutputStream stream) throws IOException {
        File f = new File(this.pathToJarOnDisk);
        if (!f.exists() || !f.isFile()) {
            throw new IOException(f.getPath() + " missing or not a file");
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        JarToCopyModel.copy(is, stream);
        ((InputStream)is).close();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = is.read(BUFFER)) != -1) {
            os.write(BUFFER, 0, len);
        }
        return;
    }
}

