/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.gen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;

public class JarInfo {
    private File f;
    private String problem = null;
    private Checker checker = null;
    private static int ct = 0;
    private boolean dontScan = false;
    private boolean initialized = false;
    private List beans = null;
    private JarFile jar = null;
    private List entries = null;

    public JarInfo(String filespec) {
        if (filespec == null || filespec.trim().length() == 0) {
            throw new NullPointerException();
        }
        this.f = new File(filespec);
    }

    public String getFileName() {
        return this.f.getPath();
    }

    public String getProblem() {
        return this.problem;
    }

    public void scanImmediate(ScanObserver observer) {
        this.checker = new Checker(observer);
        observer.start();
        this.checker.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(ScanObserver observer) {
        if (this.initialized) {
            observer.done();
            return;
        }
        JarInfo jarInfo = this;
        synchronized (jarInfo) {
            if (this.checker != null) {
                this.checker.abort();
            }
            this.checker = new Checker(observer);
        }
        observer.start();
        Thread t = new Thread((Runnable)new Checker(observer), "Jar scan thread " + ct++);
        t.start();
    }

    public List getBeans() {
        if (!this.initialized && this.beans == null) {
            this.go(null);
        }
        return this.beans;
    }

    public void setDontScan(boolean val) {
        this.dontScan = val;
        if (this.beans == null) {
            this.beans = new ArrayList();
        }
    }

    public List getEntries() {
        return this.initialized ? this.entries : Collections.EMPTY_LIST;
    }

    private boolean init(Checker checker) {
        try {
            this.jar = new JarFile(this.f, true);
        }
        catch (IOException ioe) {
            this.problem = ioe.getMessage();
            if (checker != null) {
                checker.enqueueNotify(Integer.MIN_VALUE, this.problem);
            }
            return false;
        }
        return true;
    }

    private void go(Checker checker) {
        if (this.dontScan) {
            return;
        }
        if (this.init(checker)) {
            if (checker != null) {
                checker.enqueueNotify(25, null);
            }
            if (this.findBeans(checker)) {
                if (checker != null) {
                    checker.enqueueNotify(50, null);
                }
                if (this.findEntries(checker)) {
                    if (checker != null) {
                        checker.enqueueNotify(100, null);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    private boolean findBeans(Checker checker) {
        try {
            this.beans = new ArrayList();
            Manifest man = this.jar.getManifest();
            if (man == null) {
                checker.enqueueNotify(Integer.MIN_VALUE, "Manifest missing");
                return false;
            }
            Map<String, Attributes> m = man.getEntries();
            for (String name : m.keySet()) {
                Attributes atts;
                String val;
                if (!name.endsWith(".class") || (val = (atts = m.get(name)).getValue("Java-Bean")) == null || !"true".equalsIgnoreCase(val)) continue;
                this.beans.add(name);
            }
        }
        catch (IOException ioe) {
            this.problem = ioe.getMessage();
            checker.enqueueNotify(Integer.MIN_VALUE, this.problem);
            return false;
        }
        return true;
    }

    public String[] getBeansWithoutEntries() {
        if (this.entries == null) {
            this.findEntries(null);
        }
        HashSet<String> paths = new HashSet<String>();
        for (JarEntry entry : this.entries) {
            paths.add(entry.getName());
        }
        HashSet beans = new HashSet(this.beans);
        beans.removeAll(paths);
        String[] result = new String[beans.size()];
        result = beans.toArray(result);
        return result;
    }

    private boolean findEntries(Checker checker) {
        if (this.jar == null) {
            this.init(null);
        }
        this.entries = new ArrayList();
        try {
            int ix = 0;
            Enumeration<JarEntry> en = this.jar.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                if (++ix == 30 && checker != null) {
                    checker.enqueueNotify(75, null);
                }
                if (!entry.getName().endsWith(".class") || entry.getName().indexOf(36) >= 0) continue;
                this.entries.add(entry);
            }
        }
        catch (RuntimeException ioe) {
            ioe.printStackTrace();
            this.problem = ioe.getMessage();
            if (checker != null) {
                checker.enqueueNotify(Integer.MIN_VALUE, this.problem);
            }
            return false;
        }
        return true;
    }

    private class Checker
    implements Runnable {
        private final ScanObserver observer;
        private boolean aborted = false;
        private boolean done = false;
        private Object lock = new Object();
        private Notify notify = null;

        public Checker(ScanObserver observer) {
            this.observer = observer;
        }

        public void abort() {
            this.aborted = true;
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                JarInfo.this.go(this);
                ScanObserver scanObserver = this.observer;
                synchronized (scanObserver) {
                    this.observer.notifyAll();
                }
                this.done = true;
            }
            catch (Throwable throwable) {
                this.done = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Checker.this.observer.done();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueueNotify(int progress, String msg) {
            Object object = this.lock;
            synchronized (object) {
                if (msg != null) {
                    if (this.notify != null) {
                        this.notify.fail(msg);
                    } else {
                        this.notify = new Notify(Integer.MIN_VALUE);
                        this.notify.msg = msg;
                        SwingUtilities.invokeLater(this.notify);
                    }
                } else if (this.notify != null) {
                    this.notify.set(progress);
                } else {
                    SwingUtilities.invokeLater(new Notify(progress));
                }
            }
        }

        private class Notify
        implements Runnable {
            private int val;
            String msg = null;

            public Notify(int val) {
                this.val = val;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(int val) {
                Object object = Checker.this.lock;
                synchronized (object) {
                    this.val = val;
                }
            }

            public void fail(String msg) {
                this.msg = msg;
                this.set(Integer.MIN_VALUE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int currval;
                Object object = Checker.this.lock;
                synchronized (object) {
                    Checker.this.notify = null;
                    currval = this.val;
                }
                if (currval == Integer.MAX_VALUE) {
                    Checker.this.observer.done();
                } else if (currval == Integer.MIN_VALUE) {
                    Checker.this.observer.fail(this.msg);
                } else {
                    Checker.this.observer.progress(currval);
                }
            }
        }
    }

    public static interface ScanObserver {
        public void start();

        public void progress(int var1);

        public void fail(String var1);

        public void done();
    }
}

