/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm.ant;

import beans2nbm.Main;
import beans2nbm.gen.JarInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.modules.wizard.InstructionsPanel;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;

public class GenNbmTask
extends Task {
    private Map map = new HashMap();

    public void execute() throws BuildException {
        JarInfo info;
        boolean infoCreated;
        String[] keys = new String[]{"destFolder", "destFileName", "description", "libversion", "homepage", "codeName", "jarFileName", "author", "displayName", "license", "javaVersion"};
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            this.check(key);
        }
        String codeName = this.getCodeName();
        if (codeName.indexOf(".") < 0) {
            throw new BuildException("Code name should be a unique java package name, e.g. com.foo.mypackage");
        }
        if (this.getSourceJar() == null) {
            this.log("Source JAR/ZIP not specified.  It is not a requirement, but it helps people to debug.  Please consider including one.");
        }
        if (this.getDocsJar() == null) {
            this.log("Javadoc JAR/ZIP not specified.  It is not a requirement, but it helps use components.  Please consider including one.");
        }
        boolean bl = infoCreated = (info = (JarInfo)this.map.get("jarInfo")) == null;
        if (info == null) {
            info = new JarInfo((String)this.map.get("jarFileName"));
        }
        if (infoCreated) {
            O o = new O();
            info.scanImmediate(o);
            if (o.failMsg != null) {
                throw new BuildException(o.failMsg);
            }
        } else {
            this.log("Using supplied list of JavaBeans;  JAR Manifest ignored");
        }
        List l = info.getBeans();
        this.log("Beans: " + l);
        if (l.isEmpty()) {
            this.log("JAR contains no Java-Bean: sections in its manifest.  No components will be added to the componentpalette;  only the library will be added to the list of registered libraries in NetBeans.");
        } else {
            this.map.put("jarInfo", info);
        }
        String[] missing = info.getBeansWithoutEntries();
        if (missing.length > 0) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < missing.length; ++i) {
                b.append(missing[i]);
                if (i == missing.length - 1) continue;
                b.append(", ");
            }
            throw new BuildException("The following bean entries were declared but are not actually present in " + this.map.get("jarFileName") + ": " + b);
        }
        Main.BackgroundBuilder builder = new Main.BackgroundBuilder();
        R r = new R();
        builder.start(this.map, r);
        if (r.failMsg != null) {
            throw new BuildException(r.failMsg);
        }
    }

    public void addText(String txt) {
    }

    public void addBean(String path) {
        List l;
        path = path.trim();
        this.log("addBean string " + path);
        JarInfo info = (JarInfo)this.map.get("jarInfo");
        if (info == null) {
            info = new JarInfo((String)this.map.get("jarFileName"));
            info.setDontScan(true);
            this.map.put("jarInfo", info);
        }
        if (!(l = info.getBeans()).contains(path)) {
            info.getBeans().add(path);
        }
    }

    private void check(String key) throws BuildException {
        if (!this.map.containsKey(key)) {
            throw new BuildException(key + " not specified");
        }
    }

    public void setDestFolder(File val) {
        if (!val.exists()) {
            File base = super.getOwningTarget().getProject().getBaseDir();
            val = new File(base, val.getPath());
        }
        this.map.put("destFolder", val == null ? null : val.getAbsolutePath());
    }

    public void setDocsJar(File val) {
        if (!val.exists()) {
            File base = super.getOwningTarget().getProject().getBaseDir();
            val = new File(base, val.getPath());
        }
        this.map.put("docsJar", val == null ? null : val.getAbsolutePath());
    }

    public void setSourceJar(File val) {
        if (!val.exists()) {
            File base = super.getOwningTarget().getProject().getBaseDir();
            val = new File(base, val.getPath());
        }
        this.map.put("sourceJar", val == null ? null : val.getAbsolutePath());
    }

    public void setDestFileName(String val) {
        this.map.put("destFileName", val);
    }

    public void setDescription(String val) {
        this.map.put("description", val);
    }

    public void setVersion(String val) {
        this.map.put("libversion", val);
    }

    public void setHomepage(String val) {
        this.map.put("homepage", val);
    }

    public void setCodeName(String val) {
        this.map.put("codeName", val);
    }

    public void setJarFileName(File val) {
        if (!val.exists()) {
            File base = super.getOwningTarget().getProject().getBaseDir();
            val = new File(base, val.getPath());
        }
        this.map.put("jarFileName", val.getAbsolutePath());
    }

    public void setAuthor(String val) {
        this.map.put("author", val);
    }

    public void setDisplayName(String val) {
        this.map.put("displayName", val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLicense(String val) {
        InputStream stream = GenNbmTask.class.getResourceAsStream("/beans2nbm/ui/resources/" + val.toLowerCase() + ".txt");
        if (stream != null) {
            try {
                val = GenNbmTask.read(stream);
            }
            catch (IOException ioe) {
                this.log(ioe, 0);
            }
        } else {
            File f = new File(val);
            if (!f.exists() && !(f = new File(this.getProject().getBaseDir(), f.getPath())).exists()) {
                f = null;
            }
            if (f != null) {
                try {
                    BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f));
                    try {
                        val = GenNbmTask.read(fis);
                    }
                    catch (IOException ioe) {
                        this.log(ioe, 0);
                    }
                    finally {
                        ((InputStream)fis).close();
                    }
                }
                catch (IOException ioe) {
                    this.log(ioe, 0);
                }
            }
        }
        this.map.put("license", val);
    }

    public void setMinJDK(String val) {
        this.map.put("javaVersion", val);
    }

    public File getDestFolder() {
        String s = (String)this.map.get("destFolder");
        return s == null ? null : new File(s);
    }

    public String getDestFileName() {
        return (String)this.map.get("destFileName");
    }

    public String getDescription() {
        return (String)this.map.get("description");
    }

    public String getVersion() {
        return (String)this.map.get("libversion");
    }

    public String getHomepage() {
        return (String)this.map.get("homepage");
    }

    public String getCodeName() {
        return (String)this.map.get("codeName");
    }

    public String getJarFileName() {
        return (String)this.map.get("jarFileName");
    }

    public String getAuthor() {
        return (String)this.map.get("author");
    }

    public File getDocsJar() {
        String s = (String)this.map.get("docsJar");
        return s == null ? null : new File(s);
    }

    public File getSourceJar() {
        String s = (String)this.map.get("sourceJar");
        return s == null ? null : new File(s);
    }

    public String getDisplayName() {
        return (String)this.map.get("displayName");
    }

    public String getLicense() {
        return (String)this.map.get("license");
    }

    public String getMinJDK() {
        return (String)this.map.get("javaVersion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        byte[] BUFFER = new byte[4096];
        try {
            int len;
            while ((len = is.read(BUFFER)) != -1) {
                os.write(BUFFER, 0, len);
            }
            byte[] b = os.toByteArray();
            String string = new String(b, "UTF-8");
            return string;
        }
        finally {
            is.close();
        }
    }

    public Bean createBean() {
        return new Bean(this);
    }

    public static class Bean {
        public String text;
        private final GenNbmTask task;

        Bean(GenNbmTask task) {
            this.task = task;
        }

        public void addText(String text) {
            this.text = text;
            this.task.addBean(text);
        }
    }

    class R
    implements ResultProgressHandle {
        String failMsg;

        R() {
        }

        public void setProgress(int currentStep, int totalSteps) {
        }

        public void setProgress(String description, int currentStep, int totalSteps) {
        }

        public void setBusy(String description) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(Object result) {
            R r = this;
            synchronized (r) {
                this.notifyAll();
            }
            while (result instanceof Summary) {
                result = ((Summary)result).getResult();
            }
            GenNbmTask.this.log("Created " + result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(String message, boolean canNavigateBack) {
            Thread.dumpStack();
            this.failMsg = message;
            R r = this;
            synchronized (r) {
                this.notifyAll();
            }
        }

        public void addProgressComponents(InstructionsPanel panel) {
        }

        public boolean isRunning() {
            return true;
        }
    }

    class O
    implements JarInfo.ScanObserver {
        String failMsg;

        O() {
        }

        public void start() {
            GenNbmTask.this.log("Scanning JAR for JavaBeans");
        }

        public void progress(int progress) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fail(String msg) {
            this.failMsg = msg;
            O o = this;
            synchronized (o) {
                this.notifyAll();
            }
        }

        public void done() {
            GenNbmTask.this.log("Completed scan, found ");
        }
    }
}

