/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm;

import java.io.CharConversionException;
import java.io.IOException;

public final class XMLUtil {
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private XMLUtil() {
    }

    public static String toAttributeValue(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(val)) {
            return val;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('\'' == ch) {
                buf.append("&apos;");
                continue;
            }
            if ('\"' == ch) {
                buf.append("&quot;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toElementContent(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(val)) {
            return val;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('>' == ch && i > 1 && val.charAt(i - 2) == ']' && val.charAt(i - 1) == ']') {
                buf.append("&gt;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toHex(byte[] val, int start, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            byte b = val[start + i];
            buf.append(DEC2HEX[(b & 0xF0) >> 4]);
            buf.append(DEC2HEX[b & 0xF]);
        }
        return buf.toString();
    }

    public static byte[] fromHex(char[] hex, int start, int len) throws IOException {
        if (hex == null) {
            throw new IOException("null");
        }
        int i = hex.length;
        if (i % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] magic = new byte[i / 2];
        while (i > 0) {
            String g = new String(hex, i - 2, 2);
            try {
                magic[i / 2 - 1] = (byte)Integer.parseInt(g, 16);
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
            i -= 2;
        }
        return magic;
    }

    private static boolean checkAttributeCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block4: for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    escape = true;
                    continue block4;
                }
                default: {
                    if (ch >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }

    private static boolean checkContentCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block5: for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (escape) continue block5;
                    escape = i > 0 && chars.charAt(i - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    escape = true;
                    continue block5;
                }
                default: {
                    if (ch >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }
}

