/*
 * Decompiled with CFR 0.152.
 */
package beans2nbm;

import beans2nbm.Brancher;
import beans2nbm.XMLUtil;
import beans2nbm.gen.JarInfo;
import beans2nbm.gen.JarToCopyModel;
import beans2nbm.gen.LayerFileModel;
import beans2nbm.gen.LibDescriptorModel;
import beans2nbm.gen.ModuleInfoModel;
import beans2nbm.gen.ModuleModel;
import beans2nbm.gen.ModuleXMLModel;
import beans2nbm.gen.NbmFileModel;
import beans2nbm.gen.PaletteItemFileModel;
import beans2nbm.ui.AuthorInfoPage;
import beans2nbm.ui.BeanItem;
import beans2nbm.ui.InstructionsPage;
import beans2nbm.ui.LibDataPage;
import beans2nbm.ui.LocateJarPage;
import beans2nbm.ui.OutputLocationPage;
import beans2nbm.ui.SelectBeansPage;
import java.io.BufferedOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;

public class Main {
    private static final String BASE = "<target name=\"nbm\" description=\"Generate a NetBeans Module\">\n  <taskdef classpath=\"lib/beans2nbm.jar\" classname=\"beans2nbm.ant.GenNbmTask\"\n  name=\"nbm\"/>\n\n  <nbm destFolder=\"#DEST_FOLDER\" destFileName=\"#NBM_NAME\"\n    description=\"#DESCRIPTION\" version=\"1.0\" homepage=\"#HOMEPAGE\"\n    codeName=\"#CODENAME\" jarFileName=\"#JARFILENAME\" \n    author=\"#AUTHOR\" displayName=\"#DISPLAY_NAME\" license=\"#LICENSE\"\n    minJDK=\"#MIN_JDK\" sourceJar=\"#SOURCE_JAR\" docsJar=\"#DOCS_JAR\"/>\n</target>";

    static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && "reset".equals(args[0])) {
            Preferences.userNodeForPackage(InstructionsPage.class).putBoolean("DontShowInstructions", true);
        }
        Main.setLookAndFeel();
        WizardDisplayer.showWizard(new Brancher(new WRP()).createWizard());
    }

    static Class[] getPageList() {
        Class[] classArray;
        if (InstructionsPage.shouldShowInstructions()) {
            Class[] classArray2 = new Class[6];
            classArray2[0] = InstructionsPage.class;
            classArray2[1] = LocateJarPage.class;
            classArray2[2] = SelectBeansPage.class;
            classArray2[3] = LibDataPage.class;
            classArray2[4] = AuthorInfoPage.class;
            classArray = classArray2;
            classArray2[5] = OutputLocationPage.class;
        } else {
            Class[] classArray3 = new Class[5];
            classArray3[0] = LocateJarPage.class;
            classArray3[1] = SelectBeansPage.class;
            classArray3[2] = LibDataPage.class;
            classArray3[3] = AuthorInfoPage.class;
            classArray = classArray3;
            classArray3[4] = OutputLocationPage.class;
        }
        Class[] pages = classArray;
        return pages;
    }

    public static void go(Class[] pages) {
        Wizard wiz = WizardPage.createWizard(pages, (WizardPage.WizardResultProducer)new WRP());
        File f = (File)WizardDisplayer.showWizard(wiz);
        if (f != null) {
            System.out.println("Created " + f.getPath());
        }
    }

    private static String getAntInstructions(Map map) {
        String s = BASE;
        map = new HashMap(map);
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (!(val instanceof String)) continue;
            try {
                val = XMLUtil.toAttributeValue(val.toString());
                map.put(key, val);
            }
            catch (CharConversionException cce) {}
        }
        String destFolder = (String)map.get("destFolder");
        String destFileName = (String)map.get("destFileName");
        String description = (String)map.get("description");
        String version = (String)map.get("libversion");
        String homepage = (String)map.get("homepage");
        String codeName = (String)map.get("codeName");
        String jarFileName = (String)map.get("jarFileName");
        String author = (String)map.get("author");
        String docsJar = (String)map.get("docsJar");
        String sourceJar = (String)map.get("sourceJar");
        String displayName = (String)map.get("displayName");
        String license = (String)map.get("license");
        String minJDK = (String)map.get("javaVersion");
        String licenseFile = (String)map.get("licenseFile");
        String licenseName = (String)map.get("licenseName");
        license = licenseName != null ? licenseName : (licenseFile != null ? licenseFile : "path/to/license.txt");
        s = s.replace("#DEST_FOLDER", destFolder);
        s = s.replace("#NBM_NAME", destFileName);
        s = s.replace("#DESCRIPTION", description);
        s = s.replace("#CODENAME", codeName);
        s = s.replace("#JARFILENAME", jarFileName);
        s = s.replace("#AUTHOR", author);
        s = s.replace("#MIN_JDK", minJDK);
        s = s.replace("#SOURCE_JAR", sourceJar == null ? "sourceJar.jar" : sourceJar);
        s = s.replace("#DOCS_JAR", docsJar == null ? "docsJar.jar" : docsJar);
        s = s.replace("#DISPLAY_NAME", displayName);
        s = s.replace("#LICENSE", license);
        s = s.replace("#CODENAME", codeName);
        s = s.replace("#VERSION", version);
        s = s.replace("#HOMEPAGE", homepage);
        return s;
    }

    private static final void outMap(Map wizardData) {
        for (Object key : wizardData.keySet()) {
            Object v = wizardData.get(key);
        }
    }

    private static class WRP
    implements WizardPage.WizardResultProducer {
        private WRP() {
        }

        public Object finish(Map map) throws WizardException {
            return new BackgroundBuilder();
        }

        public boolean cancel(Map m) {
            System.exit(0);
            return true;
        }
    }

    public static class BackgroundBuilder
    extends DeferredWizardResult {
        public BackgroundBuilder() {
            super(false);
        }

        public void start(Map map, ResultProgressHandle progress) {
            int total = 15;
            progress.setProgress("Building NBM", 1, 15);
            String destFolder = (String)map.get("destFolder");
            String destFileName = (String)map.get("destFileName");
            String description = (String)map.get("description");
            String version = (String)map.get("libversion");
            String homepage = (String)map.get("homepage");
            JarInfo jarInfo = (JarInfo)map.get("jarInfo");
            String codeName = (String)map.get("codeName");
            String jarFileName = (String)map.get("jarFileName");
            String author = (String)map.get("author");
            String docsJar = (String)map.get("docsJar");
            String sourceJar = (String)map.get("sourceJar");
            String displayName = (String)map.get("displayName");
            String license = (String)map.get("license");
            String minJDK = (String)map.get("javaVersion");
            File outDir = new File(destFolder);
            if (!outDir.isDirectory()) {
                throw new IllegalArgumentException();
            }
            File f = new File(outDir, destFileName);
            if (f.exists()) {
                f.delete();
            }
            try {
                if (!f.createNewFile()) {
                    progress.failed("Could not create " + f.getPath(), true);
                    return;
                }
                progress.setProgress(2, 15);
                char[] cname = codeName.toCharArray();
                for (int i = 0; i < cname.length; ++i) {
                    if (cname[i] != '.') continue;
                    cname[i] = 45;
                }
                String moduleJarName = new String(cname) + ".jar";
                String jarFileNameSimple = new File(jarFileName).getName();
                progress.setProgress(3, 10);
                NbmFileModel nbm = new NbmFileModel(f.getPath());
                progress.setProgress(3, 15);
                ModuleModel module = new ModuleModel("netbeans/modules/" + moduleJarName, codeName, description, version, displayName, minJDK);
                progress.setProgress(4, 15);
                ModuleInfoModel infoXml = new ModuleInfoModel(module, homepage, author, license);
                progress.setProgress(5, 15);
                nbm.add(module);
                nbm.add(infoXml);
                JarToCopyModel libJar = new JarToCopyModel("netbeans/libs/" + jarFileNameSimple, jarFileName);
                progress.setProgress(7, 15);
                nbm.add(libJar);
                String srcFileNameSimple = null;
                if (sourceJar != null && !"".equals(sourceJar)) {
                    srcFileNameSimple = new File(sourceJar).getName();
                    JarToCopyModel srcJarMdl = new JarToCopyModel("netbeans/sources/" + srcFileNameSimple, sourceJar);
                    nbm.add(srcJarMdl);
                }
                progress.setProgress(8, 15);
                String docsJarNameSimple = null;
                if (docsJar != null && !"".equals(docsJar)) {
                    docsJarNameSimple = new File(docsJar).getName();
                    JarToCopyModel docsJarMdl = new JarToCopyModel("netbeans/docs/" + docsJarNameSimple, docsJar);
                    nbm.add(docsJarMdl);
                }
                progress.setProgress(9, 15);
                cname = codeName.toCharArray();
                for (int i = 0; i < cname.length; ++i) {
                    if (cname[i] != '.') continue;
                    cname[i] = 47;
                }
                String codeNameSlashes = new String(cname);
                char[] c = displayName.toCharArray();
                for (int i = 0; i < c.length; ++i) {
                    if (!Character.isWhitespace(c[i])) continue;
                    c[i] = 95;
                }
                String companyNameUnderscores = new String(c);
                LayerFileModel layer = new LayerFileModel(codeNameSlashes + "/layer.xml", companyNameUnderscores, codeName);
                module.addFileEntry(layer);
                progress.setProgress(10, 15);
                layer.addLibraryName(companyNameUnderscores);
                LibDescriptorModel libDesc = new LibDescriptorModel(codeNameSlashes + "/" + companyNameUnderscores + ".xml", companyNameUnderscores, codeName, jarFileNameSimple, srcFileNameSimple, docsJarNameSimple);
                module.addFileEntry(libDesc);
                module.addFileDisplayName("org-netbeans-api-project-libraries/Libraries/" + companyNameUnderscores + ".xml", displayName);
                module.addFileDisplayName(companyNameUnderscores, displayName);
                progress.setProgress(11, 15);
                if (jarInfo != null) {
                    for (String pathInBeanJar : jarInfo.getBeans()) {
                        BeanItem bi = new BeanItem(pathInBeanJar);
                        String beanClassName = bi.getClassName();
                        String beanSimpleName = bi.getSimpleName();
                        String paletteItemPathInLayer = "FormDesignerPalette/" + companyNameUnderscores + "/" + beanSimpleName + ".palette_item";
                        PaletteItemFileModel palMdl = new PaletteItemFileModel(codeNameSlashes + "/" + beanSimpleName + "_paletteItem.xml", companyNameUnderscores, beanClassName);
                        module.addFileEntry(palMdl);
                        layer.addBeanEntry(companyNameUnderscores, beanSimpleName);
                        module.addFileDisplayName(paletteItemPathInLayer, beanClassName);
                    }
                }
                progress.setProgress(11, 15);
                module.addFileDisplayName(codeNameSlashes + "/" + companyNameUnderscores, displayName);
                ModuleXMLModel mxml = new ModuleXMLModel(codeName, version);
                nbm.add(mxml);
                progress.setProgress(12, 15);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                progress.setProgress(13, 15);
                nbm.write(out);
                progress.setProgress(14, 15);
                ((OutputStream)out).close();
                progress.setProgress(15, 15);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                progress.failed(ioe.getMessage(), true);
            }
            String summaryInfo = "Created " + f.getPath() + " successfully.\n\nYou can also generate " + "new versions of this module via an Ant script, using the " + "JAR file you are running in order to see this wizard, e.g:\n\n" + Main.getAntInstructions(map) + "\n\nThe sourceJar and " + "docsJar attributes are optional.  License may be any of " + "the ones named in this wizard (apache, artistic, bsd," + "cddl, gpl, lgpl), or a path to a file containing a " + "license, or the license text itself.\n\nRemember always to " + "increment the version number when you release a new " + "version.";
            summaryInfo = summaryInfo.replace("sourceJar=\"\"", "");
            summaryInfo = summaryInfo.replace("docsJar=\"\"", "");
            progress.finished(Summary.create(summaryInfo, (Object)f));
        }
    }
}

