/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner.parser;

import com.agitar.common.types.MethodSignature;
import com.agitar.common.util.ClassCacheMap;
import com.agitar.common.util.IOUtility;
import com.agitar.testrunner.UserProject;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TreeClassAdapter;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.DataflowInterpreter;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;

public class TestClassParser {
    private static Map classNodeCache = new ClassCacheMap();

    private static ClassNode getClassNode(UserProject project, Class clazz) {
        ClassNode cn = (ClassNode)classNodeCache.get(clazz.getName());
        if (cn == null) {
            cn = TestClassParser.buildTree(project, clazz);
            if (cn == null) {
                return null;
            }
            classNodeCache.put(clazz.getName(), cn);
        }
        return cn;
    }

    public static String getMethodUnderTest(UserProject project, String testMethod, Class testClass) {
        ClassNode cn = TestClassParser.getClassNode(project, testClass);
        if (cn == null) {
            return null;
        }
        MethodNode methodNode = TestClassParser.findMethodNode(cn, testMethod);
        if (methodNode == null) {
            return null;
        }
        try {
            String key = TestClassParser.findMethodUnderTest(cn, methodNode, testClass.getName());
            return key;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getTestHelpers(UserProject project, String testMethod, Class testClass) throws Exception {
        ClassNode cn = TestClassParser.getClassNode(project, testClass);
        if (cn == null) {
            return new String[0];
        }
        MethodNode methodNode = TestClassParser.findMethodNode(cn, testMethod);
        if (methodNode == null) {
            return null;
        }
        return TestClassParser.findTestHelpers(project, cn, methodNode);
    }

    private static String[] findTestHelpers(UserProject project, ClassNode classNode, MethodNode methodNode) throws Exception {
        HashSet<String> foundTestHelpers = new HashSet<String>();
        Iterator i = methodNode.instructions.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof MethodInsnNode)) continue;
            MethodInsnNode methodCall = (MethodInsnNode)o;
            if (!methodCall.name.startsWith("create")) continue;
            ClassNode owningClass = TestClassParser.getClassNode(project, project.getClassLoader().loadClass(methodCall.owner.replace('/', '.')));
            if (!owningClass.interfaces.contains("com/agitar/lib/TestHelper")) continue;
            foundTestHelpers.add(MethodSignature.fromRawForm((String)methodCall.owner.replace('/', '.'), (String)methodCall.name, (String)methodCall.desc).getFullKey());
        }
        return foundTestHelpers.toArray(new String[foundTestHelpers.size()]);
    }

    private static ClassNode buildTree(UserProject project, Class clazz) {
        File path = IOUtility.getFile((Class)clazz);
        byte[] bytes = project.getBytes(path, clazz.getName().replace('.', '/') + ".class");
        ClassReader classReader = new ClassReader(bytes);
        TreeClassAdapter tca = new TreeClassAdapter(null);
        classReader.accept((ClassVisitor)tca, true);
        return tca.classNode;
    }

    private static MethodNode findMethodNode(ClassNode cn, String methodName) {
        Iterator i = cn.methods.iterator();
        while (i.hasNext()) {
            MethodNode mn = (MethodNode)i.next();
            if (!mn.name.equals(methodName) || !mn.desc.endsWith("()V")) continue;
            return mn;
        }
        return null;
    }

    private static String findMethodUnderTest(ClassNode classNode, MethodNode methodNode, String testClassName) throws Exception {
        String tc = testClassName.replace('.', '/');
        DataflowInterpreter dfi = new DataflowInterpreter();
        Analyzer analyzer = new Analyzer((Interpreter)dfi);
        analyzer.analyze(classNode, methodNode);
        List insns = methodNode.instructions;
        Frame[] frames = analyzer.getFrames();
        int lastPos = 0;
        MethodInsnNode lastCall = null;
        for (int curPos = 0; curPos < frames.length; ++curPos) {
            MethodInsnNode methodCall;
            Frame f = frames[curPos];
            if (f.getStackSize() != 0 || (methodCall = TestClassParser.findMethodCall(insns, curPos, lastPos)) == null) continue;
            if ((methodCall.owner.equals(tc) || methodCall.owner.endsWith("/AgitarTestCase") || methodCall.owner.endsWith("framework/Assert")) && (methodCall.name.startsWith("assert") || methodCall.name.equals("fail"))) {
                if (lastCall == null) {
                    return null;
                }
                return MethodSignature.fromRawForm((String)lastCall.owner, (String)lastCall.name, (String)lastCall.desc).getFullKey();
            }
            lastCall = methodCall;
        }
        return null;
    }

    private static MethodInsnNode findMethodCall(List insns, int curPos, int lastPos) {
        while (curPos >= lastPos) {
            if (insns.get(curPos) instanceof MethodInsnNode) {
                return (MethodInsnNode)insns.get(curPos);
            }
            --curPos;
        }
        return null;
    }
}

