/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.logging.DumpableLogManager;
import com.agitar.common.types.ClassName;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.InitializationHelper;
import com.agitar.common.util.ReflectionCacheRegistry;
import com.agitar.common.util.TestClassMapper;
import com.agitar.instrument.CallbackInstrumenter;
import com.agitar.instrument.ClassLoaderFieldInstrumenter;
import com.agitar.instrument.CoverageInstrumenter;
import com.agitar.instrument.InstrumentationManager;
import com.agitar.instrument.MockInstrumenter;
import com.agitar.instrument.TargetFieldFinder;
import com.agitar.lib.junit.AgitarTestCase;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.mockingbird.instrumenter.ISubclass;
import com.agitar.mockingbird.instrumenter.ThreadAndSystemInOutErrSubstitution;
import com.agitar.security.AgPolicy;
import com.agitar.testrunner.ClassInfo;
import com.agitar.testrunner.ExecutionProperties;
import com.agitar.testrunner.InstrumentingClassLoader;
import com.agitar.testrunner.Paths;
import com.agitar.testrunner.TestCaseMethods;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class UserProject
implements TestClassMapper.ClassList {
    private final String classPathString;
    private final String projectRoot;
    private final File[] classPath;
    private InstrumentingClassLoader classLoader;
    private String projectName;
    private String[] testClassNames;
    private String resultsDir;
    private Paths classPaths;
    private boolean currentLoaderHasCoverage = false;
    private boolean currentLoaderHasCallback = false;
    private boolean currentLoaderHasMock = false;

    public UserProject(String classPath, String projectRoot, String projectName, String[] testClassNames, boolean instrumentationOn) {
        this.projectRoot = projectRoot;
        this.projectName = projectName;
        this.classPathString = classPath.replace(';', File.pathSeparatorChar);
        String[] classPathArray = this.classPathString.split(File.pathSeparator);
        ArrayList<File> classPathFiles = new ArrayList<File>();
        for (int i = 0; i < classPathArray.length; ++i) {
            if (!new File(classPathArray[i]).exists()) continue;
            classPathFiles.add(new File(classPathArray[i]));
        }
        this.classPath = classPathFiles.toArray(new File[classPathFiles.size()]);
        this.classPaths = new Paths(this.classPath);
        this.testClassNames = testClassNames;
        this.initSystemProperties();
        AgPolicy policy = InitializationHelper.installJUnitSecurityPolicy();
        policy.addReadPermissionsForClasspath(this.classPathString);
        this.resetClassLoader(null, instrumentationOn, instrumentationOn, instrumentationOn);
    }

    private void initSystemProperties() {
        ExecutionProperties.init();
        AgitarProperties.setUserProperty((String)"java.class.path", (String)(System.getProperty("java.class.path", "") + File.pathSeparator + this.classPathString));
        InitializationHelper.initializeSystemProperties();
    }

    public File[] getClassPath() {
        return this.classPath;
    }

    public File getClassPathElement(final String fileName) {
        return (File)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return UserProject.this.classPaths.getClassPathElement(fileName, true);
            }
        });
    }

    public File[] getAllClassPathElements(final String fileName) {
        return (File[])AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return UserProject.this.classPaths.getAllClassPathElements(fileName, true);
            }
        });
    }

    public byte[] getBytes(final File classPath, final String fileName) {
        return (byte[])AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                InputStream inputStream;
                block10: {
                    block9: {
                        byte[] byArray;
                        block11: {
                            inputStream = null;
                            if (!classPath.isFile()) break block9;
                            try {
                                JarFile jarFile = new JarFile(classPath);
                                JarEntry jarEntry = jarFile.getJarEntry(fileName);
                                if (jarEntry == null) break block10;
                                inputStream = jarFile.getInputStream(jarEntry);
                                byArray = UserProject.this.inputStreamToBytes(inputStream);
                                break block11;
                            }
                            catch (Exception ex) {
                                break block10;
                            }
                            {
                                catch (Throwable throwable) {
                                    IOUtility.close(inputStream, (boolean)true);
                                    throw throwable;
                                }
                            }
                        }
                        IOUtility.close((InputStream)inputStream, (boolean)true);
                        return byArray;
                    }
                    if (new File(classPath, fileName).exists()) {
                        byte[] ex;
                        try {
                            inputStream = new FileInputStream(new File(classPath, fileName));
                            ex = UserProject.this.inputStreamToBytes(new BufferedInputStream(inputStream));
                        }
                        catch (Exception exception) {}
                        IOUtility.close((InputStream)inputStream, (boolean)true);
                        return ex;
                    }
                }
                IOUtility.close(inputStream, (boolean)true);
                return null;
            }
        });
    }

    private byte[] inputStreamToBytes(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        byte[] totalBuffer = new byte[]{};
        int numRead = 0;
        while ((numRead = is.read(buffer)) != -1) {
            byte[] newBuf = new byte[totalBuffer.length + numRead];
            System.arraycopy(totalBuffer, 0, newBuf, 0, totalBuffer.length);
            System.arraycopy(buffer, 0, newBuf, totalBuffer.length, numRead);
            totalBuffer = newBuf;
        }
        return totalBuffer;
    }

    private List allSupers(String className) {
        ArrayList<String> allSupers = new ArrayList<String>();
        try {
            ClassInfo thisClassInfo = ClassInfo.get(this, className);
            while (thisClassInfo.getSuperClass() != null) {
                thisClassInfo = thisClassInfo.getSuperClass();
                allSupers.add(thisClassInfo.getName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return allSupers;
    }

    public boolean shouldBeInstrumentedForCallback(final String className, final Set targetClassNames) {
        return (Boolean)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return UserProject.this.isSubclassOfAbstractTarget(className, targetClassNames) || UserProject.this.isRoommateClass(className, targetClassNames);
            }
        });
    }

    private boolean isRoommateClass(String className, Set targetClassNames) {
        ClassName maybeRoommate = ClassName.get((String)className);
        if (maybeRoommate.isInnerClass()) {
            String outerName = maybeRoommate.getOutermostClass().getFullTypeName();
            return targetClassNames.contains(outerName);
        }
        return false;
    }

    private boolean isSubclassOfAbstractTarget(String className, Set targetClassNames) {
        try {
            ClassInfo thisClassInfo = ClassInfo.get(this, className);
            while (thisClassInfo.getSuperClass() != null) {
                ClassInfo superClass = thisClassInfo.getSuperClass();
                if (targetClassNames.contains(superClass.getName())) {
                    return superClass.isAbstract();
                }
                thisClassInfo = superClass;
            }
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public boolean isSubclassOf(final String className, final String superClassName) {
        return (Boolean)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (className.equals(superClassName)) {
                        return Boolean.TRUE;
                    }
                    ClassInfo thisClassInfo = ClassInfo.get(UserProject.this, className);
                    while (thisClassInfo.getSuperClass() != null) {
                        ClassInfo superClass = thisClassInfo.getSuperClass();
                        if (superClassName.equals(superClass.getName())) {
                            return Boolean.TRUE;
                        }
                        thisClassInfo = superClass;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return Boolean.FALSE;
            }
        });
    }

    public byte[] getClassBytes(final String className) {
        return (byte[])AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                String fileName = className.replace('.', '/') + ".class";
                return UserProject.this.getBytes(UserProject.this.getClassPathElement(fileName), fileName);
            }
        });
    }

    public boolean containsClass(final String className) {
        return (Boolean)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return UserProject.this.getClassPathElement(className.replace('.', '/') + ".class") != null;
            }
        });
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setAgitarResultsDirectory(String resultsDir) {
        this.resultsDir = resultsDir;
    }

    public String getAgitarResultsDirectory() throws IOException {
        if (this.resultsDir == null) {
            this.resultsDir = this.getProjectRoot() + File.separator + "agitar" + File.separator + ".results";
        }
        File f = new File(this.resultsDir);
        f.mkdirs();
        if (!f.exists()) {
            throw new IOException("Cannot create directory: " + this.resultsDir);
        }
        return this.resultsDir;
    }

    public File getAgitarResultsDirectoryAsFile() throws IOException {
        return new File(this.getAgitarResultsDirectory());
    }

    public Set findAllClassNames() {
        return (Set)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                HashSet classNames = new HashSet();
                for (int i = 0; i < UserProject.this.classPath.length; ++i) {
                    if (UserProject.this.classPath[i].isFile()) {
                        classNames.addAll(UserProject.this.findClassesInJarFile(UserProject.this.classPath[i]));
                        continue;
                    }
                    classNames.addAll(UserProject.this.findClassesInDirectory(UserProject.this.classPath[i], ""));
                }
                String[] names = classNames.toArray(new String[classNames.size()]);
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    if (!name.startsWith("com.agitar.") && !name.startsWith("junit.")) continue;
                    classNames.remove(name);
                }
                return classNames;
            }
        });
    }

    private List findClassesInJarFile(File jarFile) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            JarFile theJarFile = new JarFile(jarFile);
            Enumeration<JarEntry> e = theJarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().toLowerCase().endsWith(".class")) continue;
                list.add(this.fileNameToClassName(entry.getName()));
            }
            theJarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    private List findClassesInDirectory(File dir, String subdir) {
        ArrayList<String> list = new ArrayList<String>();
        File subDir = new File(dir, subdir);
        if (!subDir.isDirectory()) {
            return list;
        }
        File[] childFiles = subDir.listFiles();
        for (int i = 0; i < childFiles.length; ++i) {
            if (childFiles[i].isFile() && childFiles[i].getName().toLowerCase().endsWith(".class")) {
                list.add(this.fileNameToClassName(subdir + "/" + childFiles[i].getName()));
                continue;
            }
            if (!childFiles[i].isDirectory()) continue;
            list.addAll(this.findClassesInDirectory(dir, subdir + File.separator + childFiles[i].getName()));
        }
        return list;
    }

    private String fileNameToClassName(String fileName) {
        if (fileName.startsWith("/") || fileName.startsWith("\\")) {
            fileName = fileName.substring(1);
        }
        return fileName.replace('/', '.').replace('\\', '.').replaceAll("\\.class$", "");
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public boolean contains(String name) {
        return this.containsClass(name);
    }

    public void resetClassLoaderForInstrumentationTesting(boolean coverageOn, boolean callbackOn, boolean mockOn) {
        this.dumpCurrentClassLoader();
        this.resetInstrumentersAndStatics();
        this.classLoader = new InstrumentingClassLoader(this);
        ReflectionCacheRegistry.pushContextClassLoader((ClassLoader)this.classLoader);
        if (coverageOn) {
            InstrumentationManager.registerInstrumenter(new CoverageInstrumenter(null, null));
        }
        if (callbackOn) {
            InstrumentationManager.registerInstrumenter(new CallbackInstrumenter(this, null, null));
        }
        if (mockOn) {
            InstrumentationManager.registerInstrumenter(new MockInstrumenter(null, null));
        }
        this.currentLoaderHasCoverage = coverageOn;
        this.currentLoaderHasCallback = callbackOn;
        this.currentLoaderHasMock = mockOn;
    }

    public void resetClassLoader(String testClassName, boolean coverageForTest, boolean callbackForTest, boolean mockForTest) {
        Set targetClasses;
        boolean shouldResetLoader;
        boolean callbackOn = false;
        boolean mockOn = false;
        if (testClassName != null && this.isAgitarTestCase(testClassName)) {
            callbackOn = true;
            mockOn = true;
        }
        boolean coverageDictatesReset = coverageForTest && !this.currentLoaderHasCoverage;
        boolean bl = shouldResetLoader = this.classLoader == null || this.currentLoaderHasCallback || this.currentLoaderHasMock || callbackOn || mockOn || coverageDictatesReset;
        if (shouldResetLoader) {
            ExecutionProperties.restore();
            this.dumpCurrentClassLoader();
            this.initSystemProperties();
            this.classLoader = new InstrumentingClassLoader(this);
            ReflectionCacheRegistry.pushContextClassLoader((ClassLoader)this.classLoader);
            this.currentLoaderHasCallback = callbackOn;
            this.currentLoaderHasCoverage = coverageForTest;
            this.currentLoaderHasMock = mockOn;
        }
        this.resetInstrumentersAndStatics();
        if (coverageForTest) {
            InstrumentationManager.registerInstrumenter(new CoverageInstrumenter(null, null));
            InstrumentationManager.registerInstrumenter(new ClassLoaderFieldInstrumenter(false, Collections.EMPTY_SET));
        }
        if (callbackOn) {
            targetClasses = this.getTargetClasses(testClassName);
            InstrumentationManager.registerInstrumenter(new CallbackInstrumenter(this, Collections.singleton(testClassName), targetClasses));
        }
        if (mockOn) {
            targetClasses = this.getTargetClasses(testClassName);
            InstrumentationManager.registerInstrumenter(new MockInstrumenter(Collections.singleton(testClassName), targetClasses));
            ThreadAndSystemInOutErrSubstitution.setISubclass((ISubclass)new ISubclass(){

                public boolean isSubclassOf(String subClassName, String superClassName) {
                    return UserProject.this.isSubclassOf(subClassName, superClassName);
                }
            });
        }
        if (shouldResetLoader) {
            DumpableLogManager.dump();
        }
    }

    private Set getTargetClasses(String testClassName) {
        String directTargetName = new TargetFieldFinder().findTarget(this.getClassBytes(testClassName));
        if (directTargetName == null) {
            directTargetName = new TestClassMapper((TestClassMapper.ClassList)this).getTargetClassFromName(testClassName);
        }
        if (directTargetName == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> targets = new HashSet<String>();
        targets.add(directTargetName);
        Mockingbird.methodInterceptorNotAllowed((String)directTargetName);
        targets.addAll(this.allSupers(directTargetName));
        return targets;
    }

    public boolean isAgitarTestCase(String testClassName) {
        return this.isSubclassOf(testClassName, AgitarTestCase.class.getName());
    }

    private void dumpCurrentClassLoader() {
        if (this.classLoader == null) {
            return;
        }
        ClassLoader poppedLoader = ReflectionCacheRegistry.popContextClassLoader();
        if (poppedLoader != this.classLoader) {
            AgitarLogger.getDiagnosticLogger((String)"UserProject").warning("popped classloader [" + poppedLoader + "] different from UserProject classloader [" + this.classLoader + "]");
        }
        this.classLoader = null;
    }

    private void resetInstrumentersAndStatics() {
        InstrumentationManager.deregisterAllInstrumenters();
        this.initSystemProperties();
        Mockingbird.clear();
    }

    public String[] sortAgitarTestClassesLast(boolean includeManualTests) {
        TestCaseMethods testClassHolder = TestCaseMethods.fromTestClassNameArray(this.testClassNames);
        testClassHolder.sortAgitarTestClassesLast(this, includeManualTests);
        return testClassHolder.getTestClassNames();
    }

    public String[] sortAgitarTestClassesLast() {
        return this.sortAgitarTestClassesLast(true);
    }
}

