/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner;

import com.agitar.common.util.Assertions;
import com.agitar.testrunner.TestCaseMethod;
import com.agitar.testrunner.UserProject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class TestCaseMethods {
    public static final String TEST_CASE_METHOD_SEPARATOR = ", ";
    private ArrayList testCaseMethods = new ArrayList();
    private HashMap testClassNames = new HashMap();

    public void mergeInClassNames(TestCaseMethods classNames) {
        for (int i = 0; i < classNames.getTestNumber(); ++i) {
            TestCaseMethod nextMethod = classNames.get(i);
            if (this.testClassNames.keySet().contains(nextMethod.getTestClassName())) continue;
            this.addTestMethod(nextMethod);
        }
    }

    private void addTestMethod(TestCaseMethod testMethod) {
        this.testCaseMethods.add(testMethod);
        Integer numberOfTimes = (Integer)this.testClassNames.get(testMethod.getTestClassName());
        if (numberOfTimes == null) {
            this.testClassNames.put(testMethod.getTestClassName(), new Integer(1));
        } else {
            this.testClassNames.put(testMethod.getTestClassName(), new Integer(numberOfTimes + 1));
        }
    }

    public static TestCaseMethods fromString(String testNamesString) {
        TestCaseMethods testMethods = new TestCaseMethods();
        String[] allTests = testNamesString.split(TEST_CASE_METHOD_SEPARATOR);
        for (int x = 0; x < allTests.length; ++x) {
            String testName = allTests[x].trim();
            TestCaseMethod testMethod = TestCaseMethod.parse(testName);
            testMethods.addTestMethod(testMethod);
        }
        return testMethods;
    }

    public int getTestNumber() {
        return this.testCaseMethods.size();
    }

    public static TestCaseMethods fromTestClassNameArray(String[] testClassNames) {
        TestCaseMethods testCaseMethods = new TestCaseMethods();
        for (int i = 0; i < testClassNames.length; ++i) {
            testCaseMethods.addTestMethod(new TestCaseMethod(testClassNames[i], null));
        }
        return testCaseMethods;
    }

    public String[] getTestClassNames() {
        HashSet<String> soFar = new HashSet<String>();
        ArrayList<String> toReturn = new ArrayList<String>();
        Iterator iter = this.testCaseMethods.iterator();
        while (iter.hasNext()) {
            TestCaseMethod element = (TestCaseMethod)iter.next();
            if (soFar.contains(element.getTestClassName())) continue;
            soFar.add(element.getTestClassName());
            toReturn.add(element.getTestClassName());
        }
        return toReturn.toArray(new String[soFar.size()]);
    }

    public TestCaseMethod get(int i) {
        return (TestCaseMethod)this.testCaseMethods.get(i);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getTestNumber(); ++i) {
            if (i > 0) {
                buf.append(TEST_CASE_METHOD_SEPARATOR);
            }
            buf.append(this.get(i).toString());
        }
        return buf.toString();
    }

    public void sortAgitarTestClassesLast(UserProject project, boolean includeManualTests) {
        ArrayList<TestCaseMethod> agitarTestCases = new ArrayList<TestCaseMethod>(this.testCaseMethods.size());
        ArrayList<TestCaseMethod> junitTestCases = new ArrayList<TestCaseMethod>(this.testCaseMethods.size());
        for (int i = 0; i < this.getTestNumber(); ++i) {
            TestCaseMethod ithTestCaseMethod = this.get(i);
            if (project.isAgitarTestCase(ithTestCaseMethod.getTestClassName())) {
                agitarTestCases.add(ithTestCaseMethod);
                continue;
            }
            junitTestCases.add(ithTestCaseMethod);
        }
        this.testCaseMethods.clear();
        if (includeManualTests) {
            this.testCaseMethods.addAll(junitTestCases);
        }
        this.testCaseMethods.addAll(agitarTestCases);
    }

    public int getNumberOfTestsForClass(int i) {
        return (Integer)this.testClassNames.get(this.get(i).getTestClassName());
    }

    public Iterator getBatchIterator(int batchSize) {
        Assertions.assertTrue((String)"batchSize must be positive", (batchSize > 0 ? 1 : 0) != 0);
        return new BatchIterator(batchSize);
    }

    private class BatchIterator
    implements Iterator {
        private int batchSize;
        private int index = 0;

        public BatchIterator(int batchSize) {
            this.batchSize = batchSize;
        }

        public void remove() {
            throw new UnsupportedOperationException("no remove");
        }

        public boolean hasNext() {
            return this.index < TestCaseMethods.this.testCaseMethods.size();
        }

        public Object next() {
            TestCaseMethods nextBatch = new TestCaseMethods();
            for (int i = 0; i < this.batchSize && this.hasNext(); ++i) {
                nextBatch.addTestMethod(TestCaseMethods.this.get(this.index));
                ++this.index;
            }
            return nextBatch;
        }
    }
}

