/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner;

import com.agitar.common.util.StringUtility;
import com.agitar.junit.runner.SuperRunnerTestRunner;
import com.agitar.lib.junit.AgitarTestCase;
import com.agitar.lib.mockingbird.Caller;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.lib.mockingbird.invocation.Invoke;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class StackTraceFilter {
    private static final TraceComparator METHODINVOKE_COMPARATOR = new TraceComparator(Invoke.class, "execute");
    private static final TraceComparator JAVA_LANG_METHOD_INVOKE = new TraceComparator(Method.class, "invoke");
    private static final TraceComparator NATIVE_DELEGATE_INVOKE = new TraceComparator("sun.reflect.DelegatingMethodAccessorImpl", "invoke");
    private static final TraceComparator NATIVE_INVOKE = new TraceComparator("sun.reflect.NativeMethodAccessorImpl", "invoke");
    private static final TraceComparator NATIVE_INVOKE0 = new TraceComparator("sun.reflect.NativeMethodAccessorImpl", "invoke0");
    private static final TraceComparator[] METHOD_CALL_STACK = new TraceComparator[]{JAVA_LANG_METHOD_INVOKE, NATIVE_DELEGATE_INVOKE, NATIVE_INVOKE};
    private static final TraceComparator[] CONSTRUCTOR_CALL_STACK = new TraceComparator[]{new TraceComparator(Caller.class, "callConstructor"), new TraceComparator(Constructor.class, "newInstance"), new TraceComparator("sun.reflect.DelegatingConstructorAccessorImpl", "newInstance")};
    private static final TraceComparator[] NATIVE_CONSTRUCTOR_CALL_STACK = new TraceComparator[]{new TraceComparator("sun.reflect.NativeConstructorAccessorImpl", "newInstance"), new TraceComparator("sun.reflect.NativeConstructorAccessorImpl", "newInstance0")};
    private static final TraceComparator InvokeUsingThreadClassLoader = new TraceComparator("user.agitar.invocation.Interposer", "invokeUsingThreadClassLoader");
    private static final TraceComparatorForGeneratedClass TRACE_COMPARATOR_FOR_GENERATED_CONSTRUCTOR = new TraceComparatorForGeneratedClass("sun.reflect.GeneratedConstructorAccessor", "newInstance");
    private static final TraceComparatorForGeneratedClass TRACE_COMPARATOR_FOR_GENERATED_METHOD = new TraceComparatorForGeneratedClass("sun.reflect.GeneratedMethodAccessor", "invoke");
    private static TreeNode MOCKINGBIRD_ROOT = null;
    private static TreeNode REMOTE_RUNNER_ROOT;
    private static TreeNode SUPER_RUNNER_ROOT;
    private static final TraceComparator[] JUNIT_RUNNER_TRACE;
    private static final TraceComparator[] REMOTE_TEST_RUNNER_TRACE;
    private static final TraceComparator[] SUPER_TEST_RUNNER_TRACE;

    public static void main(String[] args) {
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceFilter.getMockingbirdCallTree().print(stringBuffer, 0);
        System.out.println(stringBuffer.toString());
    }

    public static Throwable filter(Throwable exception) {
        LinkedList list = StackTraceFilter.convert(exception.getStackTrace());
        StackTraceFilter.filterTrace(list);
        int idx = list.size() - 1;
        StackTraceElement[] trace = new StackTraceElement[list.size()];
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            TraceComparator element = (TraceComparator)iter.next();
            trace[idx--] = element.trace;
        }
        exception.setStackTrace(trace);
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            StackTraceFilter.filter(cause);
        }
        return exception;
    }

    public static void filterTrace(LinkedList list) {
        boolean found = StackTraceFilter.matchTrace(list, StackTraceFilter.getRemoteRunnerCallTree());
        if (!found) {
            StackTraceFilter.matchTrace(list, StackTraceFilter.getSuperTestRunnerCallTree());
        }
        StackTraceFilter.filterTrace(list, StackTraceFilter.getMockingbirdCallTree());
    }

    private static void filterTrace(LinkedList list, TreeNode root) {
        boolean found = StackTraceFilter.matchTrace(list, root);
        while (found) {
            found = StackTraceFilter.matchTrace(list, root);
        }
    }

    private static LinkedList convert(StackTraceElement[] stackTrace) {
        LinkedList<TraceComparator> list = new LinkedList<TraceComparator>();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            list.add(0, new TraceComparator(element));
        }
        return list;
    }

    private static boolean matchTrace(LinkedList trace, TreeNode root) {
        for (int i = 0; i < trace.size(); ++i) {
            TraceComparator element = (TraceComparator)trace.get(i);
            if (!root.match(element)) continue;
            trace.remove(i);
            if (i < trace.size()) {
                StackTraceFilter.matchTrace(trace, i, root);
            }
            return true;
        }
        return false;
    }

    private static boolean matchTrace(LinkedList trace, int startIndex, TreeNode node) {
        List kids = node.list;
        if (kids != null && kids.size() > 0 && kids.size() > node.currentIndex && startIndex < trace.size()) {
            int target = startIndex;
            TraceComparator element = (TraceComparator)trace.get(target);
            for (int i = node.currentIndex; i < kids.size(); ++i) {
                TreeNode kid = (TreeNode)kids.get(i);
                if (!kid.match(element)) continue;
                trace.remove(target);
                if (target < trace.size()) {
                    StackTraceFilter.matchTrace(trace, target, kid);
                }
                return true;
            }
        }
        return false;
    }

    private static TreeNode getMockingbirdCallTree() {
        if (MOCKINGBIRD_ROOT == null) {
            MOCKINGBIRD_ROOT = new TreeNode(new TraceComparator(Mockingbird.class, "invoke"));
            TreeNode callerInvoke = new TreeNode(new TraceComparator(Caller.class, "invoke"));
            MOCKINGBIRD_ROOT.add(callerInvoke);
            TreeNode lastNode = StackTraceFilter.addTraceComparators(callerInvoke, CONSTRUCTOR_CALL_STACK);
            StackTraceFilter.addTraceComparators(lastNode, NATIVE_CONSTRUCTOR_CALL_STACK);
            lastNode.add(new TreeNode(TRACE_COMPARATOR_FOR_GENERATED_CONSTRUCTOR));
            lastNode = StackTraceFilter.addTraceComparator(callerInvoke, METHODINVOKE_COMPARATOR);
            TreeNode[] nodes = StackTraceFilter.addMethodInvoke(lastNode);
            for (int i = 0; i < nodes.length; ++i) {
                TreeNode node = nodes[i];
                StackTraceFilter.addMethodInvoke(StackTraceFilter.addTraceComparator(node, InvokeUsingThreadClassLoader));
            }
        }
        return MOCKINGBIRD_ROOT;
    }

    private static TreeNode[] addMethodInvoke(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeNode last = StackTraceFilter.addTraceComparator(StackTraceFilter.addTraceComparator(node, JAVA_LANG_METHOD_INVOKE), NATIVE_DELEGATE_INVOKE);
        list.add(StackTraceFilter.addTraceComparator(last, TRACE_COMPARATOR_FOR_GENERATED_METHOD));
        last = StackTraceFilter.addTraceComparator(last, NATIVE_INVOKE);
        list.add(StackTraceFilter.addTraceComparator(last, NATIVE_INVOKE0));
        last = StackTraceFilter.addTraceComparator(last, NATIVE_INVOKE);
        list.add(StackTraceFilter.addTraceComparator(last, NATIVE_INVOKE0));
        return list.toArray(new TreeNode[0]);
    }

    private static TreeNode addNativeCall(TreeNode lastNode) {
        lastNode = StackTraceFilter.addTraceComparators(lastNode, METHOD_CALL_STACK);
        lastNode.add(new TreeNode(NATIVE_INVOKE0));
        TreeNode child = new TreeNode(NATIVE_INVOKE);
        child.add(new TreeNode(NATIVE_INVOKE0));
        lastNode.add(child);
        return child;
    }

    private StackTraceFilter() {
    }

    private static TreeNode addTraceComparator(TreeNode parent, TraceComparator callStack) {
        TreeNode child = new TreeNode(callStack);
        parent.add(child);
        return child;
    }

    private static TreeNode addTraceComparators(TreeNode parent, TraceComparator[] callStack) {
        TreeNode child = null;
        for (int i = 0; i < callStack.length; ++i) {
            child = new TreeNode(callStack[i]);
            parent.add(child);
            parent = child;
        }
        return child;
    }

    private static TreeNode getRemoteRunnerCallTree() {
        if (REMOTE_RUNNER_ROOT == null) {
            REMOTE_RUNNER_ROOT = new TreeNode(new TraceComparator("com.agitar.eclipse.junit.runner.AgitarRemoteTestRunner", "main"));
            TreeNode kid = StackTraceFilter.addTraceComparators(REMOTE_RUNNER_ROOT, REMOTE_TEST_RUNNER_TRACE);
            kid = StackTraceFilter.addTraceComparators(kid, JUNIT_RUNNER_TRACE);
            StackTraceFilter.addNativeCall(kid);
        }
        return REMOTE_RUNNER_ROOT;
    }

    private static TreeNode getSuperTestRunnerCallTree() {
        if (SUPER_RUNNER_ROOT == null) {
            SUPER_RUNNER_ROOT = new TreeNode(new TraceComparator(SuperRunnerTestRunner.class, "main"));
            TreeNode kid = StackTraceFilter.addTraceComparators(SUPER_RUNNER_ROOT, SUPER_TEST_RUNNER_TRACE);
            kid = StackTraceFilter.addTraceComparators(kid, JUNIT_RUNNER_TRACE);
            StackTraceFilter.addNativeCall(kid);
        }
        return SUPER_RUNNER_ROOT;
    }

    static {
        JUNIT_RUNNER_TRACE = new TraceComparator[]{new TraceComparator(TestSuite.class, "run"), new TraceComparator(TestSuite.class, "runTest"), new TraceComparator(TestCase.class, "run"), new TraceComparator(TestResult.class, "run"), new TraceComparator(TestResult.class, "runProtected"), new TraceComparator("junit.framework.TestResult$1", "protect"), new TraceComparator(AgitarTestCase.class, "runBare"), new TraceComparator(TestCase.class, "runTest")};
        REMOTE_TEST_RUNNER_TRACE = new TraceComparator[]{new TraceComparator("com.agitar.eclipse.testrunner.runner.RemoteTestRunner", "run"), new TraceComparator("com.agitar.eclipse.testrunner.runner.RemoteTestRunner", "runTests")};
        SUPER_TEST_RUNNER_TRACE = new TraceComparator[]{new TraceComparator(SuperRunnerTestRunner.class, "launch"), new TraceComparator(SuperRunnerTestRunner.class, "run"), new TraceComparator(SuperRunnerTestRunner.class, "runBare")};
    }

    private static class TreeNode {
        TreeNode parent;
        final TraceComparator value;
        List list;
        int currentIndex;

        boolean match(TraceComparator other) {
            if (this.value != null) {
                return this.value.match(other);
            }
            return other == null;
        }

        TreeNode(TraceComparator value) {
            this.value = value;
        }

        void add(TreeNode child) {
            child.parent = this;
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.list.add(child);
        }

        void print(StringBuffer buffer, int depth) {
            this.printTab(buffer, depth);
            buffer.append(this.value.toString());
            buffer.append(StringUtility.nl);
            if (this.list != null) {
                Iterator iter = this.list.iterator();
                while (iter.hasNext()) {
                    TreeNode node = (TreeNode)iter.next();
                    node.print(buffer, depth + 1);
                }
            }
        }

        void printTab(StringBuffer buffer, int depth) {
            for (int i = 0; i < depth; ++i) {
                buffer.append("  ");
            }
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class TraceComparatorForGeneratedClass
    extends TraceComparator {
        public TraceComparatorForGeneratedClass(String className, String methodName) {
            super(className, methodName);
        }

        public boolean match(TraceComparator other) {
            if (other == null) {
                return false;
            }
            return other.className != null && other.className.startsWith(this.className) && this.methodName != null && this.methodName.equals(other.methodName);
        }
    }

    public static class TraceComparator {
        protected String methodName;
        protected String className;
        private StackTraceElement trace;

        public TraceComparator(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        private TraceComparator(StackTraceElement trace) {
            this(trace.getClassName(), trace.getMethodName());
            this.trace = trace;
        }

        private TraceComparator(Class cls, String methodName) {
            this(cls.getName(), methodName);
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return this.className + "." + this.methodName;
        }

        public boolean match(TraceComparator other) {
            if (other == null) {
                return false;
            }
            return this.className.equals(other.className) && this.methodName.equals(other.methodName);
        }
    }
}

