/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner;

import com.agitar.common.types.ClassName;
import com.agitar.common.util.IOUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Paths {
    private File[] classPath;
    private JarFile[] jarFiles;

    public Paths(File[] paths) {
        this.classPath = paths;
        this.jarFiles = new JarFile[paths.length];
        for (int i = 0; i < this.jarFiles.length; ++i) {
            if (!this.classPath[i].isFile()) continue;
            try {
                this.jarFiles[i] = new JarFile(this.classPath[i]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public File getClassPathElement(ClassName className, boolean jarsOkay) {
        String classFileName = className.getClassFileName();
        return this.getClassPathElement(classFileName, jarsOkay);
    }

    public File getClassPathElement(String classFileName, boolean jarsOkay) {
        List l = this.getClassPathElements(classFileName, jarsOkay, false);
        if (l.size() == 0) {
            return null;
        }
        return (File)l.get(0);
    }

    public File[] getAllClassPathElements(String fileName, boolean jarsOkay) {
        List l = this.getClassPathElements(fileName, jarsOkay, true);
        return l.toArray(new File[0]);
    }

    public List getClassPathElements(String fileName, boolean jarsOkay, boolean allElements) {
        ArrayList<File> classPathElements = new ArrayList<File>();
        for (int i = 0; i < this.classPath.length; ++i) {
            if (this.jarFiles[i] != null) {
                if (!jarsOkay) continue;
                try {
                    JarFile jarFile = this.jarFiles[i];
                    JarEntry jarEntry = jarFile.getJarEntry(fileName);
                    if (jarEntry == null) continue;
                    classPathElements.add(this.classPath[i]);
                    if (allElements) continue;
                    break;
                }
                catch (Exception ex) {
                    continue;
                }
            }
            File potentialMatch = new File(this.classPath[i], fileName);
            if (!potentialMatch.exists()) continue;
            File withCorrectCase = IOUtility.getCanonicalFile((File)potentialMatch);
            if (!fileName.equals("") && !fileName.endsWith(withCorrectCase.getName())) continue;
            classPathElements.add(this.classPath[i]);
            if (!allElements) break;
        }
        return classPathElements;
    }
}

