/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner;

import com.agitar.common.util.DefiningClassLoader;
import com.agitar.common.util.IOUtility;
import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.instrument.InstrumentationManager;
import com.agitar.security.AgPolicy;
import com.agitar.testrunner.UserProject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class InstrumentingClassLoader
extends ClassLoader
implements DefiningClassLoader {
    private final UserProject project;
    private static File LIBDIR;
    private static File COMMON_LIBDIR;
    boolean inGetPackage = false;
    private static Map urlCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InstrumentingClassLoader(UserProject project) {
        super(InstrumentingClassLoader.class.getClassLoader());
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        this.project = project;
        try {
            LIBDIR = IOUtility.getFile(Class.forName("agitar.org.apache.crimson.parser.Parser2")).getParentFile().getParentFile();
        }
        catch (Throwable t) {
            LIBDIR = IOUtility.getFile((Class)InstrumentingClassLoader.class);
        }
        try {
            COMMON_LIBDIR = IOUtility.getFile(Class.forName("org.objectweb.asm.Attribute")).getParentFile().getParentFile();
        }
        catch (Throwable t) {
            COMMON_LIBDIR = IOUtility.getFile((Class)InstrumentingClassLoader.class);
        }
    }

    protected synchronized Class loadClass(final String name, final boolean resolve) throws ClassNotFoundException {
        Class<?> returnClass = this.findLoadedClass(name);
        if (returnClass != null) {
            return returnClass;
        }
        Class ret = (Class)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    File f;
                    URL url = null;
                    if (!(name.startsWith("junit.") || name.startsWith("com.agitar.") || (url = ClassLoader.getSystemResource(name.replace('.', '/') + ".class")) == null || (f = IOUtility.getFile((URL)url, (String)(name.replace('.', '/') + ".class"))).isDirectory() || !f.getAbsolutePath().startsWith(LIBDIR.getAbsolutePath()) && !f.getAbsolutePath().startsWith(COMMON_LIBDIR.getAbsolutePath()))) {
                        return InstrumentingClassLoader.this.findClass(name);
                    }
                    return InstrumentingClassLoader.super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe) {
                    return null;
                }
            }
        });
        if (ret == null) {
            throw new ClassNotFoundException(name);
        }
        return ret;
    }

    protected Package getPackage(String packageName) {
        Package pkg = super.getPackage(packageName);
        if (this.inGetPackage) {
            return pkg;
        }
        if (pkg == null) {
            this.inGetPackage = true;
            try {
                pkg = this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException iax) {
                this.inGetPackage = false;
                return this.getPackage(packageName);
            }
            this.inGetPackage = false;
            return pkg;
        }
        return pkg;
    }

    private Class processClassBytes(String name, byte[] classBytes, File sourceFile) {
        classBytes = InstrumentationManager.getInstrumentedBytes(name, classBytes, this, sourceFile, new AsmClassCache());
        return this.defineClass(name, classBytes, 0, classBytes.length, new ProtectionDomain(AgPolicy.USER_CODE, null, this, null));
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = null;
        String classFileName = name.replace('.', '/') + ".class";
        File rootClassPath = this.project.getClassPathElement(classFileName);
        if (rootClassPath == null) {
            throw new ClassNotFoundException("Could not find class: " + name);
        }
        classBytes = this.project.getBytes(rootClassPath, classFileName);
        return this.processClassBytes(name, classBytes, rootClassPath.isDirectory() ? new File(rootClassPath, classFileName) : rootClassPath);
    }

    protected Enumeration findResources(String name) throws IOException {
        File[] cpElements = this.project.getAllClassPathElements(name);
        URL[] urls = new URL[cpElements.length];
        for (int i = 0; i < urls.length; ++i) {
            if (cpElements[i] == null) continue;
            try {
                if (cpElements[i].isDirectory()) {
                    urls[i] = new File(cpElements[i], name).toURL();
                    continue;
                }
                String path = cpElements[i].getCanonicalPath().replace('\\', '/');
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                urls[i] = new URL("jar:file://" + path + "!/" + name);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return Collections.enumeration(Arrays.asList(urls));
    }

    public URL getResource(final String name) {
        URL fromCache = (URL)urlCache.get(name);
        if (fromCache != null) {
            return fromCache;
        }
        return (URL)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                URL url = InstrumentingClassLoader.super.getResource(name);
                urlCache.put(name, url);
                return url;
            }
        });
    }

    protected URL findResource(final String name) {
        return (URL)AgPolicy.doPrivilegedAction((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                File classPathElem = InstrumentingClassLoader.this.project.getClassPathElement(name);
                if (classPathElem == null) {
                    return null;
                }
                try {
                    if (classPathElem.isDirectory()) {
                        return new File(classPathElem, name).toURL();
                    }
                    String path = classPathElem.getCanonicalPath().replace('\\', '/');
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    return new URL("jar:file://" + path + "!/" + name);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        });
    }

    public Class load(String suiteClassName) throws ClassNotFoundException {
        return this.loadClass(suiteClassName);
    }

    public Class reload(Class aClass) throws ClassNotFoundException {
        return aClass;
    }

    public Class loadClassFromBytes(String className, byte[] bytes) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(className);
        if (c != null) {
            return c;
        }
        c = this.defineClass(className, bytes, 0, bytes.length, new ProtectionDomain(AgPolicy.USER_CODE, null, this, null));
        this.resolveClass(c);
        return c;
    }

    public Class findPreviousLoadedClass(String className) {
        return this.findLoadedClass(className);
    }

    static {
        $assertionsDisabled = !InstrumentingClassLoader.class.desiredAssertionStatus();
        LIBDIR = null;
        COMMON_LIBDIR = null;
        urlCache = new HashMap();
    }
}

