/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner;

import com.agitar.common.logging.AgitarLogger;
import com.agitar.security.SafeThread;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ExecutionProperties
extends Properties {
    private static Properties realSystemProperties = null;
    private static ExecutionProperties userCanMessTheseUpProperties = null;
    private static Logger logger;
    private Map userGets = new HashMap();

    public String getProperty(String key) {
        String property = null;
        if (this.inSafeThread()) {
            property = realSystemProperties.getProperty(key);
        } else {
            property = super.getProperty(key);
            if (property == null) {
                property = realSystemProperties.getProperty(key);
            }
            this.userGets.put(key, property);
        }
        return property;
    }

    private boolean inSafeThread() {
        return Thread.currentThread() instanceof SafeThread;
    }

    public Object setProperty(String key, String value) {
        if (this.inSafeThread()) {
            return realSystemProperties.setProperty(key, value);
        }
        return super.setProperty(key, value);
    }

    public static synchronized ExecutionProperties init() {
        if (realSystemProperties == null) {
            realSystemProperties = System.getProperties();
        }
        userCanMessTheseUpProperties = new ExecutionProperties();
        userCanMessTheseUpProperties.putAll((Map<?, ?>)realSystemProperties);
        System.setProperties(userCanMessTheseUpProperties);
        return userCanMessTheseUpProperties;
    }

    public static synchronized void restore() {
        userCanMessTheseUpProperties = null;
        System.setProperties(realSystemProperties);
    }

    static Properties getRealSystemProperties() {
        return realSystemProperties;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = AgitarLogger.getDiagnosticLogger((String)"ExecutionProperties");
        }
        return logger;
    }

    public Map getUserGets() {
        return Collections.unmodifiableMap(this.userGets);
    }
}

