/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.testrunner;

import com.agitar.common.asm.LightClassReader;
import com.agitar.common.util.ClassCacheMap;
import com.agitar.testrunner.UserProject;
import java.lang.reflect.Modifier;
import java.util.Map;

public class ClassInfo {
    private String className;
    private ClassInfo superClass = null;
    private ClassInfo[] interfaces = null;
    private int modifiers = 0;
    private UserProject project;
    private boolean isInitialized = false;
    private static Map classInfoCache = new ClassCacheMap("ClassInfoCache");

    public static ClassInfo get(UserProject project, String className) throws ClassNotFoundException {
        ClassInfo info = (ClassInfo)classInfoCache.get(className);
        if (info == null) {
            info = new ClassInfo(project, className);
            classInfoCache.put(className, info);
        }
        return info;
    }

    private ClassInfo(UserProject project, String className) {
        this.project = project;
        this.className = className;
    }

    public ClassInfo[] getInterfaces() throws ClassNotFoundException {
        this.initialize();
        return this.interfaces;
    }

    public ClassInfo getSuperClass() throws ClassNotFoundException {
        this.initialize();
        return this.superClass;
    }

    public boolean isInterface() throws ClassNotFoundException {
        this.initialize();
        return Modifier.isInterface(this.modifiers);
    }

    public boolean isAbstract() throws ClassNotFoundException {
        this.initialize();
        return Modifier.isAbstract(this.modifiers);
    }

    public String getName() {
        return this.className;
    }

    private void initialize() throws ClassNotFoundException {
        if (this.isInitialized) {
            return;
        }
        try {
            byte[] classBytes = this.project.getClassBytes(this.className);
            if (classBytes == null) {
                throw new NullPointerException("Could not find class bytes for " + this.className);
            }
            LightClassReader lcr = new LightClassReader(classBytes);
            this.superClass = ClassInfo.get(this.project, lcr.superClass);
            this.interfaces = new ClassInfo[lcr.interfaces.length];
            for (int i = 0; i < lcr.interfaces.length; ++i) {
                this.interfaces[i] = ClassInfo.get(this.project, lcr.interfaces[i]);
            }
            this.modifiers = lcr.modifiers;
            this.isInitialized = true;
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(this.className, ex);
        }
    }
}

