/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.literunner;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.Assertions;
import com.agitar.common.util.StreamCopier;
import com.agitar.common.util.StringUtility;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class OtherProcessController {
    private Process otherProcess;
    private PrintStream out;
    private MessageListener listener;
    private Class mainClass;
    private File workingDir;
    private Thread heartBeat;

    public OtherProcessController(Class mainClass, MessageListener listener) {
        this.mainClass = mainClass;
        this.setListener(listener);
    }

    public void setListener(MessageListener listener) {
        this.listener = listener;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public final void launchWithCurrentSystemClasspath(String[] vmArgs, String[] extraCLArgs) throws IOException {
        String[] testRunnerClassPath = AgitarProperties.CLASS_PATH;
        String flattenedPath = StringUtility.mergeStrings((String[])testRunnerClassPath, (char)File.pathSeparatorChar);
        this.launch(flattenedPath, vmArgs, extraCLArgs);
    }

    public void launch(String systemClasspath, String[] vmArgs, String[] extraCLArgs) throws IOException {
        String[] javaLaunchingArgs = new String[5 + vmArgs.length];
        javaLaunchingArgs[0] = AgitarProperties.locateJava();
        javaLaunchingArgs[1] = "-ea";
        javaLaunchingArgs[2] = "-cp";
        javaLaunchingArgs[3] = systemClasspath;
        System.arraycopy(vmArgs, 0, javaLaunchingArgs, 4, vmArgs.length);
        javaLaunchingArgs[javaLaunchingArgs.length - 1] = this.mainClass.getName();
        String[] args = new String[javaLaunchingArgs.length + extraCLArgs.length];
        System.arraycopy(javaLaunchingArgs, 0, args, 0, javaLaunchingArgs.length);
        System.arraycopy(extraCLArgs, 0, args, javaLaunchingArgs.length, extraCLArgs.length);
        AgitarLogger.getDiagnosticLogger((String)"other.process.controller").log(AgitarLevel.INFO, "Launching other java process with args " + StringUtility.mergeStrings((String[])args, (char)' '));
        this.otherProcess = Runtime.getRuntime().exec(args, null, this.workingDir);
    }

    public int startProcessingAndRegisterMessages() throws InterruptedException, IOException {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        int returnCode = this.startProcessing(outputBuffer);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outputBuffer.toByteArray())));
        String line = null;
        while ((line = reader.readLine()) != null) {
            this.listener.registerMessage(line);
        }
        return returnCode;
    }

    public int startProcessing(OutputStream outputBuffer) throws InterruptedException, IOException {
        InputStream pis = this.otherProcess.getInputStream();
        InputStream pes = this.otherProcess.getErrorStream();
        StreamCopier oc = new StreamCopier(pis, outputBuffer, true);
        StreamCopier ec = new StreamCopier(pes, outputBuffer, true);
        int returnCode = this.otherProcess.waitFor();
        if (this.heartBeat != null) {
            this.heartBeat.interrupt();
        }
        oc.shutdown(1000);
        ec.shutdown(1000);
        return returnCode;
    }

    public void sendMessage(String message) {
        PrintStream output = this.getOutputStream();
        output.println(message);
        output.flush();
    }

    public void sendMessage(byte[] message) throws IOException {
        PrintStream output = this.getOutputStream();
        output.write(message);
        output.flush();
    }

    private PrintStream getOutputStream() {
        if (this.out == null) {
            Assertions.assertNotNull((String)"other process must have been started", (Object)this.otherProcess);
            this.out = new PrintStream(this.otherProcess.getOutputStream());
        }
        return this.out;
    }

    public void endTransmission() {
        this.getOutputStream().close();
    }

    public void startHeartbeat(final long heartbeatTimeout) {
        this.heartBeat = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(heartbeatTimeout);
                        OtherProcessController.this.getOutputStream().println("");
                        OtherProcessController.this.getOutputStream().flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        this.heartBeat.start();
    }

    public static interface MessageListener {
        public void registerMessage(String var1);
    }
}

