/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.literunner;

import com.agitar.AgitarException;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.Assertions;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.XMLParsers;
import com.agitar.common.util.XMLUtility;
import com.agitar.literunner.LiteTestListener;
import com.agitar.testrunner.StackTraceFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LiteTestResults
extends OutputStream
implements TestListener {
    private static final String TEST_RESULTS_ELEMENT_NAME = "testresults";
    private static final String TEST_RESULT_ELEMENT_NAME = "testresult";
    private static final String TRACE_ELEMENT_NAME = "trace";
    private static final String STDOUT_ELEMENT_NAME = "stdout";
    private static final String STDERR_ELEMENT_NAME = "stderr";
    static final String CLOSING_TAG = "</testresults>";
    static final String OPENING_TAG = "<testresults>";
    static final String TEST_NAME_ATTRIBUTE = "testName";
    static final String RESULT_TYPE_ATTRIBUTE = "resultType";
    static final String SUCCESS = "SUCCESS";
    static final String FAILED = "FAILED";
    static final String ERROR = "ERROR";
    private ArrayList testResults = new ArrayList();
    private ByteArrayOutputStream stderr;
    private ByteArrayOutputStream stdout;
    private PipedOutputStream writeBuffer;
    private PipedInputStream pipedInput;
    private Thread pipeProcessor;
    private PrintStream destinationStream;
    private LiteTestListener resultsListener;
    private BufferProcessor bufferProcessor;

    public byte[] toBytes() {
        StringBuffer buf = new StringBuffer(1024);
        this.writeXML(buf);
        return buf.toString().getBytes();
    }

    public void writeXML(StringBuffer buf) {
        LiteTestResults.open(buf, TEST_RESULTS_ELEMENT_NAME);
        for (int i = 0; i < this.testResults.size(); ++i) {
            LiteTestResult result = (LiteTestResult)this.testResults.get(i);
            result.toXML(buf);
        }
        LiteTestResults.close(buf, TEST_RESULTS_ELEMENT_NAME);
    }

    private static void padWithSpaceToHackAroundSaxParserXMLReaderClassWaitingForBufferToFill(StringBuffer buf) {
        for (int i = 0; i < 8192; ++i) {
            buf.append(' ');
        }
    }

    public void addError(Test test, Throwable t) {
        this.assertCurrentTest(test);
        this.getCurrentResult().error(t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.assertCurrentTest(test);
        this.getCurrentResult().failed(t);
    }

    public void endTest(Test test) {
        this.assertCurrentTest(test);
        this.getCurrentResult().endTest();
        this.detachStreams();
        if (this.destinationStream != null) {
            try {
                this.destinationStream.write(this.getCurrentResult().toBytes());
                this.destinationStream.flush();
            }
            catch (IOException e) {
                AgitarLogger.getDiagnosticLogger((String)"lite.test.results").severe("could not write test results for test " + test);
            }
        }
    }

    private void assertCurrentTest(Test test) {
        Assertions.assertTrue((String)"ending a test different than the one that was started", (test == this.getCurrentTest() ? 1 : 0) != 0);
    }

    private Test getCurrentTest() {
        return this.getCurrentResult().getTest();
    }

    public LiteTestResult getCurrentResult() {
        return (LiteTestResult)this.testResults.get(this.testResults.size() - 1);
    }

    int size() {
        return this.testResults.size();
    }

    public void startTest(Test test) {
        this.testResults.add(new LiteTestResult(test));
    }

    public static LiteTestResults fromXML(String testResultMessages) {
        LiteTestResults results = new LiteTestResults();
        StringReader messagesReader = new StringReader(testResultMessages);
        try {
            Element root = XMLUtility.parse((Reader)messagesReader).getDocumentElement();
            NodeList failureList = root.getChildNodes();
            for (int i = 0; i < failureList.getLength(); ++i) {
                Node item = failureList.item(i);
                if (!(item instanceof Element)) continue;
                LiteTestResult singleResult = LiteTestResult.fromXML((Element)item);
                results.testResults.add(singleResult);
            }
        }
        catch (IOException shouldntHappen) {
            throw new AgitarException((Throwable)shouldntHappen);
        }
        catch (SAXException e) {
            AgitarLogger.getDiagnosticLogger((String)"compile.and.run").warning("Got invalid messages string [" + testResultMessages + "]. Did verification VM crash?");
        }
        return results;
    }

    public void setResultsListener(LiteTestListener listener) {
        this.resultsListener = listener;
    }

    public void detachStreams() {
        this.getCurrentResult().storeStdOut(this.stdout);
        this.getCurrentResult().storeStdErr(this.stderr);
    }

    public static void writeHeaderBytes(OutputStream output) throws IOException {
        output.write(OPENING_TAG.getBytes());
    }

    public static void writeFooterBytes(OutputStream output) throws IOException {
        output.write(CLOSING_TAG.getBytes());
    }

    public void write(int b) throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = new PipedOutputStream();
            this.pipedInput = new PipedInputStream(this.writeBuffer);
            this.bufferProcessor = new BufferProcessor();
            this.pipeProcessor = new Thread((Runnable)this.bufferProcessor, "LiteTestResultBufferReader");
            this.pipeProcessor.start();
        }
        this.writeBuffer.write(b);
    }

    private static StringBuffer open(StringBuffer buf, String elementName) {
        return buf.append("<").append(elementName).append(">");
    }

    private static StringBuffer close(StringBuffer buf, String elementName) {
        return buf.append("</").append(elementName).append(">");
    }

    public void close() throws IOException {
        this.writeBuffer.close();
        super.close();
    }

    public void join() throws InterruptedException {
        this.pipeProcessor.join();
        if (this.bufferProcessor.exception != null) {
            throw new AgitarException((Throwable)this.bufferProcessor.exception);
        }
    }

    public void setDestinationStream(PrintStream communicationOutputStream) {
        this.destinationStream = communicationOutputStream;
    }

    public void attachStandardStreams() {
        this.stdout = new ByteArrayOutputStream();
        this.stderr = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.stdout));
        System.setErr(new PrintStream(this.stderr));
    }

    private class BufferProcessor
    implements Runnable,
    ContentHandler {
        Exception exception = null;
        String lastTestToString;
        String lastType;
        StringBuffer lastTrace = new StringBuffer();
        StringBuffer lastStdout = new StringBuffer();
        StringBuffer lastStderr = new StringBuffer();
        private static final int NOTHING = 0;
        private static final int IN_TRACE = 1;
        private static final int IN_STDOUT = 2;
        private static final int IN_STDERR = 3;
        private int inside = 0;

        private BufferProcessor() {
        }

        public void run() {
            try {
                SAXParser parser = XMLParsers.getSaxParserFactory().newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(this);
                reader.parse(new InputSource(LiteTestResults.this.pipedInput));
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.inside) {
                case 1: {
                    this.lastTrace.append(ch, start, length);
                    break;
                }
                case 3: {
                    this.lastStderr.append(ch, start, length);
                    break;
                }
                case 2: {
                    this.lastStdout.append(ch, start, length);
                    break;
                }
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (LiteTestResults.TEST_RESULT_ELEMENT_NAME.equals(qName)) {
                LiteTestResult newResult = new LiteTestResult(this.lastTestToString, this.lastType, this.lastTrace.toString(), this.lastStdout.toString(), this.lastStderr.toString());
                LiteTestResults.this.testResults.add(newResult);
                if (LiteTestResults.this.resultsListener != null) {
                    newResult.replayTest(LiteTestResults.this.resultsListener);
                }
                this.lastType = null;
                this.lastTestToString = null;
                this.lastTrace.delete(0, this.lastTrace.length());
                this.lastStderr.delete(0, this.lastStderr.length());
                this.lastStdout.delete(0, this.lastStdout.length());
            }
            this.inside = 0;
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (LiteTestResults.TRACE_ELEMENT_NAME.equals(qName)) {
                this.inside = 1;
            } else if (LiteTestResults.STDERR_ELEMENT_NAME.equals(qName)) {
                this.inside = 3;
            } else if (LiteTestResults.STDOUT_ELEMENT_NAME.equals(qName)) {
                this.inside = 2;
            } else {
                this.inside = 0;
                if (!LiteTestResults.TEST_RESULTS_ELEMENT_NAME.equals(qName) && LiteTestResults.TEST_RESULT_ELEMENT_NAME.equals(qName)) {
                    this.lastTestToString = atts.getValue(LiteTestResults.TEST_NAME_ATTRIBUTE);
                    this.lastType = atts.getValue(LiteTestResults.RESULT_TYPE_ATTRIBUTE);
                }
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }

    static class LiteTestResult {
        private final Test test;
        private String type = null;
        private Throwable result;
        private String testToString;
        private String trace;
        private String stdOut;
        private String stdErr;

        LiteTestResult(String testToString, String type, String trace, String stdout2, String stderr2) {
            this.test = null;
            this.result = null;
            this.type = type;
            this.trace = trace;
            this.testToString = testToString;
            this.stdErr = stderr2;
            this.stdOut = stdout2;
        }

        LiteTestResult(Test tested) {
            this.test = tested;
        }

        void success() {
            this.type = LiteTestResults.SUCCESS;
            this.result = null;
        }

        void failed(AssertionFailedError t) {
            this.type = LiteTestResults.FAILED;
            this.result = t;
        }

        void error(Throwable t) {
            this.type = LiteTestResults.ERROR;
            this.result = t;
        }

        void toXML(StringBuffer buf) {
            buf.append("<").append(LiteTestResults.TEST_RESULT_ELEMENT_NAME);
            XMLUtility.writeAttribute((String)LiteTestResults.TEST_NAME_ATTRIBUTE, (String)(this.test != null ? this.test.toString() : this.testToString), (StringBuffer)buf);
            XMLUtility.writeAttribute((String)LiteTestResults.RESULT_TYPE_ATTRIBUTE, (String)this.type, (StringBuffer)buf);
            buf.append(">");
            if (!this.passed()) {
                LiteTestResults.open(buf, LiteTestResults.TRACE_ELEMENT_NAME);
                if (this.result != null) {
                    buf.append(XMLUtility.escape((String)this.getResultMessage()));
                } else {
                    buf.append(XMLUtility.escape((String)this.trace));
                }
                LiteTestResults.close(buf, LiteTestResults.TRACE_ELEMENT_NAME);
            }
            if (!StringUtility.nullOrEmpty((String)this.stdOut)) {
                LiteTestResults.open(buf, LiteTestResults.STDOUT_ELEMENT_NAME).append(XMLUtility.escape((String)this.stdOut)).append(LiteTestResults.close(new StringBuffer(), LiteTestResults.STDOUT_ELEMENT_NAME));
            }
            if (!StringUtility.nullOrEmpty((String)this.stdErr)) {
                LiteTestResults.open(buf, LiteTestResults.STDERR_ELEMENT_NAME).append(XMLUtility.escape((String)this.stdErr)).append(LiteTestResults.close(new StringBuffer(), LiteTestResults.STDERR_ELEMENT_NAME));
            }
            LiteTestResults.close(buf, LiteTestResults.TEST_RESULT_ELEMENT_NAME);
            LiteTestResults.padWithSpaceToHackAroundSaxParserXMLReaderClassWaitingForBufferToFill(buf);
        }

        private String getResultMessage() {
            if (this.passed()) {
                return "";
            }
            return StringUtility.trace((Throwable)StackTraceFilter.filter(this.result));
        }

        public Test getTest() {
            return this.test;
        }

        public void endTest() {
            if (this.type == null) {
                this.success();
            }
        }

        public static LiteTestResult fromXML(Element testResultElement) {
            String trace = LiteTestResult.getNodeValueIfExists(testResultElement, LiteTestResults.TRACE_ELEMENT_NAME);
            String stdout = LiteTestResult.getNodeValueIfExists(testResultElement, LiteTestResults.STDOUT_ELEMENT_NAME);
            String stderr = LiteTestResult.getNodeValueIfExists(testResultElement, LiteTestResults.STDERR_ELEMENT_NAME);
            return new LiteTestResult(XMLUtility.getAttribute((Element)testResultElement, (String)LiteTestResults.TEST_NAME_ATTRIBUTE), XMLUtility.getAttribute((Element)testResultElement, (String)LiteTestResults.RESULT_TYPE_ATTRIBUTE), trace, stdout, stderr);
        }

        private static String getNodeValueIfExists(Element testResultElement, String tagName) {
            String trace = null;
            NodeList maybeTrace = testResultElement.getElementsByTagName(tagName);
            if (maybeTrace.getLength() > 0) {
                trace = XMLUtility.getValueOfTextNode((Node)maybeTrace.item(0));
            }
            return trace;
        }

        public boolean passed() {
            return LiteTestResults.SUCCESS.equals(this.type);
        }

        public boolean failed() {
            return LiteTestResults.FAILED.equals(this.type);
        }

        public boolean errored() {
            return LiteTestResults.ERROR.equals(this.type);
        }

        private void storeStdOut(ByteArrayOutputStream stdout) {
            if (stdout != null) {
                this.stdOut = new String(stdout.toByteArray());
                stdout.reset();
            }
        }

        private void storeStdErr(ByteArrayOutputStream stderr) {
            if (stderr != null) {
                this.stdErr = new String(stderr.toByteArray());
                stderr.reset();
            }
        }

        public void replayTest(LiteTestListener listener) {
            listener.notifyTestStarted(this.testToString);
            if (this.failed()) {
                listener.notifyTestFailure(this.testToString, this.trace);
            } else if (this.errored()) {
                listener.notifyTestError(this.testToString, this.trace);
            }
            if (this.stdOut != null) {
                listener.notifyStdOut(this.stdOut);
            }
            if (this.stdErr != null) {
                listener.notifyStdErr(this.stdErr);
            }
            listener.notifyTestEnded(this.testToString);
        }

        public byte[] toBytes() {
            StringBuffer buf = new StringBuffer(1024);
            this.toXML(buf);
            return buf.toString().getBytes();
        }
    }
}

