/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.literunner;

import com.agitar.common.util.StringUtility;
import com.agitar.literunner.ConfigurationProperties;
import com.agitar.testrunner.TestCaseMethods;
import java.io.File;
import java.util.Map;

public class LiteJUnitRunnerConfigurationProperties
extends ConfigurationProperties {
    private static final String CLASSPATH_KEY = "user.class.path";
    private static final String ROOT_DIR = "root.dir";
    private static final String PROJECT_NAME = "project.name";
    private static final String AGITAR_DIR = "agitar.dir";
    private static final String TESTS_TO_RUN = "all.tests";
    private static final String RUNNER = "batch.runner";

    public LiteJUnitRunnerConfigurationProperties(String[] userClasspath, String rootDir, String projectName, String agitarDir, TestCaseMethods testsToRun, String runner) {
        this.put(CLASSPATH_KEY, StringUtility.join((String[])userClasspath, (char)File.pathSeparatorChar));
        this.put(ROOT_DIR, rootDir);
        if (projectName != null) {
            this.put(PROJECT_NAME, projectName);
        }
        this.put(AGITAR_DIR, agitarDir);
        this.put(TESTS_TO_RUN, testsToRun.toString());
        if (runner != null) {
            this.put(RUNNER, runner);
        }
    }

    public LiteJUnitRunnerConfigurationProperties(String[] userClasspath, String rootDir, String projectName, String agitarDir, TestCaseMethods testsToRun) {
        this(userClasspath, rootDir, projectName, agitarDir, testsToRun, null);
    }

    public LiteJUnitRunnerConfigurationProperties(ConfigurationProperties properties) {
        this.putAll((Map<?, ?>)properties);
    }

    public TestCaseMethods getAllTests() {
        return TestCaseMethods.fromString((String)this.get(TESTS_TO_RUN));
    }

    public String getUserClasspath() {
        return (String)this.get(CLASSPATH_KEY);
    }

    public String getRootDir() {
        return (String)this.get(ROOT_DIR);
    }

    public String getProjectName() {
        return (String)this.get(PROJECT_NAME);
    }

    public String getAgitarDir() {
        return (String)this.get(AGITAR_DIR);
    }

    public String getRunner() {
        return (String)this.get(RUNNER);
    }
}

