/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.literunner;

import com.agitar.common.util.InitializationHelper;
import com.agitar.coverage.CoverageManager;
import com.agitar.literunner.ConfigurationProperties;
import com.agitar.literunner.Heartbeat;
import com.agitar.literunner.LiteJUnitRunnerConfigurationProperties;
import com.agitar.literunner.LiteTestResults;
import com.agitar.literunner.TestLoader;
import com.agitar.security.AgPolicy;
import com.agitar.testrunner.TestCaseMethods;
import com.agitar.testrunner.UserProject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public class LiteJUnitRunner
implements Heartbeat.FlatEKGListener {
    private static final String HEART_BEAT_OFF = "agitar.no.test.heartbeat";
    private UserProject project;
    private LiteTestResults resultListener = new LiteTestResults();
    private TestCaseMethods allTests;
    private Heartbeat heartBeat = null;
    private PrintStream errStream;

    void initArgs(LiteJUnitRunnerConfigurationProperties config) throws IOException {
        this.allTests = config.getAllTests();
        this.project = new UserProject(config.getUserClasspath(), config.getRootDir(), config.getProjectName(), this.allTests.getTestClassNames(), true);
        this.project.setAgitarResultsDirectory(config.getAgitarDir() + File.separator + ".results");
        CoverageManager.setCoverageDir((File)this.project.getAgitarResultsDirectoryAsFile());
        AgPolicy policy = InitializationHelper.installJUnitSecurityPolicy();
        for (int i = 0; i < this.project.getClassPath().length; ++i) {
            policy.addReadPermissionsForPath(this.project.getClassPath()[i].getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        PrintStream communicationOutputStream = System.out;
        PrintStream communicationErrStream = System.err;
        PrintStream devNull = new PrintStream(new DevNullStream());
        System.setOut(devNull);
        System.setErr(devNull);
        int exitCode = 0;
        try {
            LiteJUnitRunnerConfigurationProperties runConfiguration = new LiteJUnitRunnerConfigurationProperties(ConfigurationProperties.fromStandardIn());
            LiteJUnitRunner runner = LiteJUnitRunner.instantiateRunner(runConfiguration).withErrorStream(communicationErrStream);
            runner.initArgs(runConfiguration);
            runner.runTests(communicationOutputStream);
        }
        catch (Throwable t) {
            communicationErrStream.println("EXCEPTION: " + t.getClass() + "\n" + t.getMessage());
            t.printStackTrace(communicationErrStream);
            exitCode = 102;
        }
        finally {
            LiteJUnitRunner.goByeBye(exitCode);
        }
    }

    private LiteJUnitRunner withErrorStream(PrintStream communicationErrStream) {
        this.errStream = communicationErrStream;
        return this;
    }

    private static void goByeBye(int exitCode) {
        System.setSecurityManager(null);
        System.exit(exitCode);
    }

    private static LiteJUnitRunner instantiateRunner(LiteJUnitRunnerConfigurationProperties runConfiguration) {
        String runner = runConfiguration.getRunner();
        if (runner != null) {
            String msg = null;
            Throwable cause = null;
            try {
                Class<?> runnerClass = Class.forName(runner);
                LiteJUnitRunner newInstance = (LiteJUnitRunner)runnerClass.newInstance();
                if (System.getProperty(HEART_BEAT_OFF) != null) {
                    return newInstance;
                }
                return newInstance.withHeartBeat(60000L, System.in, newInstance);
            }
            catch (ClassNotFoundException e) {
                msg = "Cannot find runner class: " + runner;
                cause = e;
            }
            catch (ClassCastException e) {
                msg = "Runner [" + runner + "] is not an instance of " + LiteJUnitRunner.class.getName();
                cause = e;
            }
            catch (Throwable x) {
                msg = x.getMessage();
                cause = x;
            }
            if (cause != null) {
                IllegalArgumentException iax = new IllegalArgumentException(msg);
                iax.initCause(cause);
                throw iax;
            }
        }
        return new LiteJUnitRunner();
    }

    public LiteTestResults getResults() {
        return this.resultListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTests(PrintStream communicationOutputStream) throws IOException {
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        try {
            this.executeAndNotifyTests(communicationOutputStream, this.project);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CoverageManager.saveAllCoverage((boolean)true, (File)this.project.getAgitarResultsDirectoryAsFile());
            System.setOut(originalOut);
            System.setErr(originalErr);
            throw throwable;
        }
        CoverageManager.saveAllCoverage((boolean)true, (File)this.project.getAgitarResultsDirectoryAsFile());
        System.setOut(originalOut);
        System.setErr(originalErr);
    }

    protected void executeAndNotifyTests(PrintStream communicationOutputStream, UserProject project) throws IOException {
        LiteTestResults.writeHeaderBytes(communicationOutputStream);
        TestResult testResult = new TestResult();
        testResult.addListener((TestListener)this.resultListener);
        TestLoader testLoader = new TestLoader();
        testLoader.setProject(project);
        for (int i = 0; i < this.allTests.getTestNumber(); ++i) {
            this.resultListener.attachStandardStreams();
            this.resultListener.setDestinationStream(communicationOutputStream);
            project.resetClassLoader(this.allTests.get(i).getTestClassName(), true, true, true);
            Test currentSuite = testLoader.getTest(this.allTests.get(i).getTestClassName(), this.allTests.get(i).getMethodName());
            currentSuite.run(testResult);
        }
        LiteTestResults.writeFooterBytes(communicationOutputStream);
    }

    protected LiteTestResults getResultListener() {
        return this.resultListener;
    }

    protected TestCaseMethods getAllTests() {
        return this.allTests;
    }

    LiteJUnitRunner withHeartBeat(long timeout, InputStream whereHeartIs, Heartbeat.FlatEKGListener ekg) {
        this.heartBeat = new Heartbeat(whereHeartIs).thatGivesUpAfter(timeout).withEKGSignal(ekg);
        Thread heartbeatThread = new Thread(this.heartBeat);
        heartbeatThread.setDaemon(true);
        heartbeatThread.start();
        return this;
    }

    public void notifyDeath(int beatsRead) {
        if (this.errStream != null) {
            this.errStream.println("Lost connection to parent process after " + beatsRead + " heartbeats.");
        }
        LiteJUnitRunner.goByeBye(-1 * beatsRead);
    }

    private static class DevNullStream
    extends OutputStream {
        private DevNullStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

