/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.literunner;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class Heartbeat
implements Runnable {
    public static final long DEFAULT_PAUSE_LENGTH = 10000L;
    public static final long DEFAULT_DEATH_CERTIFICATE = 60000L;
    private InputStream pulse;
    private long timeout = 60000L;
    private int totalRead = 0;
    private FlatEKGListener signalAtDeath = null;

    public Heartbeat(InputStream pulse) {
        this.pulse = pulse;
    }

    public boolean listen() {
        ReadableByteChannel newChannel = Channels.newChannel(this.pulse);
        ByteBuffer buf = ByteBuffer.allocate(1024);
        int numRead = -1;
        try {
            numRead = newChannel.read(buf);
            if (numRead > 0) {
                this.totalRead += numRead;
            }
        }
        catch (IOException e) {
            return false;
        }
        return numRead > 0;
    }

    public Heartbeat thatGivesUpAfter(long declareOrphanTimeout) {
        this.timeout = declareOrphanTimeout;
        return this;
    }

    public void run() {
        while (this.listen()) {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.signalAtDeath != null) {
            this.signalAtDeath.notifyDeath(this.totalRead);
        }
    }

    public Heartbeat withEKGSignal(FlatEKGListener signal) {
        this.signalAtDeath = signal;
        return this;
    }

    public static interface FlatEKGListener {
        public void notifyDeath(int var1);
    }
}

