/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.literunner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigurationProperties
extends Properties {
    public byte[] toByteArray(String header) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] lengthAsBytes = new byte[]{0, 0, 0, 0};
        out.write(lengthAsBytes);
        this.store(out, header);
        byte[] toByteArray = out.toByteArray();
        int bodyLength = toByteArray.length - lengthAsBytes.length;
        for (int i = 0; i < 4; ++i) {
            toByteArray[3 - i] = (byte)(bodyLength >>> i * 8);
        }
        return toByteArray;
    }

    public static ConfigurationProperties parseBodyLaunchConfiguration(byte[] bytes) throws IOException {
        ConfigurationProperties parsedProperties = new ConfigurationProperties();
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        parsedProperties.load(inStream);
        return parsedProperties;
    }

    public static ConfigurationProperties parseLaunchConfiguration(byte[] includesLengthHeader) throws IOException {
        int length = ConfigurationProperties.readLength(includesLengthHeader);
        ByteArrayInputStream inStream = new ByteArrayInputStream(includesLengthHeader, 4, length);
        return ConfigurationProperties.parseBodyLaunchConfiguration(ConfigurationProperties.readSomeBytes(inStream, length));
    }

    public static ConfigurationProperties fromStandardIn() throws IOException {
        return ConfigurationProperties.parseBodyLaunchConfiguration(ConfigurationProperties.readFromStream(System.in));
    }

    private static byte[] readFromStream(InputStream inputStream) throws IOException {
        byte[] lengthAsBytes = ConfigurationProperties.readSomeBytes(inputStream, 4);
        int length = ConfigurationProperties.readLength(lengthAsBytes);
        return ConfigurationProperties.readSomeBytes(inputStream, length);
    }

    private static int readLength(byte[] lengthAsBytes) {
        int length = 0;
        for (int i = 0; i < 4; ++i) {
            length <<= 8;
            length = (int)((long)length ^ (long)lengthAsBytes[i] & 0xFFL);
        }
        return length;
    }

    private static byte[] readSomeBytes(InputStream in, int length) throws IOException {
        byte[] bytes = new byte[length];
        int readSoFar = 0;
        int read = 0;
        do {
            if ((read = in.read(bytes, readSoFar, length - readSoFar)) < 0) continue;
            readSoFar += read;
        } while (readSoFar < length && read > -1);
        if (readSoFar < length) {
            throw new IOException("Could not read enough bytes from [" + in.toString() + "], expected " + length + " but got " + readSoFar);
        }
        return bytes;
    }
}

