/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.junit.runner;

import com.agitar.coverage.CoverageManager;
import com.agitar.junit.runner.AgitarTestSuite;
import com.agitar.testrunner.StackTraceFilter;
import com.agitar.testrunner.UserProject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class SuperRunnerTestRunner
implements TestListener {
    public static final String CP_FLAG = "cp=";
    public static final String CP_PROPERTY = "superrunner.cp";
    public static final String SHOWOUTPUT_FLAG = "showoutput=";
    public static final String FORMATTER_FLAG = "formatter=";
    public static final String FILTERTRACE_FLAG = "filtertrace=";
    public static final String HALT_ON_FAILURE_FALG = "haltOnFailure=";
    public static final String HALT_ON_ERROR_FLAG = "haltOnError=";
    public static final String ROOT_FLAG = "root=";
    public static final String TESTSFILE_FLAG = "testsfile=";
    public static final String PROP_FILE_FLAGS = "propsfile=";
    public static final String NAME_FLAG = "name=";
    public static final String TESTCLASSES_FLAG = "testclasses=";
    public static final String MERGE_COVERAGE_FLAG = "mergeCoverage=";
    public static final String RESULTS_DIR_FLAG = "resultsDir=";
    public static final String IGNORE_HAND_WRITTEN_TESTS_FLAG = "ignoreHandWrittenTests";
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    public static final int INTERNAL_ERROR = 3;
    public static final String IGNORED_FILE_NAME = "IGNORETHIS";
    private Vector formatters = new Vector();
    private TestResult res;
    private static boolean filtertrace = true;
    private boolean showOutput = false;
    private Permissions perm = null;
    private static final String[] DEFAULT_TRACE_FILTERS = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke(", "sun.reflect.", "org.apache.tools.ant.", "org.junit.", "junit.framework.JUnit4TestAdapter", "Caused by: java.lang.AssertionError", " more"};
    private boolean haltOnError = false;
    private boolean haltOnFailure = false;
    private Test suite = null;
    private Throwable exception;
    private int retCode = 0;
    private JUnitTest junitTest;
    private PrintStream systemError;
    private PrintStream systemOut;
    private boolean forked = false;
    private static boolean multipleTests = false;
    private boolean junit4;
    private PrintStream savedOut = null;
    private boolean outputToFormatters = true;
    private ClassLoader loader;
    private static Vector fromCmdLine = new Vector();
    static /* synthetic */ Class class$java$lang$Throwable;

    public SuperRunnerTestRunner(JUnitTest test, boolean haltOnError, boolean haltOnFailure) {
        this(test, haltOnError, haltOnFailure, false);
    }

    public SuperRunnerTestRunner(JUnitTest test, boolean haltOnError, boolean haltOnFailure, boolean showOutput) {
        this(test, haltOnError, haltOnFailure, showOutput, null);
    }

    public SuperRunnerTestRunner(JUnitTest test, boolean haltOnError, boolean haltOnFailure, ClassLoader loader) {
        this(test, haltOnError, haltOnFailure, false, loader);
    }

    public SuperRunnerTestRunner(JUnitTest test, boolean haltOnError, boolean haltOnFailure, boolean showOutput, ClassLoader loader) {
        this.junitTest = test;
        this.haltOnError = haltOnError;
        this.haltOnFailure = haltOnFailure;
        this.showOutput = showOutput;
        this.loader = loader;
        try {
            Class<?> testClass = null;
            testClass = loader == null ? Class.forName(test.getName()) : Class.forName(test.getName(), true, loader);
            Method suiteMethod = null;
            try {
                suiteMethod = testClass.getMethod("suite", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            this.suite = suiteMethod != null ? (Test)suiteMethod.invoke(null, (Object[])new Class[0]) : new TestSuite(testClass);
        }
        catch (Exception e) {
            this.retCode = 2;
            this.exception = e;
        }
        catch (NoClassDefFoundError classMissing) {
            this.retCode = 2;
            this.exception = classMissing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean startTestSuiteSuccess;
        PrintStream savedErr;
        ByteArrayOutputStream outStrm;
        ByteArrayOutputStream errStrm;
        block35: {
            this.res = new TestResult();
            this.res.addListener(this.wrapListener(this));
            for (int i = 0; i < this.formatters.size(); ++i) {
                this.res.addListener(this.wrapListener((TestListener)this.formatters.elementAt(i)));
            }
            errStrm = new ByteArrayOutputStream();
            this.systemError = new PrintStream(errStrm);
            outStrm = new ByteArrayOutputStream();
            this.systemOut = new PrintStream(outStrm);
            savedErr = null;
            if (this.forked) {
                if (!this.outputToFormatters) {
                    if (!this.showOutput) {
                        this.savedOut = System.out;
                        savedErr = System.err;
                        System.setOut(new PrintStream(new OutputStream(){

                            public void write(int b) {
                            }
                        }));
                        System.setErr(new PrintStream(new OutputStream(){

                            public void write(int b) {
                            }
                        }));
                    }
                } else {
                    this.savedOut = System.out;
                    savedErr = System.err;
                    if (!this.showOutput) {
                        System.setOut(this.systemOut);
                        System.setErr(this.systemError);
                    } else {
                        System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.savedOut, (OutputStream)this.systemOut)));
                        System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)savedErr, (OutputStream)this.systemError)));
                    }
                    this.perm = null;
                }
            } else if (this.perm != null) {
                this.perm.setSecurityManager();
            }
            Object suite = null;
            Throwable exception = null;
            startTestSuiteSuccess = false;
            try {
                block37: {
                    long start;
                    block38: {
                        block34: {
                            int[] cnts2;
                            block36: {
                                block33: {
                                    try {
                                        Class<?> testClass = null;
                                        testClass = this.loader == null ? Class.forName(this.junitTest.getName()) : Class.forName(this.junitTest.getName(), true, this.loader);
                                        Method suiteMethod = null;
                                        try {
                                            suiteMethod = testClass.getMethod("suite", new Class[0]);
                                        }
                                        catch (NoSuchMethodException e) {
                                            // empty catch block
                                        }
                                        if (suiteMethod != null) {
                                            suite = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
                                            break block33;
                                        }
                                        Class<?> junit4TestAdapterClass = null;
                                        try {
                                            Class.forName("java.lang.annotation.Annotation");
                                            junit4TestAdapterClass = this.loader == null ? Class.forName("junit.framework.JUnit4TestAdapter") : Class.forName("junit.framework.JUnit4TestAdapter", true, this.loader);
                                        }
                                        catch (ClassNotFoundException e) {
                                            // empty catch block
                                        }
                                        boolean bl = this.junit4 = junit4TestAdapterClass != null;
                                        suite = this.junit4 ? (Test)junit4TestAdapterClass.getConstructor(Class.class).newInstance(testClass) : new AgitarTestSuite(testClass);
                                    }
                                    catch (Throwable e) {
                                        this.retCode = 2;
                                        exception = e;
                                    }
                                }
                                start = System.currentTimeMillis();
                                this.fireStartTestSuite();
                                startTestSuiteSuccess = true;
                                if (exception == null) break block36;
                                for (int i = 0; i < this.formatters.size(); ++i) {
                                    ((TestListener)this.formatters.elementAt(i)).addError(null, exception);
                                }
                                this.junitTest.setCounts(1L, 0L, 1L);
                                this.junitTest.setRunTime(0L);
                                break block37;
                            }
                            try {
                                suite.run(this.res);
                                Object var12_16 = null;
                                if (!this.junit4) break block34;
                                cnts2 = this.findJUnit4FailureErrorCount(this.res);
                            }
                            catch (Throwable throwable) {
                                Object var12_17 = null;
                                if (this.junit4) {
                                    int[] cnts2 = this.findJUnit4FailureErrorCount(this.res);
                                    this.junitTest.setCounts((long)this.res.runCount(), (long)cnts2[0], (long)cnts2[1]);
                                } else {
                                    this.junitTest.setCounts((long)this.res.runCount(), (long)this.res.failureCount(), (long)this.res.errorCount());
                                }
                                this.junitTest.setRunTime(System.currentTimeMillis() - start);
                                throw throwable;
                            }
                            this.junitTest.setCounts((long)this.res.runCount(), (long)cnts2[0], (long)cnts2[1]);
                            break block38;
                        }
                        this.junitTest.setCounts((long)this.res.runCount(), (long)this.res.failureCount(), (long)this.res.errorCount());
                    }
                    this.junitTest.setRunTime(System.currentTimeMillis() - start);
                    {
                    }
                }
                Object var15_21 = null;
                if (this.perm == null) break block35;
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (this.perm != null) {
                    this.perm.restoreSecurityManager();
                }
                if (this.savedOut != null) {
                    System.setOut(this.savedOut);
                }
                if (savedErr != null) {
                    System.setErr(savedErr);
                }
                this.systemError.close();
                this.systemError = null;
                this.systemOut.close();
                this.systemOut = null;
                if (startTestSuiteSuccess) {
                    this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
                }
                throw throwable;
            }
            this.perm.restoreSecurityManager();
        }
        if (this.savedOut != null) {
            System.setOut(this.savedOut);
        }
        if (savedErr != null) {
            System.setErr(savedErr);
        }
        this.systemError.close();
        this.systemError = null;
        this.systemOut.close();
        this.systemOut = null;
        if (startTestSuiteSuccess) {
            this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.res.errorCount() != 0) {
            this.retCode = 2;
        } else if (this.res.failureCount() != 0) {
            this.retCode = 1;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        if (this.haltOnFailure) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        if (this.haltOnError) {
            this.res.stop();
        }
    }

    public void setPermissions(Permissions permissions) {
        this.perm = permissions;
    }

    protected void handleOutput(String output) {
        if (this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        return -1;
    }

    protected void handleErrorOutput(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    protected void handleFlush(String output) {
        if (this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    protected void handleErrorFlush(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    private void sendOutAndErr(String out, String err) {
        for (int i = 0; i < this.formatters.size(); ++i) {
            JUnitResultFormatter formatter = (JUnitResultFormatter)this.formatters.elementAt(i);
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
        }
    }

    private void fireStartTestSuite() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).startTestSuite(this.junitTest);
        }
    }

    private void fireEndTestSuite() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).endTestSuite(this.junitTest);
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    public static void main(String[] args) throws IOException {
        int returnCode;
        block39: {
            boolean haltError = false;
            boolean haltFail = false;
            boolean stackfilter = true;
            Properties props = new Properties();
            boolean showOut = false;
            boolean mergeCoverage = true;
            String resultsDir = null;
            String cp = null;
            String name = null;
            String root = null;
            boolean runHandWrittenTests = true;
            if (args.length == 0) {
                System.err.println("required argument TestClassName missing");
                System.exit(2);
            }
            if (args[0].startsWith(TESTSFILE_FLAG)) {
                multipleTests = true;
                args[0] = args[0].substring(10);
            }
            for (int i = 1; i < args.length; ++i) {
                if (args[i].startsWith(HALT_ON_ERROR_FLAG)) {
                    haltError = Project.toBoolean((String)args[i].substring(12));
                    continue;
                }
                if (args[i].startsWith(HALT_ON_FAILURE_FALG)) {
                    haltFail = Project.toBoolean((String)args[i].substring(14));
                    continue;
                }
                if (args[i].startsWith(FILTERTRACE_FLAG)) {
                    stackfilter = Project.toBoolean((String)args[i].substring(12));
                    continue;
                }
                if (args[i].startsWith(FORMATTER_FLAG)) {
                    try {
                        SuperRunnerTestRunner.createAndStoreFormatter(args[i].substring(10));
                    }
                    catch (BuildException be) {
                        System.err.println(be.getMessage());
                        System.exit(2);
                    }
                    continue;
                }
                if (args[i].startsWith(PROP_FILE_FLAGS)) {
                    FileInputStream in = new FileInputStream(args[i].substring(10));
                    props.load(in);
                    in.close();
                    continue;
                }
                if (args[i].startsWith(SHOWOUTPUT_FLAG)) {
                    showOut = Project.toBoolean((String)args[i].substring(11));
                    continue;
                }
                if (args[i].startsWith(RESULTS_DIR_FLAG)) {
                    resultsDir = Project.translatePath((String)args[i].substring(RESULTS_DIR_FLAG.length()));
                    continue;
                }
                if (args[i].startsWith(MERGE_COVERAGE_FLAG)) {
                    mergeCoverage = Project.toBoolean((String)args[i].substring(14));
                    continue;
                }
                if (args[i].startsWith(CP_FLAG)) {
                    cp = Project.translatePath((String)args[i].substring(3));
                    continue;
                }
                if (args[i].startsWith(NAME_FLAG)) {
                    name = args[i].substring(5);
                    continue;
                }
                if (args[i].startsWith(ROOT_FLAG)) {
                    root = Project.translatePath((String)args[i].substring(5));
                    continue;
                }
                if (args[i].startsWith(TESTCLASSES_FLAG)) {
                    String[] testClasses = args[i].substring(TESTCLASSES_FLAG.length()).split(",");
                    if (testClasses.length > 1) {
                        multipleTests = true;
                    } else {
                        if (testClasses.length == 1) {
                            args[0] = testClasses[0];
                            continue;
                        }
                        System.err.println("Must provide test class names with testclasses flag");
                        System.exit(2);
                    }
                    File f = null;
                    f = File.createTempFile("SuperRun", "Test.properties");
                    PrintWriter pw = new PrintWriter(new FileWriter(f));
                    for (int ti = 0; ti < testClasses.length; ++ti) {
                        pw.println(testClasses[ti] + "," + root + File.separator + "test-results,TEST-" + testClasses[ti]);
                    }
                    pw.close();
                    args[0] = f.getAbsolutePath();
                    continue;
                }
                if (!IGNORE_HAND_WRITTEN_TESTS_FLAG.equals(args[i])) continue;
                runHandWrittenTests = false;
            }
            if (cp == null && (cp = Project.translatePath((String)props.getProperty(CP_PROPERTY, ""))).trim().length() == 0) {
                cp = null;
            }
            if (cp == null || name == null || root == null) {
                System.err.println("required argument cp, name, or root missing");
                System.exit(2);
            }
            Properties p = System.getProperties();
            Enumeration e = ((Hashtable)p).keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                props.put(key, ((Hashtable)p).get(key));
            }
            returnCode = 0;
            try {
                if (multipleTests) {
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
                        int code = 0;
                        boolean errorOccured = false;
                        boolean failureOccured = false;
                        HashMap<String, JUnitTest> tests = new HashMap<String, JUnitTest>();
                        String line = null;
                        ArrayList<String> testCaseNames = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            StringTokenizer st = new StringTokenizer(line, ",");
                            String testCaseName = st.nextToken();
                            testCaseNames.add(testCaseName);
                            JUnitTest t = new JUnitTest(testCaseName);
                            t.setTodir(new File(st.nextToken()));
                            t.setOutfile(st.nextToken());
                            tests.put(testCaseName, t);
                        }
                        String[] testClassNames = testCaseNames.toArray(new String[testCaseNames.size()]);
                        UserProject proj = new UserProject(cp, root, name, testClassNames, true);
                        if (resultsDir != null) {
                            proj.setAgitarResultsDirectory(resultsDir);
                        }
                        CoverageManager.setCoverageDir((File)proj.getAgitarResultsDirectoryAsFile());
                        if (!mergeCoverage) {
                            CoverageManager.setLastModified();
                        }
                        testClassNames = proj.sortAgitarTestClassesLast(runHandWrittenTests);
                        for (int i = 0; i < testClassNames.length; ++i) {
                            JUnitTest t = (JUnitTest)tests.get(testClassNames[i]);
                            proj.resetClassLoader(t.getName(), true, true, true);
                            code = SuperRunnerTestRunner.launch(t, haltError, stackfilter, haltFail, showOut, props, proj.getClassLoader());
                            errorOccured = code == 2;
                            boolean bl = failureOccured = code != 0;
                            if (!errorOccured && !failureOccured) continue;
                            if (errorOccured && haltError || failureOccured && haltFail) {
                                System.exit(code);
                                continue;
                            }
                            if (code > returnCode) {
                                returnCode = code;
                            }
                            System.out.println("TEST " + t.getName() + " FAILED");
                        }
                        break block39;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        break block39;
                    }
                }
                String[] testClassNames = new String[]{args[0]};
                UserProject proj = new UserProject(cp, root, name, testClassNames, true);
                if (resultsDir != null) {
                    proj.setAgitarResultsDirectory(resultsDir);
                }
                CoverageManager.setCoverageDir((File)proj.getAgitarResultsDirectoryAsFile());
                if (!mergeCoverage) {
                    CoverageManager.setLastModified();
                }
                proj.resetClassLoader(testClassNames[0], true, true, true);
                testClassNames = proj.sortAgitarTestClassesLast(runHandWrittenTests);
                if (testClassNames.length == 0) {
                    System.out.println("TEST " + args[0] + " is not an AgitarTestCase; skipping.");
                } else {
                    returnCode = SuperRunnerTestRunner.launch(new JUnitTest(args[0]), haltError, stackfilter, haltFail, showOut, props, proj.getClassLoader());
                }
            }
            catch (Throwable re) {
                System.err.println("Caught unexpected exception: " + re.getClass().getName());
                re.printStackTrace();
                returnCode = 3;
            }
        }
        CoverageManager.saveAllCoverage((boolean)true, (File)CoverageManager.getCoverageDir());
        System.exit(returnCode);
    }

    private static void transferFormatters(SuperRunnerTestRunner runner, JUnitTest test) {
        try {
            Class feClass = FormatterElement.class;
            Method getUseFileMethod = feClass.getDeclaredMethod("getUseFile", null);
            getUseFileMethod.setAccessible(true);
            Method setOutfileMethod = feClass.getDeclaredMethod("setOutfile", File.class);
            setOutfileMethod.setAccessible(true);
            Method createFormatterMethod = feClass.getDeclaredMethod("createFormatter", null);
            createFormatterMethod.setAccessible(true);
            for (int i = 0; i < fromCmdLine.size(); ++i) {
                FormatterElement fe = (FormatterElement)fromCmdLine.elementAt(i);
                Boolean useFile = (Boolean)getUseFileMethod.invoke((Object)fe, null);
                if (multipleTests && useFile.booleanValue()) {
                    File destFile = new File(test.getTodir(), test.getOutfile() + fe.getExtension());
                    setOutfileMethod.invoke((Object)fe, destFile);
                }
                runner.addFormatter((JUnitResultFormatter)createFormatterMethod.invoke((Object)fe, null));
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        FormatterElement fe = new FormatterElement();
        int pos = line.indexOf(44);
        if (pos == -1) {
            fe.setClassname(line);
            fe.setUseFile(false);
        } else {
            fe.setClassname(line.substring(0, pos));
            fe.setUseFile(true);
            if (!multipleTests) {
                Class feClass = FormatterElement.class;
                try {
                    Method setOutfileMethod = feClass.getDeclaredMethod("setOutfile", File.class);
                    setOutfileMethod.setAccessible(true);
                    setOutfileMethod.invoke((Object)fe, new File(line.substring(pos + 1)));
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            } else {
                int fName = line.indexOf(IGNORED_FILE_NAME);
                if (fName > -1) {
                    fe.setExtension(line.substring(fName + IGNORED_FILE_NAME.length()));
                }
            }
        }
        fromCmdLine.addElement(fe);
    }

    public static String getFilteredTrace(Throwable t) {
        String trace = StringUtils.getStackTrace((Throwable)StackTraceFilter.filter(t));
        return SuperRunnerTestRunner.filterStack(trace);
    }

    public static String filterStack(String stack) {
        if (!filtertrace) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (SuperRunnerTestRunner.filterLine(line)) continue;
                pw.println(line);
            }
        }
        catch (Exception IOException2) {
            return stack;
        }
        return sw.toString();
    }

    private static boolean filterLine(String line) {
        for (int i = 0; i < DEFAULT_TRACE_FILTERS.length; ++i) {
            if (line.indexOf(DEFAULT_TRACE_FILTERS[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    private static int launch(JUnitTest t, boolean haltError, boolean stackfilter, boolean haltFail, boolean showOut, Properties props, ClassLoader loader) {
        t.setProperties((Hashtable)props);
        filtertrace = stackfilter;
        SuperRunnerTestRunner runner = new SuperRunnerTestRunner(t, haltError, haltFail, showOut, loader);
        runner.forked = true;
        SuperRunnerTestRunner.transferFormatters(runner, t);
        runner.run();
        return runner.getRetCode();
    }

    private TestListener wrapListener(final TestListener testListener) {
        return new TestListener(){

            public void addError(Test test, Throwable t) {
                if (SuperRunnerTestRunner.this.junit4 && t instanceof AssertionFailedError) {
                    testListener.addFailure(test, (AssertionFailedError)t);
                } else if (SuperRunnerTestRunner.this.junit4 && t.getClass().getName().equals("java.lang.AssertionError")) {
                    try {
                        String msg = t.getMessage();
                        AssertionFailedError failure = msg != null ? new AssertionFailedError(msg) : new AssertionFailedError();
                        Method initCause = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = SuperRunnerTestRunner.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = SuperRunnerTestRunner.class$("java.lang.Throwable")) : class$java$lang$Throwable);
                        initCause.invoke((Object)failure, t);
                        testListener.addFailure(test, failure);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        testListener.addError(test, t);
                    }
                } else {
                    testListener.addError(test, t);
                }
            }

            public void addFailure(Test test, AssertionFailedError t) {
                testListener.addFailure(test, t);
            }

            public void addFailure(Test test, Throwable t) {
                if (t instanceof AssertionFailedError) {
                    testListener.addFailure(test, (AssertionFailedError)t);
                } else {
                    testListener.addError(test, t);
                }
            }

            public void endTest(Test test) {
                testListener.endTest(test);
            }

            public void startTest(Test test) {
                testListener.startTest(test);
            }
        };
    }

    private int[] findJUnit4FailureErrorCount(TestResult res) {
        int failures = 0;
        int errors = 0;
        Enumeration e = res.failures();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++failures;
        }
        e = res.errors();
        while (e.hasMoreElements()) {
            Throwable t = ((TestFailure)e.nextElement()).thrownException();
            if (t instanceof AssertionFailedError || t.getClass().getName().equals("java.lang.AssertionError")) {
                ++failures;
                continue;
            }
            ++errors;
        }
        return new int[]{failures, errors};
    }
}

