/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.junit.runner;

import com.agitar.common.types.ClassName;
import com.agitar.common.util.DefiningClassLoader;
import com.agitar.common.util.IOUtility;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.TestRunProperties;
import com.agitar.coverage.CoverageManager;
import com.agitar.junit.runner.SuperRunnerTestRunner;
import com.agitar.lib.NoObfuscation;
import com.agitar.lib.junit.AgitarTestCase;
import com.agitar.lib.mockingbird.Mockingbird;
import com.agitar.testrunner.Paths;
import com.agitar.testrunner.UserProject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.attrs.SignatureAttribute;

public class SuperRunnerTask
extends Task {
    private boolean ignoreHandWrittenTests;
    private CommandlineJava commandline;
    private CommandlineJava classpathCommandline = new CommandlineJava();
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;
    private boolean reloading = true;
    private String summaryValue = "";
    private SuperRunnerTestRunner runner = null;
    private boolean newEnvironment = false;
    private Environment env = new Environment();
    private boolean includeAntRuntime = true;
    private Path antRuntimeClasses = null;
    private boolean showOutput = false;
    private File tmpDir;
    private AntClassLoader classLoader = null;
    private Permissions perm = null;
    private ForkMode forkMode = new ForkMode("perTest");
    private boolean mergeCoverage = true;
    private File resultsDir;
    private static final int STRING_BUFFER_SIZE = 128;
    private int batchSize = -1;
    private boolean filterTrace;
    private boolean haltOnError;
    private String errorProperty;
    private boolean fork;
    private boolean haltOnFail;
    private String failureProperty;
    private static final String KEEP_TEMP_FILES_STR = "KEEP_TEMP_FILES";
    private boolean deleteTempFiles = true;
    public static final String SUPPER_RUNNER_PROPERTIES = "SuperRunner.properties";
    private List superRunnerProperties = new ArrayList();
    static /* synthetic */ Class class$com$agitar$junit$runner$SuperRunnerTask$ForkedTestConfiguration;

    public void setReloading(boolean value) {
        this.reloading = value;
    }

    public void setFiltertrace(boolean value) {
        this.filterTrace = value;
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setFiltertrace(value);
        }
    }

    public void setHaltonerror(boolean value) {
        this.haltOnError = value;
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setHaltonerror(value);
        }
    }

    public void setErrorProperty(String propertyName) {
        this.errorProperty = propertyName;
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setErrorProperty(propertyName);
        }
    }

    public void setHaltonfailure(boolean value) {
        this.haltOnFail = value;
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setHaltonfailure(value);
        }
    }

    public void setFailureProperty(String propertyName) {
        this.failureProperty = propertyName;
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setFailureProperty(propertyName);
        }
    }

    public void setFork(boolean value) {
        this.fork = value;
        Enumeration e = this.allTests();
        while (e.hasMoreElements()) {
            BaseTest test = (BaseTest)e.nextElement();
            test.setFork(value);
        }
    }

    public void setForkMode(ForkMode mode) {
        this.forkMode = mode;
    }

    public void setPrintsummary(SummaryAttribute value) {
        this.summaryValue = value.getValue();
        this.summary = value.asBoolean();
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public void setMaxmemory(String max) {
        this.getCommandline().setMaxmemory(max);
    }

    public void setJvm(String value) {
        this.getCommandline().setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.getCommandline().createVmArgument();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.getCommandline().addSysproperty(sysp);
    }

    public void addConfiguredSysproperty(Environment.Variable sysp) {
        String testString = sysp.getContent();
        this.getProject().log("sysproperty added : " + testString, 4);
        this.getCommandline().addSysproperty(sysp);
    }

    public void addSyspropertyset(PropertySet sysp) {
        this.getCommandline().addSyspropertyset(sysp);
    }

    public Path createClasspath() {
        return this.classpathCommandline.createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.getCommandline().createBootclasspath(this.getProject()).createPath();
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void addTest(JUnitTest test) {
        this.tests.addElement(test);
        this.preConfigure((BaseTest)test);
    }

    public BatchTest createBatchTest() {
        BatchTest test = new BatchTest(this.getProject());
        this.batchTests.addElement(test);
        this.preConfigure((BaseTest)test);
        return test;
    }

    private void preConfigure(BaseTest test) {
        test.setFiltertrace(this.filterTrace);
        test.setHaltonerror(this.haltOnError);
        if (this.errorProperty != null) {
            test.setErrorProperty(this.errorProperty);
        }
        test.setHaltonfailure(this.haltOnFail);
        if (this.failureProperty != null) {
            test.setFailureProperty(this.failureProperty);
        }
        test.setFork(this.fork);
    }

    public void addFormatter(FormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public void setIncludeantruntime(boolean b) {
        this.includeAntRuntime = b;
    }

    public void setShowOutput(boolean showOutput) {
        this.showOutput = showOutput;
    }

    public void addAssertions(Assertions asserts) {
        if (this.getCommandline().getAssertions() != null) {
            throw new BuildException("Only one assertion declaration is allowed");
        }
        this.getCommandline().setAssertions(asserts);
    }

    public Permissions createPermissions() {
        if (this.perm == null) {
            this.perm = new Permissions();
        }
        return this.perm;
    }

    public SuperRunnerTask() {
        this.getCommandline().setClassname(SuperRunnerTestRunner.class.getName());
    }

    public void setTempdir(File tmpDir) {
        if (!(tmpDir == null || tmpDir.exists() && tmpDir.isDirectory())) {
            throw new BuildException(tmpDir.toString() + " is not a valid temp directory");
        }
        this.tmpDir = tmpDir;
    }

    public void init() {
        this.antRuntimeClasses = new Path(this.getProject());
        this.addClasspathEntry("/junit/framework/TestCase.class");
        this.addClasspathEntry("/org/apache/tools/ant/launch/AntMain.class");
        this.addClasspathEntry("/org/apache/tools/ant/Task.class");
        this.addClasspathEntry("/org/apache/tools/ant/taskdefs/optional/junit/FormatterElement.class");
        this.addClasspathEntry(this.getResource(ClassVisitor.class));
        this.addClasspathEntry(this.getResource(SignatureAttribute.class));
        this.addClasspathEntry(this.getResource(SuperRunnerTestRunner.class));
        this.addClasspathEntry(this.getResource(NoObfuscation.class));
        this.addClasspathEntry(this.getResource(CoverageManager.class));
        this.addClasspathEntry(this.getResource(IOUtility.class));
        this.addClasspathEntry(this.getResource(DefiningClassLoader.class));
        this.addClasspathEntry(this.getResource(Mockingbird.class));
        this.addClasspathEntry(this.getResource(UserProject.class));
        this.addClasspathEntry(this.getResource(AgitarTestCase.class));
    }

    private void init(File[] systemClassPath) {
        this.antRuntimeClasses = new Path(this.getProject());
        for (int i = 0; i < systemClassPath.length; ++i) {
            this.antRuntimeClasses.createPath().setLocation(systemClassPath[i]);
        }
    }

    private String getResource(Class cls) {
        return "/" + cls.getName().replace('.', '/') + ".class";
    }

    public void execute() throws BuildException {
        if (this.getProject().getProperty(KEEP_TEMP_FILES_STR) != null) {
            this.deleteTempFiles = false;
        }
        ArrayList testLists = new ArrayList();
        boolean forkPerTest = this.forkMode.getValue().equals("perTest");
        if (forkPerTest || this.forkMode.getValue().equals("once")) {
            testLists.addAll(this.executeOrQueue(this.getIndividualTests(), forkPerTest));
        } else {
            int count = this.batchTests.size();
            for (int i = 0; i < count; ++i) {
                BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
                testLists.addAll(this.executeOrQueue(batchtest.elements(), false));
            }
            testLists.addAll(this.executeOrQueue(this.tests.elements(), forkPerTest));
        }
        Iterator iter = testLists.iterator();
        while (iter.hasNext()) {
            List l = (List)iter.next();
            if (l.size() == 1) {
                this.execute((JUnitTest)l.get(0));
                continue;
            }
            if (this.batchSize > 0) {
                int remainingSize = l.size();
                int startIndex = 0;
                while (remainingSize > 0) {
                    int listSize = Math.min(remainingSize, this.batchSize);
                    List newList = l.subList(startIndex, startIndex + listSize);
                    this.execute(newList);
                    remainingSize -= listSize;
                    startIndex += listSize;
                }
                continue;
            }
            this.execute(l);
        }
    }

    protected void execute(JUnitTest arg) throws BuildException {
        JUnitTest test;
        if (this.getProject().getProperty(KEEP_TEMP_FILES_STR) != null) {
            this.deleteTempFiles = false;
        }
        if ((test = (JUnitTest)arg.clone()).getTodir() == null) {
            test.setTodir(this.getProject().resolveFile("."));
        }
        if (test.getOutfile() == null) {
            test.setOutfile("TEST-" + test.getName());
        }
        int exitValue = 2;
        boolean wasKilled = false;
        ExecuteWatchdog watchdog = this.createWatchdog();
        exitValue = this.executeAsForked(test, watchdog, null);
        if (watchdog != null) {
            wasKilled = watchdog.killedProcess();
        }
        this.actOnTestResult(exitValue, wasKilled, test, "Test " + test.getName());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void execute(List tests) throws BuildException {
        if (this.getProject().getProperty(KEEP_TEMP_FILES_STR) != null) {
            this.deleteTempFiles = false;
        }
        JUnitTest test = null;
        File casesFile = this.createTempPropertiesFile("junittestcases");
        PrintWriter writer = null;
        writer = new PrintWriter(new BufferedWriter(new FileWriter(casesFile)));
        Iterator iter = tests.iterator();
        while (iter.hasNext()) {
            test = (JUnitTest)iter.next();
            writer.print(test.getName());
            if (test.getTodir() == null) {
                writer.print("," + this.getProject().resolveFile("."));
            } else {
                writer.print("," + test.getTodir());
            }
            if (test.getOutfile() == null) {
                writer.println(",TEST-" + test.getName());
                continue;
            }
            writer.println("," + test.getOutfile());
        }
        writer.flush();
        writer.close();
        writer = null;
        int exitValue = 2;
        boolean wasKilled = false;
        ExecuteWatchdog watchdog = this.createWatchdog();
        exitValue = this.executeAsForked(test, watchdog, casesFile);
        if (watchdog != null) {
            wasKilled = watchdog.killedProcess();
        }
        this.actOnTestResult(exitValue, wasKilled, test, "Tests");
        Object var10_10 = null;
        if (writer != null) {
            writer.close();
        }
        if (!this.deleteTempFiles) return;
        try {
            casesFile.delete();
            return;
        }
        catch (Exception e) {
            this.log(e.toString(), 0);
        }
        return;
        {
            catch (IOException e) {
                this.log(e.toString(), 0);
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (writer != null) {
                writer.close();
            }
            if (!this.deleteTempFiles) throw throwable;
            try {
                casesFile.delete();
                throw throwable;
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeAsForked(JUnitTest test, ExecuteWatchdog watchdog, File casesFile) throws BuildException {
        int retVal;
        File propsFile;
        block29: {
            String[] environment;
            if (this.getProject().getProperty(KEEP_TEMP_FILES_STR) != null) {
                this.deleteTempFiles = false;
            }
            if (this.perm != null) {
                this.log("Permissions ignored when running in forked mode!", 1);
            }
            CommandlineJava cmd = null;
            try {
                cmd = (CommandlineJava)this.getCommandline().clone();
                cmd.setClassname(SuperRunnerTestRunner.class.getName());
            }
            catch (CloneNotSupportedException e) {
                throw new BuildException("Could not clone SuperRunner command line", (Throwable)e);
            }
            if (casesFile == null) {
                cmd.createArgument().setValue(test.getName());
            } else {
                this.log("Running multiple tests in the same VM", 3);
                this.addCmdArgument(cmd, "testsfile=" + casesFile);
            }
            this.addCmdArgument(cmd, "filtertrace=" + test.getFiltertrace());
            this.addCmdArgument(cmd, "haltOnError=" + test.getHaltonerror());
            this.addCmdArgument(cmd, "haltOnFailure=" + test.getHaltonfailure());
            this.addCmdArgument(cmd, "root=" + this.getProject().getBaseDir().getAbsolutePath());
            this.addCmdArgument(cmd, "name=" + this.getProject().getName());
            this.getProject().setProperty("superrunner.cp", this.classpathCommandline.getClasspath() == null ? "" : this.classpathCommandline.getClasspath().toString());
            if (this.includeAntRuntime) {
                Vector v = Execute.getProcEnvironment();
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    String s = (String)e.nextElement();
                    if (!s.startsWith("CLASSPATH=")) continue;
                    cmd.createClasspath(this.getProject()).createPath().append(new Path(this.getProject(), s.substring(10)));
                }
                this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
                cmd.createClasspath(this.getProject()).createPath().append(this.antRuntimeClasses);
            }
            if (this.summary) {
                this.log("Running " + test.getName(), 2);
                this.addCmdArgument(cmd, "formatter=" + SummaryJUnitResultFormatter.class.getName());
            }
            if (this.resultsDir != null) {
                try {
                    this.addCmdArgument(cmd, "resultsDir=" + this.resultsDir.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new BuildException("resultsDir is invalid", (Throwable)e);
                }
            }
            this.addCmdArgument(cmd, "mergeCoverage=" + String.valueOf(this.mergeCoverage));
            this.addCmdArgument(cmd, "showoutput=" + String.valueOf(this.showOutput));
            StringBuffer formatterArg = new StringBuffer(128);
            FormatterElement[] feArray = this.mergeFormatters(test);
            for (int i = 0; i < feArray.length; ++i) {
                FormatterElement fe = feArray[i];
                if (!fe.shouldUse((Task)this)) continue;
                formatterArg.append("formatter=");
                formatterArg.append(fe.getClassname());
                File outFile = this.getOutput(fe, test);
                if (outFile != null) {
                    formatterArg.append(",");
                    formatterArg.append(outFile);
                }
                this.addCmdArgument(cmd, formatterArg.toString());
                formatterArg = new StringBuffer();
            }
            propsFile = this.createTempPropertiesFile("junit");
            this.addCmdArgument(cmd, "propsfile=" + propsFile.getAbsolutePath());
            if (this.ignoreHandWrittenTests) {
                this.addCmdArgument(cmd, "ignoreHandWrittenTests");
            }
            Hashtable p = this.getProject().getProperties();
            Properties props = new Properties();
            Enumeration e = p.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                props.put(key, p.get(key));
            }
            try {
                FileOutputStream outstream = new FileOutputStream(propsFile);
                props.store(outstream, "Ant JUnitTask generated properties file");
                outstream.close();
            }
            catch (IOException e2) {
                if (!this.deleteTempFiles) throw new BuildException("Error creating temporary properties file.", (Throwable)e2, this.getLocation());
                propsFile.delete();
                throw new BuildException("Error creating temporary properties file.", (Throwable)e2, this.getLocation());
            }
            if (!this.deleteTempFiles) {
                this.writeSuperRunnerProperties();
            }
            Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), watchdog);
            execute.setCommandline(cmd.getCommandline());
            execute.setAntRun(this.getProject());
            if (this.dir != null) {
                execute.setWorkingDirectory(this.dir);
            }
            if ((environment = this.env.getVariables()) != null) {
                for (int i = 0; i < environment.length; ++i) {
                    this.log("Setting environment variable: " + environment[i], 3);
                }
            }
            execute.setNewenvironment(this.newEnvironment);
            execute.setEnvironment(environment);
            this.log(cmd.describeCommand(), 3);
            try {
                try {
                    retVal = execute.execute();
                }
                catch (IOException e2) {
                    throw new BuildException("Process fork failed.", (Throwable)e2, this.getLocation());
                }
                Object var15_18 = null;
                if (watchdog == null) break block29;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (watchdog != null && watchdog.killedProcess()) {
                    this.logTimeout(feArray, test);
                }
                if (!this.deleteTempFiles) throw throwable;
                propsFile.delete();
                throw throwable;
            }
            if (watchdog.killedProcess()) {
                this.logTimeout(feArray, test);
            }
        }
        if (!this.deleteTempFiles) return retVal;
        propsFile.delete();
        return retVal;
    }

    private File createTempPropertiesFile(String prefix) {
        File propsFile = FileUtils.newFileUtils().createTempFile(prefix, ".properties", this.tmpDir != null ? this.tmpDir : this.getProject().getBaseDir());
        return propsFile;
    }

    protected void handleOutput(String output) {
        if (this.runner != null) {
            this.runner.handleOutput(output);
            if (this.showOutput) {
                super.handleOutput(output);
            }
        } else {
            super.handleOutput(output);
        }
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.runner != null) {
            return this.runner.handleInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    protected void handleFlush(String output) {
        if (this.runner != null) {
            this.runner.handleFlush(output);
            if (this.showOutput) {
                super.handleFlush(output);
            }
        } else {
            super.handleFlush(output);
        }
    }

    public void handleErrorOutput(String output) {
        if (this.runner != null) {
            this.runner.handleErrorOutput(output);
            if (this.showOutput) {
                super.handleErrorOutput(output);
            }
        } else {
            super.handleErrorOutput(output);
        }
    }

    public void handleErrorFlush(String output) {
        if (this.runner != null) {
            this.runner.handleErrorFlush(output);
            if (this.showOutput) {
                super.handleErrorFlush(output);
            }
        } else {
            super.handleErrorFlush(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInVM(JUnitTest arg) throws BuildException {
        int n;
        block15: {
            CommandlineJava.SysProperties sysProperties;
            JUnitTest test = (JUnitTest)arg.clone();
            test.setProperties(this.getProject().getProperties());
            if (this.dir != null) {
                this.log("dir attribute ignored if running in the same VM", 1);
            }
            if (this.newEnvironment || null != this.env.getVariables()) {
                this.log("Changes to environment variables are ignored if running in the same VM.", 1);
            }
            if (this.getCommandline().getBootclasspath() != null) {
                this.log("bootclasspath is ignored if running in the same VM.", 1);
            }
            if ((sysProperties = this.getCommandline().getSystemProperties()) != null) {
                sysProperties.setSystem();
            }
            try {
                this.log("Using System properties " + System.getProperties(), 3);
                this.createClassLoader();
                if (this.classLoader != null) {
                    this.classLoader.setThreadContextLoader();
                }
                this.runner = new SuperRunnerTestRunner(test, test.getHaltonerror(), test.getFiltertrace(), test.getHaltonfailure(), (ClassLoader)this.classLoader);
                if (this.summary) {
                    this.log("Running " + test.getName(), 2);
                    SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
                    f.setWithOutAndErr("withoutanderr".equalsIgnoreCase(this.summaryValue));
                    f.setOutput(this.getDefaultOutput());
                    this.runner.addFormatter((JUnitResultFormatter)f);
                }
                this.runner.setPermissions(this.perm);
                FormatterElement[] feArray = this.mergeFormatters(test);
                try {
                    Class feClass = FormatterElement.class;
                    Method setOutfileMethod = feClass.getDeclaredMethod("setOutfile", File.class);
                    setOutfileMethod.setAccessible(true);
                    Method createFormatterMethod = feClass.getDeclaredMethod("createFormatter", ClassLoader.class);
                    createFormatterMethod.setAccessible(true);
                    for (int i = 0; i < feArray.length; ++i) {
                        FormatterElement fe = feArray[i];
                        if (!fe.shouldUse((Task)this)) continue;
                        File outFile = this.getOutput(fe, test);
                        if (outFile != null) {
                            setOutfileMethod.invoke((Object)fe, outFile);
                        } else {
                            fe.setOutput(this.getDefaultOutput());
                        }
                        this.runner.addFormatter((JUnitResultFormatter)createFormatterMethod.invoke((Object)fe, this.classLoader));
                    }
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
                this.runner.run();
                n = this.runner.getRetCode();
                Object var12_13 = null;
                if (sysProperties == null) break block15;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var12_14 = null;
                    if (sysProperties != null) {
                        sysProperties.restoreSystem();
                    }
                    if (this.classLoader == null) break block16;
                    this.classLoader.resetThreadContextLoader();
                }
                throw throwable;
            }
            sysProperties.restoreSystem();
        }
        if (this.classLoader != null) {
            this.classLoader.resetThreadContextLoader();
        }
        return n;
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog((long)this.timeout.intValue());
    }

    protected OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    protected Enumeration getIndividualTests() {
        int count = this.batchTests.size();
        Enumeration[] enums = new Enumeration[count + 1];
        for (int i = 0; i < count; ++i) {
            BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
            enums[i] = batchtest.elements();
        }
        enums[enums.length - 1] = this.tests.elements();
        return Enumerations.fromCompound((Enumeration[])enums);
    }

    protected Enumeration allTests() {
        Enumeration[] enums = new Enumeration[]{this.tests.elements(), this.batchTests.elements()};
        return Enumerations.fromCompound((Enumeration[])enums);
    }

    private FormatterElement[] mergeFormatters(JUnitTest test) {
        Vector feVector = (Vector)this.formatters.clone();
        Enumeration e = feVector.elements();
        while (e.hasMoreElements()) {
            FormatterElement currFormatter = (FormatterElement)e.nextElement();
            test.addFormatter(currFormatter);
        }
        Object[] feArray = new FormatterElement[feVector.size()];
        feVector.copyInto(feArray);
        return feArray;
    }

    protected File getOutput(FormatterElement fe, JUnitTest test) {
        try {
            Class feClass = FormatterElement.class;
            Method getUseFileMethod = feClass.getDeclaredMethod("getUseFile", null);
            getUseFileMethod.setAccessible(true);
            Boolean useFile = (Boolean)getUseFileMethod.invoke((Object)fe, null);
            if (useFile.booleanValue()) {
                String filename = test.getOutfile() + fe.getExtension();
                File destFile = new File(test.getTodir(), filename);
                String absFilename = destFile.getAbsolutePath();
                return this.getProject().resolveFile(absFilename);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return null;
    }

    protected void addClasspathEntry(String resource) {
        resource = resource.startsWith("/") ? resource.substring(1) : "com/agitar/junit/runner/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f != null) {
            this.log("Found " + f.getAbsolutePath(), 4);
            this.antRuntimeClasses.createPath().setLocation(f);
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    private void logTimeout(FormatterElement[] feArray, JUnitTest test) {
        this.createClassLoader();
        test.setCounts(1L, 0L, 1L);
        test.setProperties(this.getProject().getProperties());
        Method createFormatterMethod = null;
        try {
            Class feClass = FormatterElement.class;
            createFormatterMethod = feClass.getDeclaredMethod("createFormatter", null);
            createFormatterMethod.setAccessible(true);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        for (int i = 0; i < feArray.length; ++i) {
            FormatterElement fe = feArray[i];
            File outFile = this.getOutput(fe, test);
            try {
                JUnitResultFormatter formatter = (JUnitResultFormatter)createFormatterMethod.invoke((Object)fe, this.classLoader);
                if (outFile == null || formatter == null) continue;
                try {
                    FileOutputStream out = new FileOutputStream(outFile);
                    this.addTimeout(test, formatter, out);
                }
                catch (IOException e) {}
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.summary) {
            SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
            f.setWithOutAndErr("withoutanderr".equalsIgnoreCase(this.summaryValue));
            this.addTimeout(test, (JUnitResultFormatter)f, this.getDefaultOutput());
        }
    }

    private void addTimeout(JUnitTest test, JUnitResultFormatter formatter, OutputStream out) {
        formatter.setOutput(out);
        formatter.startTestSuite(test);
        Test t = new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult r) {
                throw new AssertionFailedError("Timeout occurred");
            }
        };
        formatter.startTest(t);
        formatter.addError(t, (Throwable)new AssertionFailedError("Timeout occurred"));
        formatter.endTestSuite(test);
    }

    private void createClassLoader() {
        Path userClasspath = this.getCommandline().getClasspath();
        if (userClasspath != null && (this.reloading || this.classLoader == null)) {
            Path classpath = (Path)userClasspath.clone();
            if (this.includeAntRuntime) {
                this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
                classpath.append(this.antRuntimeClasses);
            }
            this.classLoader = this.getProject().createClassLoader(classpath);
            this.log("Using CLASSPATH " + this.classLoader.getClasspath(), 3);
            this.classLoader.setParentFirst(false);
            this.classLoader.addJavaLibraries();
            this.log("Using CLASSPATH " + this.classLoader.getClasspath(), 3);
            this.classLoader.addSystemPackageRoot("junit");
            this.classLoader.addSystemPackageRoot("org.apache.tools.ant");
        }
    }

    protected CommandlineJava getCommandline() {
        if (this.commandline == null) {
            this.commandline = new CommandlineJava();
            Commandline.Argument defaultHeadlessArg = this.commandline.createVmArgument();
            defaultHeadlessArg.setValue("-Djava.awt.headless=true");
        }
        return this.commandline;
    }

    protected Collection executeOrQueue(Enumeration testList, boolean runIndividual) {
        HashMap<ForkedTestConfiguration, ArrayList<JUnitTest>> testConfigurations = new HashMap<ForkedTestConfiguration, ArrayList<JUnitTest>>();
        while (testList.hasMoreElements()) {
            JUnitTest test = (JUnitTest)testList.nextElement();
            if (!test.shouldRun(this.getProject())) continue;
            if (runIndividual || !test.getFork()) {
                this.execute(test);
                continue;
            }
            ForkedTestConfiguration c = new ForkedTestConfiguration(test);
            ArrayList<JUnitTest> l = (ArrayList<JUnitTest>)testConfigurations.get(c);
            if (l == null) {
                l = new ArrayList<JUnitTest>();
                testConfigurations.put(c, l);
            }
            l.add(test);
        }
        return testConfigurations.values();
    }

    protected void actOnTestResult(int exitValue, boolean wasKilled, JUnitTest test, String name) {
        boolean failureOccurredHere;
        boolean errorOccurredHere = exitValue == 2 || wasKilled;
        boolean bl = failureOccurredHere = exitValue != 0 || wasKilled;
        if (errorOccurredHere || failureOccurredHere) {
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException(name + " failed" + (wasKilled ? " (timeout)" : ""), this.getLocation());
            }
            this.log(name + " FAILED" + (wasKilled ? " (timeout)" : ""), 0);
            if (errorOccurredHere && test.getErrorProperty() != null) {
                this.getProject().setNewProperty(test.getErrorProperty(), "true");
            }
            if (failureOccurredHere && test.getFailureProperty() != null) {
                this.getProject().setNewProperty(test.getFailureProperty(), "true");
            }
        }
    }

    private void addCmdArgument(CommandlineJava cmd, String value) {
        cmd.createArgument().setValue(value);
        this.superRunnerProperties.add(value);
    }

    private void writeSuperRunnerProperties() {
        File file = new File(this.getProject().getBaseDir(), SUPPER_RUNNER_PROPERTIES);
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            Iterator iter = this.superRunnerProperties.iterator();
            while (iter.hasNext()) {
                String line = (String)iter.next();
                writer.println(line);
            }
            writer.close();
            this.log("SuperRunner.properties=" + file.getAbsolutePath(), 3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setMergeCoverage(boolean b) {
        this.mergeCoverage = b;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setResultsDir(File resultsDir) {
        this.resultsDir = resultsDir;
    }

    public static String[] runFromLaunchFile(String testLaunchFileName, File[] systemClassPath) throws IOException {
        TestRunProperties props = new TestRunProperties(new File(testLaunchFileName));
        Project project = new Project();
        LogListener logListener = new LogListener();
        project.addBuildListener((BuildListener)logListener);
        project.setName(props.getProjectName());
        project.setBasedir(props.getBaseDir());
        SuperRunnerTask task = new SuperRunnerTask();
        task.setFork(true);
        task.setForkMode(new ForkMode("once"));
        task.setProject(project);
        task.setHaltonerror(false);
        task.setHaltonfailure(false);
        task.setResultsDir(props.getCoverageResultsDir());
        task.setDir(new File(props.getBaseDir()));
        for (int i = 0; i < props.getJVMArgs().length; ++i) {
            String vmArg = props.getJVMArgs()[i];
            task.createJvmarg().setValue(vmArg);
        }
        SummaryAttribute sa = new SummaryAttribute();
        sa.setValue("yes");
        task.setPrintsummary(sa);
        FormatterElement formatterElement = new FormatterElement();
        FormatterElement.TypeAttribute xmlType = new FormatterElement.TypeAttribute();
        xmlType.setValue("xml");
        formatterElement.setType(xmlType);
        task.addFormatter(formatterElement);
        File[] classPathElements = IOUtility.toFiles((String[])StringUtility.split((String)props.getUserClassPath(), (char)File.pathSeparatorChar), (boolean)true);
        Path antClassPath = task.createClasspath();
        for (int i = 0; i < classPathElements.length; ++i) {
            Path.PathElement pathElement = antClassPath.createPathElement();
            pathElement.setLocation(classPathElements[i]);
        }
        String[] tests = props.getTests();
        task.setBatchSize(tests.length);
        BatchTest batch = task.createBatchTest();
        File xmlResultsDir = new File(props.getJunitXMLResultsDir());
        xmlResultsDir.mkdirs();
        batch.setTodir(xmlResultsDir);
        FileSet[] testFileSets = SuperRunnerTask.findTestFiles(tests, new Paths(classPathElements));
        for (int i = 0; i < testFileSets.length; ++i) {
            batch.addFileSet(testFileSets[i]);
        }
        if (systemClassPath != null) {
            task.init(systemClassPath);
        } else {
            task.init();
        }
        task.setIgnoreHandWrittenTests(props.isIgnoreHandWrittens());
        task.execute();
        String[] antLogs = logListener.messages.toArray(new String[0]);
        for (int i = 0; i < antLogs.length; ++i) {
            System.out.println(antLogs[i]);
        }
        return antLogs;
    }

    private void setIgnoreHandWrittenTests(boolean b) {
        this.ignoreHandWrittenTests = b;
    }

    private static FileSet[] findTestFiles(String[] tests, Paths classPaths) {
        HashMap<File, ArrayList<String>> baseDirsToTests = new HashMap<File, ArrayList<String>>();
        for (int i = 0; i < tests.length; ++i) {
            ClassName testClassName = ClassName.get((String)tests[i]);
            File testClassLocation = classPaths.getClassPathElement(testClassName.getClassFileName(), false);
            if (testClassLocation == null) {
                System.err.println("The test class [" + tests[i] + "] was not found on user path");
                continue;
            }
            ArrayList<String> testsInFileSet = (ArrayList<String>)baseDirsToTests.get(testClassLocation);
            if (testsInFileSet == null) {
                testsInFileSet = new ArrayList<String>();
                baseDirsToTests.put(testClassLocation, testsInFileSet);
            }
            testsInFileSet.add(testClassName.getClassFileName());
        }
        ArrayList<FileSet> fileSetList = new ArrayList<FileSet>();
        Iterator iter = baseDirsToTests.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            FileSet fileSet = new FileSet();
            fileSet.setDir((File)entry.getKey());
            List testsInSet = (List)entry.getValue();
            Iterator iterator = testsInSet.iterator();
            while (iterator.hasNext()) {
                String classFileName = (String)iterator.next();
                PatternSet.NameEntry testInclude = fileSet.createInclude();
                testInclude.setName(classFileName);
            }
            fileSetList.add(fileSet);
        }
        return fileSetList.toArray(new FileSet[0]);
    }

    private static class LogListener
    implements BuildListener {
        public final ArrayList messages = new ArrayList();

        private LogListener() {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void buildStarted(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() <= 1) {
                this.messages.add(event.getMessage());
            }
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }

    public static final class ForkMode
    extends EnumeratedAttribute {
        public static final String ONCE = "once";
        public static final String PER_TEST = "perTest";
        public static final String PER_BATCH = "perBatch";

        public ForkMode() {
        }

        public ForkMode(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{ONCE, PER_TEST, PER_BATCH};
        }
    }

    private final class ForkedTestConfiguration {
        private boolean filterTrace;
        private boolean haltOnError;
        private boolean haltOnFailure;
        private String errorProperty;
        private String failureProperty;

        ForkedTestConfiguration(boolean filterTrace, boolean haltOnError, boolean haltOnFailure, String errorProperty, String failureProperty) {
            this.filterTrace = filterTrace;
            this.haltOnError = haltOnError;
            this.haltOnFailure = haltOnFailure;
            this.errorProperty = errorProperty;
            this.failureProperty = failureProperty;
        }

        ForkedTestConfiguration(JUnitTest test) {
            this(test.getFiltertrace(), test.getHaltonerror(), test.getHaltonfailure(), test.getErrorProperty(), test.getFailureProperty());
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != (class$com$agitar$junit$runner$SuperRunnerTask$ForkedTestConfiguration == null ? (class$com$agitar$junit$runner$SuperRunnerTask$ForkedTestConfiguration = SuperRunnerTask.class$("com.agitar.junit.runner.SuperRunnerTask$ForkedTestConfiguration")) : class$com$agitar$junit$runner$SuperRunnerTask$ForkedTestConfiguration)) {
                return false;
            }
            ForkedTestConfiguration o = (ForkedTestConfiguration)other;
            return this.filterTrace == o.filterTrace && this.haltOnError == o.haltOnError && this.haltOnFailure == o.haltOnFailure && (this.errorProperty == null && o.errorProperty == null || this.errorProperty != null && this.errorProperty.equals(o.errorProperty)) && (this.failureProperty == null && o.failureProperty == null || this.failureProperty != null && this.failureProperty.equals(o.failureProperty));
        }

        public int hashCode() {
            return (this.filterTrace ? 1 : 0) + (this.haltOnError ? 2 : 0) + (this.haltOnFailure ? 4 : 0);
        }
    }

    public static class SummaryAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"true", "yes", "false", "no", "on", "off", "withOutAndErr"};
        }

        public boolean asBoolean() {
            String value = this.getValue();
            return "true".equals(value) || "on".equals(value) || "yes".equals(value) || "withOutAndErr".equals(value);
        }
    }
}

