/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.junit.runner;

import com.agitar.junit.runner.ProgramArgsFile;
import java.util.ArrayList;
import junit.framework.TestCase;

public class ProgramArgsFileTest
extends TestCase {
    public void testReadAndWriteBatchVmArgs() throws Exception {
        ProgramArgsFile writer = new ProgramArgsFile("test_", "file");
        ArrayList<String> list = new ArrayList<String>();
        list.add("-testRunVmArgs");
        list.add("4");
        list.add("-Xmx512m");
        list.add("-ea");
        list.add("-Djava.awt.headless=true");
        list.add("-Ddebug");
        writer.write(list);
        ProgramArgsFile reader = new ProgramArgsFile(writer.getFile().getAbsolutePath());
        ArrayList args = reader.getTestRunVMArguments();
        ProgramArgsFileTest.assertEquals((int)4, (int)args.size());
        ProgramArgsFileTest.assertEquals((Object)"-Xmx512m", args.get(0));
        ProgramArgsFileTest.assertEquals((Object)"-ea", args.get(1));
        ProgramArgsFileTest.assertEquals((Object)"-Djava.awt.headless=true", args.get(2));
        ProgramArgsFileTest.assertEquals((Object)"-Ddebug", args.get(3));
        ProgramArgsFileTest.assertEquals((int)0, (int)reader.getProgramArguments().size());
    }

    public void testReadAndWriteProgramArguments() throws Exception {
        ProgramArgsFile writer = new ProgramArgsFile("test_file");
        ArrayList<String> list = new ArrayList<String>();
        list.add("-batchsize");
        list.add("400");
        list.add("-classnames");
        list.add("test.target.Hello,other.target");
        writer.write(list);
        ProgramArgsFile reader = new ProgramArgsFile("test_file");
        ArrayList args = reader.getProgramArguments();
        ProgramArgsFileTest.assertEquals((int)5, (int)args.size());
        ProgramArgsFileTest.assertEquals((Object)"-batchsize", args.get(0));
        ProgramArgsFileTest.assertEquals((Object)"400", args.get(1));
        ProgramArgsFileTest.assertEquals((Object)"-classnames", args.get(2));
        ProgramArgsFileTest.assertEquals((Object)"test.target.Hello", args.get(3));
        ProgramArgsFileTest.assertEquals((Object)"other.target", args.get(4));
        ProgramArgsFileTest.assertEquals((int)0, (int)reader.getTestRunVMArguments().size());
    }

    public void testReadAndWriteTestRunProgramAndVmArgs() throws Exception {
        ProgramArgsFile writer = new ProgramArgsFile("test_file");
        ArrayList<String> list = new ArrayList<String>();
        list.add("-batchsize");
        list.add("400");
        list.add("-testRunVmArgs");
        list.add("4");
        list.add("-Xmx512m");
        list.add("-ea");
        list.add("-Djava.awt.headless=true");
        list.add("-Ddebug");
        list.add("-classname");
        list.add("-test.target.Hello");
        writer.write(list);
        ProgramArgsFile reader = new ProgramArgsFile("test_file");
        ArrayList args = reader.getProgramArguments();
        ProgramArgsFileTest.assertEquals((int)4, (int)args.size());
        ProgramArgsFileTest.assertEquals((Object)"-batchsize", args.get(0));
        ProgramArgsFileTest.assertEquals((Object)"400", args.get(1));
        ProgramArgsFileTest.assertEquals((Object)"-classname", args.get(2));
        ProgramArgsFileTest.assertEquals((Object)"-test.target.Hello", args.get(3));
        args = reader.getTestRunVMArguments();
        ProgramArgsFileTest.assertEquals((Object)"-Xmx512m", args.get(0));
        ProgramArgsFileTest.assertEquals((Object)"-ea", args.get(1));
        ProgramArgsFileTest.assertEquals((Object)"-Djava.awt.headless=true", args.get(2));
        ProgramArgsFileTest.assertEquals((Object)"-Ddebug", args.get(3));
    }

    public void testCannotReadAfterDelete() throws Exception {
        ProgramArgsFile writer = new ProgramArgsFile("test_file");
        ArrayList<String> list = new ArrayList<String>();
        list.add("-arg");
        writer.write(list);
        try {
            writer.deleteFile();
            writer.getProgramArguments();
            ProgramArgsFileTest.fail((String)"should not read");
        }
        catch (Exception x) {
            ProgramArgsFileTest.assertEquals((String)"Invalid to read, make sure file is not already deleted.", (String)x.getMessage());
        }
    }
}

