/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.junit.runner;

import com.agitar.common.util.IOUtility;
import com.agitar.common.util.UTF8FileWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ProgramArgsFile {
    private File file;
    private boolean valid;
    private ArrayList testRunVMArgs = null;
    private ArrayList programArgs = null;
    private boolean parseClassNames;

    public ProgramArgsFile(String testFileNamePre, String testFileNamePost) throws IOException {
        this.file = File.createTempFile(testFileNamePre, testFileNamePost);
        this.valid = true;
    }

    public void setParseClassNames(boolean parseClassNames) {
        this.parseClassNames = parseClassNames;
    }

    public ProgramArgsFile(String fileName) throws IOException {
        this.file = new File(fileName);
        this.valid = true;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ArrayList progArgs) throws IOException {
        UTF8FileWriter writer = new UTF8FileWriter(this.file);
        try {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < progArgs.size(); ++i) {
                buff.append(progArgs.get(i));
                buff.append("\n");
            }
            writer.write(buff.toString());
            this.valid = true;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public ArrayList getTestRunVMArguments() throws IOException {
        if (this.testRunVMArgs == null) {
            this.read();
        }
        return this.testRunVMArgs;
    }

    private void read() throws IOException {
        if (!this.valid) {
            throw new IllegalArgumentException("Invalid to read, make sure file is not already deleted.");
        }
        if (this.file.exists()) {
            String arguments = IOUtility.readFileAsUTF8((File)this.file);
            String[] args = arguments.split("\n");
            this.testRunVMArgs = new ArrayList();
            this.programArgs = new ArrayList();
            int numOfVmArgs = 0;
            for (int i = 0; i < args.length; ++i) {
                if (numOfVmArgs > 0) {
                    this.testRunVMArgs.add(args[i]);
                    --numOfVmArgs;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-testRunVmArgs")) {
                    numOfVmArgs = Integer.parseInt(args[++i].trim());
                    continue;
                }
                if (this.parseClassNames && "-classnames".equals(args[i].trim().toLowerCase())) {
                    this.programArgs.add(args[i]);
                    String cnames = i == args.length - 1 ? "" : args[++i];
                    String[] split = cnames.split(",");
                    for (int j = 0; j < split.length; ++j) {
                        this.programArgs.add(split[j].trim());
                    }
                    continue;
                }
                this.programArgs.add(args[i]);
            }
        }
    }

    public ArrayList getProgramArguments() throws IOException {
        if (this.programArgs == null) {
            this.read();
        }
        return this.programArgs;
    }

    public void deleteFile() {
        this.file.delete();
        this.valid = false;
    }
}

