/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.junit.runner;

import com.agitar.lib.junit.AgitarTestCase;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class AgitarTestSuite
extends TestSuite {
    private static final String SUPER_RUN_TYPE = "super.run.type";
    private static final String PATTERN = "Throws";
    private boolean exception = "exception".equals(System.getProperty("super.run.type"));
    private boolean normal = "normal".equals(System.getProperty("super.run.type"));

    public AgitarTestSuite(Class c) {
        super(c);
    }

    public Enumeration tests() {
        Enumeration tests = super.tests();
        if (this.exception || this.normal) {
            Vector<Test> filtered = new Vector<Test>();
            while (tests.hasMoreElements()) {
                Test test = (Test)tests.nextElement();
                if ((!this.exception || !this.isExceptionTestCase(test)) && (!this.normal || !this.isNormalTestCase(test))) continue;
                filtered.add(test);
            }
            return filtered.elements();
        }
        return tests;
    }

    private boolean isExceptionTestCase(Test t) {
        if (t instanceof AgitarTestCase) {
            TestCase tc = (TestCase)t;
            String name = tc.getName();
            return name != null && name.indexOf(PATTERN) > 0;
        }
        return false;
    }

    private boolean isNormalTestCase(Test t) {
        if (t instanceof AgitarTestCase) {
            TestCase tc = (TestCase)t;
            String name = tc.getName();
            return name != null && name.indexOf(PATTERN) == -1;
        }
        return false;
    }
}

