/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.common.asm.AsmUtil;
import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.AsmMethodData;
import com.agitar.coverage.analysis.TrackedInstruction;
import com.agitar.instrument.BoundaryNotificationInstrumentation;
import com.agitar.instrument.UseMocksClassAdapter;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdConstants;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class UseMocksCodeAdapter
extends CodeAdapter
implements AsmMockingbirdConstants {
    private static final String ASSERTIONS_DISABLED_FIELD_NAME = "$assertionsDisabled";
    private static final String ASSERTION_ERROR_INTERNAL_NAME;
    private boolean isPreviousNew = false;
    public static final int COMP_INT = 0;
    public static final int COMP_LONG = 1;
    public static final int COMP_DOUBLE_G = 2;
    public static final int COMP_DOUBLE_L = 3;
    public static final int COMP_FLOAT_G = 4;
    public static final int COMP_FLOAT_L = 5;
    private String name;
    private String desc;
    private int maxLocalVars;
    private boolean isPreviousDUP_X1;
    private Stack newWithDups = new Stack();
    private int branchCounter = 0;
    private String classOwnerName;
    private int inCompType = 0;
    private boolean skipBoundaryNotification = false;
    private int firstLocVarIndex = -1;
    private int secondLocVarIndex = -1;
    private AsmMethodData methodData = null;
    private UseMocksClassAdapter outerInstance = null;
    private boolean doBoundary = true;
    private int currentInsn = -1;
    private Map insnUsageMap = null;
    private final boolean doBoundaryNotification;
    private final AsmUtil.MethodDescription invocationHandler;
    private static BoundaryNotificationInstrumentation boundaryInstrumenter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UseMocksCodeAdapter(CodeVisitor cv, String className, String name, String desc, Map methodLocalsMap, UseMocksClassAdapter outerInstance) {
        super(cv);
        AsmUtil.MethodDescription handler = outerInstance.getInvocationHandler();
        this.invocationHandler = handler == null ? MOCKINGBIRD_INVOKE : handler;
        this.doBoundaryNotification = handler == null;
        this.outerInstance = outerInstance;
        this.name = name;
        this.desc = desc;
        this.classOwnerName = className;
        this.maxLocalVars = methodLocalsMap.get(name + ":" + desc) == null ? 0 : (Integer)methodLocalsMap.get(name + ":" + desc);
        this.instrumentPreCode();
    }

    public static void setBoundaryNotificationInstrumenter(BoundaryNotificationInstrumentation instrumenter) {
        boundaryInstrumenter = instrumenter;
    }

    public AsmMethodData getMethodData() {
        if (this.methodData != null) {
            return this.methodData;
        }
        AsmClassData classData = null;
        if (this.outerInstance != null) {
            classData = this.outerInstance.getClassData();
        }
        if (classData != null) {
            this.methodData = classData.getMethodDataForMethodKey(AsmMethodData.getKey((String)classData.getName(), (String)this.name, (String)this.desc));
        }
        return this.methodData;
    }

    private boolean isInNew() {
        return !this.newWithDups.isEmpty();
    }

    private void instrumentPreCode() {
    }

    public void visitInsn(int opcode) {
        ++this.currentInsn;
        if (this.skipMethodCallOrNew(this.classOwnerName, null, this.name)) {
            super.visitInsn(opcode);
            return;
        }
        this.skipBoundaryNotification = false;
        switch (opcode) {
            case 89: {
                if (!this.isPreviousNew) {
                    super.visitInsn(opcode);
                    break;
                }
                this.newWithDups.set(this.newWithDups.size() - 1, Boolean.TRUE);
                break;
            }
            case 90: {
                if (!this.isPreviousNew) {
                    super.visitInsn(opcode);
                } else {
                    this.newWithDups.set(this.newWithDups.size() - 1, Boolean.TRUE);
                }
                this.isPreviousDUP_X1 = true;
                break;
            }
            case 91: {
                if (!this.isInNew()) {
                    super.visitInsn(opcode);
                    break;
                }
                super.visitInsn(89);
                this.newWithDups.set(this.newWithDups.size() - 1, Boolean.TRUE);
                break;
            }
            case 95: {
                if (this.isPreviousDUP_X1) break;
                super.visitInsn(opcode);
                break;
            }
            default: {
                this.doBoundary = this.hasConstantOperand();
                switch (opcode) {
                    case 148: {
                        this.inCompType = 1;
                        this.storeBoundaryArgs(Type.LONG_TYPE);
                        break;
                    }
                    case 149: {
                        this.inCompType = 5;
                        this.storeBoundaryArgs(Type.FLOAT_TYPE);
                        break;
                    }
                    case 150: {
                        this.inCompType = 4;
                        this.storeBoundaryArgs(Type.FLOAT_TYPE);
                        break;
                    }
                    case 151: {
                        this.inCompType = 3;
                        this.storeBoundaryArgs(Type.DOUBLE_TYPE);
                        break;
                    }
                    case 152: {
                        this.inCompType = 2;
                        this.storeBoundaryArgs(Type.DOUBLE_TYPE);
                    }
                }
                super.visitInsn(opcode);
            }
        }
        this.isPreviousNew = false;
        if (opcode != 90) {
            this.isPreviousDUP_X1 = false;
        }
    }

    private void storeBoundaryArgs(Type type) {
        if (this.doBoundary) {
            int storeOp = type.getOpcode(54);
            this.firstLocVarIndex = this.getNextAvailableVariable(type);
            super.visitVarInsn(storeOp, this.firstLocVarIndex);
            this.secondLocVarIndex = this.getNextAvailableVariable(type);
            super.visitVarInsn(storeOp, this.secondLocVarIndex);
            int loadOp = type.getOpcode(21);
            super.visitVarInsn(loadOp, this.secondLocVarIndex);
            super.visitVarInsn(loadOp, this.firstLocVarIndex);
        }
    }

    private boolean hasConstantOperand() {
        List operands = this.getInsnOperands();
        Iterator iter = operands.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode opNode;
            int opcode;
            Object operand = iter.next();
            if (!(operand instanceof AbstractInsnNode) || (opcode = (opNode = (AbstractInsnNode)operand).getOpcode()) < 2 || opcode > 18) continue;
            return true;
        }
        return false;
    }

    private List getInsnOperands() {
        AbstractInsnNode currentNode;
        TrackedInstruction ti;
        List insns;
        AsmMethodData methodData = this.getMethodData();
        if (methodData != null && this.currentInsn < (insns = methodData.getInstructionsList()).size() && insns.get(this.currentInsn) instanceof AbstractInsnNode && (ti = TrackedInstruction.get((AsmMethodData)methodData, (AbstractInsnNode)(currentNode = (AbstractInsnNode)insns.get(this.currentInsn)), (int)this.currentInsn)) != null) {
            return ti.getOperatesOn();
        }
        return Collections.EMPTY_LIST;
    }

    public void visitIntInsn(int opcode, int operand) {
        this.countAndReset();
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.countAndReset();
        super.visitVarInsn(opcode, var);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.countAndReset();
        this.skipBoundaryNotification = name.equals(ASSERTIONS_DISABLED_FIELD_NAME);
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        ++this.currentInsn;
        this.isPreviousNew = false;
        this.isPreviousDUP_X1 = false;
        if (boundaryInstrumenter != null && this.doBoundaryNotification) {
            switch (opcode) {
                case 161: {
                    this.instrumentIcmpBoundary(2);
                    break;
                }
                case 162: {
                    this.instrumentIcmpBoundary(5);
                    break;
                }
                case 163: {
                    this.instrumentIcmpBoundary(4);
                    break;
                }
                case 164: {
                    this.instrumentIcmpBoundary(3);
                    break;
                }
                case 159: {
                    this.instrumentIcmpBoundary(0);
                    break;
                }
                case 160: {
                    this.instrumentIcmpBoundary(1);
                    break;
                }
                case 155: {
                    this.instrumentBoundary(2);
                    break;
                }
                case 156: {
                    this.instrumentBoundary(5);
                    break;
                }
                case 157: {
                    this.instrumentBoundary(4);
                    break;
                }
                case 158: {
                    this.instrumentBoundary(3);
                    break;
                }
                case 153: {
                    if (this.inCompType == 0 && !this.instrumentIFEQNE()) break;
                    this.instrumentBoundary(0);
                    break;
                }
                case 154: {
                    if (this.inCompType == 0 && (this.skipBoundaryNotification || !this.instrumentIFEQNE())) break;
                    this.instrumentBoundary(1);
                }
            }
        }
        this.doBoundary = true;
        this.inCompType = 0;
        this.skipBoundaryNotification = false;
        super.visitJumpInsn(opcode, label);
    }

    private void instrumentBoundary(int methodName) {
        switch (this.inCompType) {
            case 0: {
                this.instrumentBoundary(methodName, 0);
                break;
            }
            case 1: {
                if (!this.doBoundary) break;
                this.instrumentBoundary(methodName, 22);
                break;
            }
            case 4: 
            case 5: {
                if (!this.doBoundary) break;
                this.instrumentBoundary(methodName, 23);
                break;
            }
            case 2: 
            case 3: {
                if (!this.doBoundary) break;
                this.instrumentBoundary(methodName, 24);
            }
        }
    }

    private void instrumentBoundary(int methodName, int loadInsn) {
        int paramType;
        switch (loadInsn) {
            case 22: {
                paramType = 0;
                this.cv.visitVarInsn(loadInsn, this.secondLocVarIndex);
                this.cv.visitVarInsn(loadInsn, this.firstLocVarIndex);
                break;
            }
            case 23: {
                paramType = 1;
                this.cv.visitVarInsn(loadInsn, this.secondLocVarIndex);
                this.cv.visitVarInsn(loadInsn, this.firstLocVarIndex);
                break;
            }
            case 24: {
                paramType = 2;
                this.cv.visitVarInsn(loadInsn, this.secondLocVarIndex);
                this.cv.visitVarInsn(loadInsn, this.firstLocVarIndex);
                break;
            }
            default: {
                paramType = 3;
                this.cv.visitInsn(89);
                this.cv.visitInsn(3);
            }
        }
        this.cv.visitLdcInsn((Object)this.classOwnerName);
        this.cv.visitLdcInsn((Object)this.name);
        this.cv.visitLdcInsn((Object)this.desc);
        AsmUtil.visitShortestInt((CodeVisitor)this.cv, (int)this.branchCounter++);
        boundaryInstrumenter.visitMethod(this.cv, paramType, methodName);
    }

    private void instrumentIcmpBoundary(int methodName) {
        if (this.hasConstantOperand()) {
            this.cv.visitInsn(92);
            this.cv.visitLdcInsn((Object)this.classOwnerName);
            this.cv.visitLdcInsn((Object)this.name);
            this.cv.visitLdcInsn((Object)this.desc);
            AsmUtil.visitShortestInt((CodeVisitor)this.cv, (int)this.branchCounter++);
            boundaryInstrumenter.visitMethod(this.cv, 3, methodName);
        }
    }

    private boolean instrumentIFEQNE() {
        List operands = this.getInsnOperands();
        if (operands.size() != 1) {
            return false;
        }
        Iterator iter = operands.iterator();
        while (iter.hasNext()) {
            Object operand = iter.next();
            if (!(operand instanceof MethodInsnNode) || Type.getReturnType((String)((MethodInsnNode)operand).desc) != Type.BOOLEAN_TYPE) continue;
            return false;
        }
        return true;
    }

    public void visitLabel(Label label) {
        ++this.currentInsn;
        super.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.countAndReset();
        super.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.countAndReset();
        super.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.countAndReset();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.countAndReset();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.countAndReset();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.countAndReset();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.countAndReset();
        super.visitMaxs(maxStack, maxLocals);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.countAndReset();
        super.visitLocalVariable(name, desc, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.countAndReset();
        super.visitLineNumber(line, start);
    }

    public void visitAttribute(Attribute attr) {
        this.countAndReset();
        super.visitAttribute(attr);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.countAndReset();
        if (opcode == 187) {
            this.incInNewCounter();
            if (!this.skipMethodCallOrNew(desc, null, this.name)) {
                this.isPreviousNew = true;
                return;
            }
        }
        super.visitTypeInsn(opcode, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        AsmMethodData methodData;
        this.countAndReset();
        Type returnType = Type.getReturnType((String)desc);
        if (!this.outerInstance.isAccessible(returnType) && (methodData = this.getMethodData()) != null && methodData.getInstructionsList() != null) {
            List isOperandOf;
            List insnList = methodData.getInstructionsList();
            this.buildInsnUsageMap(insnList, methodData);
            Object thisInsnObj = insnList.get(this.currentInsn);
            if (thisInsnObj instanceof AbstractInsnNode && (isOperandOf = (List)this.insnUsageMap.get(thisInsnObj)) != null && !isOperandOf.isEmpty() && isOperandOf.get(0) instanceof AbstractInsnNode) {
                AbstractInsnNode operator = (AbstractInsnNode)isOperandOf.get(0);
                int operatorOpcode = operator.getOpcode();
                switch (operatorOpcode) {
                    case 179: 
                    case 181: {
                        returnType = Type.getType((String)((FieldInsnNode)operator).desc);
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        returnType = this.findReturnType(methodData, operator, thisInsnObj, returnType);
                    }
                }
            }
        }
        if (this.skipMethodCallOrNew(owner, name, this.name)) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if ("<init>".equals(name)) {
                this.decInNewCounter();
            }
        } else {
            this.instrumentInvoke(opcode, owner, name, desc, returnType);
        }
    }

    private Type findReturnType(AsmMethodData methodData, AbstractInsnNode operator, Object thisInsnObj, Type returnType) {
        TrackedInstruction operatorInstruction = TrackedInstruction.get((AsmMethodData)methodData, (AbstractInsnNode)operator, (int)methodData.getInstructionIndex(operator));
        if (operatorInstruction != null) {
            List operands = operatorInstruction.getOperatesOn();
            for (int i = 0; i < operands.size(); ++i) {
                Type[] argumentTypes;
                if (operands.get(i) != thisInsnObj) continue;
                int typeIndex = i;
                if (operator.getOpcode() != 184) {
                    --typeIndex;
                }
                if ((argumentTypes = Type.getArgumentTypes((String)((MethodInsnNode)operator).desc)).length <= typeIndex || typeIndex < 0) break;
                return argumentTypes[typeIndex];
            }
        }
        return returnType;
    }

    private void instrumentInvoke(int opcode, String owner, String name, String desc, Type returnType) {
        switch (opcode) {
            case 182: 
            case 185: {
                this.instrumentInvokeImpl(owner, name, desc, returnType, false, false);
                break;
            }
            case 184: {
                this.instrumentInvokeImpl(owner, name, desc, returnType, true, false);
                break;
            }
            case 183: {
                if (this.isConstructorCall(name)) {
                    this.instrumentInvokeImpl(owner, name, desc, returnType, false, true);
                    if (this.newWithDups.peek() == Boolean.FALSE) {
                        super.visitInsn(87);
                    }
                    this.decInNewCounter();
                    break;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
                break;
            }
            default: {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }
    }

    private void instrumentInvokeImpl(String owner, String name, String desc, Type returnType, boolean isStatic, boolean isConstructor) {
        boolean noThis = isStatic || isConstructor;
        List newVarsList = this.storeArguments(desc, noThis);
        super.visitLdcInsn((Object)owner);
        super.visitLdcInsn((Object)name);
        super.visitLdcInsn((Object)desc);
        AsmUtil.visitShortestInt((CodeVisitor)this.cv, (int)(noThis ? 1 : 0));
        this.loadArgumentsAsArray(noThis, newVarsList);
        AsmMockingbirdUtility.visitClassLoaderField((String)this.classOwnerName, (CodeVisitor)this.cv);
        this.invocationHandler.visitMethod(this.cv);
        if (isConstructor) {
            super.visitTypeInsn(192, owner);
        } else {
            AsmUtil.unbox((CodeVisitor)this.cv, (Type)returnType);
        }
    }

    private void loadArgumentsAsArray(boolean noThis, List newVarsList) {
        if (!noThis) {
            if (!$assertionsDisabled && newVarsList.size() < 1) {
                throw new AssertionError((Object)"This object should be stored @ index size() - 1 of the newVarsList!");
            }
            super.visitVarInsn(25, ((NewVar)newVarsList.get((int)(newVarsList.size() - 1))).newIndex);
        } else {
            super.visitInsn(1);
        }
        int paramsAdded = newVarsList.size() - (noThis ? 0 : 1);
        AsmUtil.visitShortestInt((CodeVisitor)this.cv, (int)paramsAdded);
        super.visitTypeInsn(189, "java/lang/Object");
        int addedElement = 0;
        int j = newVarsList.size() - 1;
        while (addedElement < paramsAdded) {
            super.visitInsn(89);
            AsmUtil.visitShortestInt((CodeVisitor)this.cv, (int)addedElement);
            NewVar nv = (NewVar)newVarsList.get(j - (noThis ? 0 : 1));
            AsmUtil.box((CodeVisitor)this.cv, (Type)nv.type, (int)nv.newIndex);
            super.visitInsn(83);
            ++addedElement;
            --j;
        }
    }

    private List storeArguments(String desc, boolean noThis) {
        ArrayList<NewVar> newVarsList = new ArrayList<NewVar>();
        Type[] paramTypes = Type.getArgumentTypes((String)desc);
        for (int i = paramTypes.length - 1; i >= 0; --i) {
            Type type = paramTypes[i];
            newVarsList.add(this.storeVariable(type));
        }
        if (!noThis) {
            newVarsList.add(this.storeVariable(AsmUtil.JAVA_LANG_OBJECT_TYPE));
        }
        return newVarsList;
    }

    private void countAndReset() {
        ++this.currentInsn;
        this.inCompType = 0;
        this.skipBoundaryNotification = false;
        this.isPreviousNew = false;
        this.isPreviousDUP_X1 = false;
    }

    private void buildInsnUsageMap(List insnList, AsmMethodData tbeMData) {
        if (this.insnUsageMap == null) {
            this.insnUsageMap = new HashMap();
            for (int i = 0; i < insnList.size(); ++i) {
                Object insn = insnList.get(i);
                if (!(insn instanceof AbstractInsnNode)) continue;
                this.mapInstruction(tbeMData, (AbstractInsnNode)insn, i);
            }
        }
    }

    private void mapInstruction(AsmMethodData methodData, AbstractInsnNode insn, int i) {
        int tiOpcode;
        TrackedInstruction ti = TrackedInstruction.get((AsmMethodData)methodData, (AbstractInsnNode)insn, (int)i);
        AbstractInsnNode iNode = ti.getInstruction();
        int n = tiOpcode = iNode == null ? 0 : iNode.getOpcode();
        if (UseMocksCodeAdapter.isInvoke(tiOpcode)) {
            if (!this.insnUsageMap.containsKey(iNode)) {
                this.insnUsageMap.put(iNode, new ArrayList());
            }
            List operands = ti.getOperatesOn();
            for (int j = 0; j < operands.size(); ++j) {
                Object operand = operands.get(j);
                if (!(operand instanceof AbstractInsnNode)) continue;
                AbstractInsnNode ain = (AbstractInsnNode)operand;
                int ainOpcode = ain.getOpcode();
                if (!this.insnUsageMap.containsKey(ain) || !UseMocksCodeAdapter.isInvoke(ainOpcode) && ainOpcode != 181 && ainOpcode != 179) continue;
                List usagesList = (List)this.insnUsageMap.get(ain);
                usagesList.add(iNode);
            }
        }
    }

    private static boolean isInvoke(int op) {
        return op == 185 || op == 183 || op == 184 || op == 182;
    }

    private void decInNewCounter() {
        if (!this.newWithDups.isEmpty()) {
            this.newWithDups.pop();
        }
    }

    private void incInNewCounter() {
        this.newWithDups.push(Boolean.FALSE);
    }

    private boolean isConstructorCall(String name) {
        return name.equals("<init>") && this.isInNew();
    }

    private int getNextAvailableVariable(Type type) {
        int ret = this.maxLocalVars;
        this.maxLocalVars += type.getSize();
        return ret;
    }

    private NewVar storeVariable(Type type) {
        int nav = this.getNextAvailableVariable(type);
        NewVar nv = new NewVar(nav, type);
        super.visitVarInsn(nv.type.getOpcode(54), nv.newIndex);
        return nv;
    }

    private boolean skipMethodCallOrNew(String owner, String name, String methodName) {
        return !AsmUtil.canMock((String)owner, (String)name, (String)methodName);
    }

    static {
        $assertionsDisabled = !UseMocksCodeAdapter.class.desiredAssertionStatus();
        ASSERTION_ERROR_INTERNAL_NAME = Type.getType((Class)AssertionError.class).getInternalName();
    }

    private static class NewVar {
        int newIndex;
        Type type;

        NewVar(int newIndex, Type type) {
            this.newIndex = newIndex;
            this.type = type;
        }
    }
}

