/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.common.asm.AsmUtil;
import com.agitar.common.types.ClassName;
import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.coverage.analysis.AsmClassData;
import com.agitar.coverage.analysis.AsmInstrumenterHelperBase;
import com.agitar.coverage.analysis.AsmMethodData;
import com.agitar.instrument.UseMocksCodeAdapter;
import com.agitar.lib.NoObfuscation;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class UseMocksClassAdapter
extends ClassAdapter
implements NoObfuscation {
    private final Map methodKeyToLocalCount = new HashMap();
    private final Map classNameToAccess = new HashMap();
    private AsmClassData classData;
    private final String classNameDot;
    private String classNameSlash;
    private final AsmClassCache classCache;
    private byte[] bytes;
    private boolean triedTbeClassData;
    private boolean isInterface = false;
    private final AsmUtil.MethodDescription invocationHandler;

    public UseMocksClassAdapter(String className, byte[] bytes, ClassVisitor cv, AsmClassCache classCache) {
        this(className, bytes, cv, classCache, null);
    }

    public UseMocksClassAdapter(String className, byte[] bytes, ClassVisitor cv, AsmClassCache classCache, AsmUtil.MethodDescription invocationHandler) {
        super(cv);
        this.invocationHandler = invocationHandler;
        this.classNameDot = className;
        this.bytes = bytes;
        this.classCache = classCache;
        try {
            new ClassReader(bytes).accept((ClassVisitor)new CountLocalsClassAdapter(), AsmUtil.getDefaultAttributes(), false);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public AsmClassData getClassData() {
        if (this.classCache == null) {
            this.triedTbeClassData = true;
            return null;
        }
        if (this.classData != null) {
            return this.classData;
        }
        if (this.classCache != null) {
            this.classData = this.classCache.getClassDataForClassKey(AsmClassData.getKey((String)this.classNameSlash));
        }
        if (!this.triedTbeClassData) {
            this.triedTbeClassData = true;
            this.classCache.parseClass(this.bytes);
            this.classData = this.classCache.getClassDataForClassKey(AsmClassData.getKey((String)this.classNameSlash));
        }
        return this.classData;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.classNameSlash = name;
        this.isInterface = Modifier.isInterface(access);
        super.visit(version, access, name, superName, interfaces, sourceFile);
    }

    public CodeVisitor visitMethod(int flags, String name, String desc, String[] params, Attribute attrs) {
        int size;
        AsmMethodData methodData;
        CodeVisitor superCV = super.visitMethod(flags, name, desc, params, attrs);
        if (this.isInterface || UseMocksClassAdapter.skipMethod(this.classNameDot, name)) {
            return superCV;
        }
        AsmClassData classData = this.getClassData();
        if (classData != null && (methodData = classData.getMethodDataForMethodKey(AsmMethodData.getKey((String)classData.getName(), (String)name, (String)desc))) != null && (size = methodData.getCodeSize()) > 18000) {
            return superCV;
        }
        UseMocksCodeAdapter useMocksCodeAdapter = new UseMocksCodeAdapter(superCV, this.classNameSlash, name, desc, this.methodKeyToLocalCount, this);
        return useMocksCodeAdapter;
    }

    private static boolean skipMethod(String ownerClassName, String name) {
        return name.startsWith("$agitar") || ownerClassName != null && ownerClassName.startsWith("com.agitar.");
    }

    public static boolean isPrimitiveOrWrapper(Type type) {
        String className = type.getClassName();
        return type.getSort() != 10 && type.getSort() != 9 || className.equals("java.lang.String") || ClassName.BOXED_PRIMITIVE_STRINGS.contains(className);
    }

    public boolean isAccessible(Type returnType) {
        int classAccess;
        if (UseMocksClassAdapter.isPrimitiveOrWrapper(returnType) || returnType.getSort() == 9) {
            return true;
        }
        String className = returnType.getClassName();
        if (this.classNameToAccess.containsKey(className)) {
            classAccess = (Integer)this.classNameToAccess.get(className);
        } else if (className.startsWith("java.")) {
            classAccess = 1;
            this.classNameToAccess.put(className, new Integer(classAccess));
        } else {
            byte[] bytes = AsmInstrumenterHelperBase.getBytesForClass((String)className, (boolean)false);
            classAccess = bytes == null ? 2 : new AccessAndNameVisitor().getAccess(bytes);
            this.classNameToAccess.put(className, new Integer(classAccess));
        }
        if (Modifier.isPublic(classAccess)) {
            return true;
        }
        if (Modifier.isPrivate(classAccess)) {
            return false;
        }
        String packageName = ClassName.get((String)className).getPackageName();
        String ownerPackageName = ClassName.get((String)this.classNameDot).getPackageName();
        return packageName.equals(ownerPackageName);
    }

    public AsmUtil.MethodDescription getInvocationHandler() {
        return this.invocationHandler;
    }

    private class CountLocalsClassAdapter
    extends ClassAdapter {
        public CountLocalsClassAdapter() {
            super((ClassVisitor)new ClassWriter(true, true));
        }

        public CodeVisitor visitMethod(int flags, String name, String desc, String[] params, Attribute attrs) {
            CodeVisitor superCV = super.visitMethod(flags, name, desc, params, attrs);
            if (UseMocksClassAdapter.skipMethod(UseMocksClassAdapter.this.classNameDot, name)) {
                return superCV;
            }
            return new CountLocalsCodeAdapter(superCV, name + ":" + desc);
        }
    }

    private class CountLocalsCodeAdapter
    extends CodeAdapter {
        private String key;

        public CountLocalsCodeAdapter(CodeVisitor cv, String key) {
            super(cv);
            this.key = key;
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            UseMocksClassAdapter.this.methodKeyToLocalCount.put(this.key, new Integer(maxLocals));
            super.visitMaxs(maxStack, maxLocals);
        }
    }

    private static class AccessAndNameVisitor
    implements ClassVisitor {
        private int access;

        private AccessAndNameVisitor() {
        }

        int getAccess(byte[] bytes) {
            ClassReader cr = new ClassReader(bytes);
            cr.accept((ClassVisitor)this, AsmUtil.getDefaultAttributes(), false);
            return this.access;
        }

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            this.access = access;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }
    }
}

