/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.instrument.Instrumenter;
import com.agitar.mockingbird.instrumenter.MockingbirdInstrumenter;
import java.io.File;
import java.util.Set;

public class MockInstrumenter
implements Instrumenter {
    private Set testClasses;
    private Set targetClasses;

    public MockInstrumenter(Set testClasses, Set targetClasses) {
        this.testClasses = testClasses;
        this.targetClasses = targetClasses;
    }

    public byte[] instrument(String className, byte[] classBytes, ClassLoader callingLoader, File sourceFile, AsmClassCache classCache) {
        if (classCache != null && classCache.getClassDataForClassKey(className) == null) {
            classCache.parseClass(classBytes);
        }
        return MockingbirdInstrumenter.instrument((byte[])classBytes, (Set)this.targetClasses);
    }

    public boolean isInstrumentable(String className, File sourceFile) {
        boolean test = this.testClasses != null && this.testClasses.contains(className);
        boolean mockingbird = className.startsWith("com.agitar.lib.mockingbird") || className.startsWith("com.agitar.lib.junit");
        return !test && !mockingbird;
    }
}

