/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.common.asm.BytecodeSizeChecker;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.StringUtility;
import com.agitar.common.util.TimeoutController;
import com.agitar.coverage.CoverageManager;
import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.instrument.CoverageInstrumenter;
import com.agitar.instrument.Instrumenter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InstrumentationManager {
    private static final List instrumenters;
    private static long timer;
    private static Class[] ORDER_OF_INSTRUMENTER;
    private static String[] orderTxt;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$agitar$instrument$Instrumenter;

    public static void resetTimer() {
        timer = 0L;
    }

    public static long getTimer() {
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getInstrumentedBytes(String className, byte[] classBytes, ClassLoader callingLoader, File sourceFile, AsmClassCache classCache) {
        byte[] byArray;
        long start = System.currentTimeMillis();
        if (!InstrumentationManager.isInstrumentable(className)) {
            return classBytes;
        }
        int timeoutMarker = 0;
        try {
            timeoutMarker = TimeoutController.stopTime((String)"code instrumentation");
            byte[] originalBytes = classBytes;
            byte[] bytesWithCoverage = classBytes;
            BytecodeSizeChecker.clear();
            Iterator i = instrumenters.iterator();
            while (i.hasNext()) {
                Instrumenter instr = (Instrumenter)i.next();
                if (!instr.isInstrumentable(className, sourceFile)) continue;
                try {
                    classBytes = instr.instrument(className, classBytes, callingLoader, sourceFile, classCache);
                    if (!(instr instanceof CoverageInstrumenter)) continue;
                    bytesWithCoverage = classBytes;
                    BytecodeSizeChecker.CodeSizeException exception = BytecodeSizeChecker.getException((String)className);
                    if (exception == null) continue;
                    AgitarLogger.getDiagnosticLogger((String)"instrumentation").warning("Exception encountered while instrumenting " + className + StringUtility.nl + StringUtility.trace((Throwable)exception));
                }
                catch (Exception ex) {
                    if (instr instanceof CoverageInstrumenter) {
                        classBytes = originalBytes;
                        AgitarLogger.getUserLogger((String)"instrumentation").warning("Coverage instrumentation disabled for class \"" + className + "\" (code size too big)");
                    } else {
                        classBytes = bytesWithCoverage;
                    }
                    AgitarLogger.getDiagnosticLogger((String)"instrumentation").warning("Exception encountered while instrumenting " + className + StringUtility.nl + StringUtility.trace((Throwable)ex));
                }
                break;
            }
            CoverageManager.writeClassFille((String)className, (byte[])classBytes);
            byArray = classBytes;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            TimeoutController.resumeTime((int)timeoutMarker);
            timer += System.currentTimeMillis() - start;
            throw throwable;
        }
        TimeoutController.resumeTime((int)timeoutMarker);
        timer += System.currentTimeMillis() - start;
        return byArray;
    }

    public static void registerInstrumenter(Instrumenter instrumenter) {
        if (!AgitarProperties.DISABLE_INSTRUMENTATER_CHECK) {
            InstrumentationManager.checkOrderOfInstrumenters(instrumenter);
        }
        instrumenters.add(instrumenter);
    }

    private static void checkOrderOfInstrumenters(Instrumenter instrumenter) {
        for (int i = 0; i < ORDER_OF_INSTRUMENTER.length; ++i) {
            InstrumentationManager.checkTypeOfInstrumenter(ORDER_OF_INSTRUMENTER[i], i);
        }
    }

    public static void setOrderOfInstrumenters(Class[] order) {
        if (!($assertionsDisabled || order != null && order.length > 0)) {
            throw new AssertionError();
        }
        for (int i = 0; i < order.length; ++i) {
            if (!$assertionsDisabled && !(class$com$agitar$instrument$Instrumenter == null ? InstrumentationManager.class$("com.agitar.instrument.Instrumenter") : class$com$agitar$instrument$Instrumenter).isAssignableFrom(order[i])) {
                throw new AssertionError();
            }
        }
        ORDER_OF_INSTRUMENTER = order;
    }

    private static void checkTypeOfInstrumenter(Class expected, int order) {
        if (instrumenters.size() > order) {
            String expectedName = expected.getName();
            Object actual = instrumenters.get(order);
            if (!expected.isInstance(actual)) {
                throw new RuntimeException(expectedName + " must be the " + orderTxt[order] + " instrumenter. Actual: " + actual.getClass().getName());
            }
        }
    }

    public static void deregisterAllInstrumenters() {
        instrumenters.clear();
    }

    private static boolean isInstrumentable(String className) {
        return !className.startsWith("com.agitar.") && !className.startsWith("user.agitar.invocation.") && className.indexOf("$Agitator_autoMock_class$") < 0;
    }

    static {
        $assertionsDisabled = !InstrumentationManager.class.desiredAssertionStatus();
        instrumenters = new ArrayList();
        timer = 0L;
        ORDER_OF_INSTRUMENTER = new Class[0];
        orderTxt = new String[]{"first", "second", "third"};
    }
}

