/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.Checksum;
import com.agitar.common.util.ClassCacheMap;
import com.agitar.coverage.ClassCoverage;
import com.agitar.coverage.ClassInfoCollector;
import com.agitar.coverage.CoverageInstrumenterChain;
import com.agitar.coverage.CoverageManager;
import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.instrument.Instrumenter;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.asm.ClassWriter;

public class CoverageInstrumenter
implements Instrumenter {
    private final Set testClasses;
    private final Set targetClasses;
    private final boolean instrumentAllClasses;
    private final boolean instrumentInJars;
    private static final Map instrumented = new ClassCacheMap();
    private ClassInfoCollector infoCollector;

    public CoverageInstrumenter(Set testClasses, Set targetClasses) {
        this(testClasses, targetClasses, false);
    }

    public CoverageInstrumenter(Set testClasses, Set targetClasses, boolean instrumentInJars) {
        this.testClasses = testClasses == null ? new HashSet() : testClasses;
        this.targetClasses = targetClasses == null ? new HashSet() : targetClasses;
        this.instrumentAllClasses = testClasses == null || targetClasses == null || System.getProperty("old_fashioned_coverage") == null;
        this.instrumentInJars = instrumentInJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] instrument(String className, byte[] classBytes, ClassLoader callingLoader, File sourceFile, AsmClassCache classCache) {
        ClassCoverage classCoverage = new ClassCoverage(className, CoverageManager.getCoverageDir());
        classCoverage.setOriginalChecksum(new Checksum().get(classBytes));
        classCache.parseClass(classBytes);
        CoverageInstrumenterChain chain = CoverageInstrumenterChain.getInstance((AsmClassCache)classCache, (ClassCoverage)classCoverage, (Logger)AgitarLogger.getUserLogger((String)"coverage"));
        this.infoCollector = chain.getClassInfoCollector();
        ClassWriter cw = chain.instrument(classBytes);
        if (!this.infoCollector.isConcreteMock()) {
            CoverageInstrumenter coverageInstrumenter = this;
            synchronized (coverageInstrumenter) {
                this.mergePreviousCoverage(classCoverage);
                try {
                    classCoverage.write();
                }
                catch (Exception ex) {
                    AgitarLogger.getDiagnosticLogger((String)"CoverageInstrumenter").warning("Could not save coverage file for: " + className);
                    return classBytes;
                }
            }
            instrumented.put(className, className);
            byte[] bytes = cw.toByteArray();
            return bytes;
        }
        return classBytes;
    }

    public ClassInfoCollector getInfoCollector() {
        return this.infoCollector;
    }

    private void mergePreviousCoverage(ClassCoverage classCoverage) {
        File coverageFile = classCoverage.locateCoverageFile();
        if (coverageFile.exists() && coverageFile.lastModified() >= CoverageManager.getLastModified()) {
            ClassCoverage previousCoverage = new ClassCoverage(classCoverage.getClassName(), classCoverage.getCoverageDir());
            try {
                previousCoverage.read();
                classCoverage.merge(previousCoverage);
            }
            catch (IllegalArgumentException x) {
                AgitarLogger.getDiagnosticLogger((String)"CoverageInstrumenter").log(AgitarLevel.WARNING, "mismatch in coverage for " + classCoverage.getClassName() + " ");
            }
            catch (IOException e) {
                AgitarLogger.getDiagnosticLogger((String)"CoverageInstrumenter").log(AgitarLevel.WARNING, "IOException in coverage for " + classCoverage.getClassName(), e);
            }
        }
    }

    public static void reset() {
        instrumented.clear();
    }

    public boolean isInstrumentable(String className, File sourceFile) {
        boolean selected;
        if (this.instrumentAllClasses) {
            selected = true;
        } else {
            boolean bl = selected = this.testClasses.contains(className) || this.targetClasses.contains(className);
            if (className.indexOf(36) > 0) {
                Iterator i = this.targetClasses.iterator();
                while (!selected && i.hasNext()) {
                    String targetClass = (String)i.next();
                    if (!className.startsWith(targetClass + "$")) continue;
                    selected = true;
                }
            }
        }
        boolean agitar = className.startsWith("com.agitar.") && className.indexOf("Test$") < 0;
        boolean isInstrumented = instrumented.containsKey(className);
        boolean library = sourceFile != null && !sourceFile.getName().toLowerCase().endsWith(".class");
        return selected && !agitar && !isInstrumented && (!library || this.instrumentInJars);
    }
}

