/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.instrument.ClassLoaderFieldAndInterceptor;
import com.agitar.instrument.Instrumenter;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdUtility;
import java.io.File;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassLoaderFieldInstrumenter
implements Instrumenter {
    private final boolean withInterceptor;
    private Set targetClasses;

    public ClassLoaderFieldInstrumenter(boolean withInterceptor, Set targetClasses) {
        this.withInterceptor = withInterceptor;
        this.targetClasses = targetClasses;
    }

    public byte[] instrument(String className, byte[] classBytes, ClassLoader callingLoader, File sourceFile, AsmClassCache classCache) {
        ClassWriter cw = new ClassWriter(true, true);
        ClassNode classNode = AsmMockingbirdUtility.getClassNode((ClassReader)new ClassReader(classBytes));
        ClassLoaderFieldAndInterceptor classLoaderField = new ClassLoaderFieldAndInterceptor(this.withInterceptor, this.targetClasses);
        classNode.accept((ClassVisitor)classLoaderField);
        classLoaderField.classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public boolean isInstrumentable(String className, File sourceFile) {
        boolean agitar = className.startsWith("com.agitar.") && className.indexOf("Test$") < 0;
        return !agitar;
    }
}

