/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.common.asm.AsmUtil;
import com.agitar.mockingbird.instrumenter.AsmMockingbirdUtility;
import com.agitar.mockingbird.instrumenter.LocalVariables;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TreeClassAdapter;
import org.objectweb.asm.tree.TreeCodeAdapter;

public class ClassLoaderFieldAndInterceptor
extends TreeClassAdapter {
    private boolean agitarClassLoaderFieldExists;
    private boolean hasClinit = false;
    private boolean withInterceptor;
    private Set targetClasses;
    private boolean isCUT;
    static /* synthetic */ Class class$com$agitar$common$asm$ClassLoaderResources;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Enumeration;

    public ClassLoaderFieldAndInterceptor(boolean withInterceptor, Set targetClasses) {
        super(null);
        this.withInterceptor = withInterceptor;
        this.targetClasses = targetClasses;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        super.visit(version, access, name, superName, interfaces, sourceFile);
        this.isCUT = this.targetClasses != null && this.targetClasses.contains(this.classNode.name.replace('/', '.'));
    }

    public void visitEnd() {
        String internalClassName = this.classNode.name;
        if (!this.hasClinit) {
            AsmUtil.addClinit((ClassVisitor)this, (String)internalClassName);
        }
        if (!this.agitarClassLoaderFieldExists) {
            AsmUtil.addAgitarClassLoaderField((ClassVisitor)this, (boolean)Modifier.isInterface(this.classNode.access));
        }
        super.visitEnd();
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        super.visitField(access, name, desc, value, attrs);
        if ("$agitar_classloader".equals(name)) {
            this.agitarClassLoaderFieldExists = true;
        }
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        MethodNode methodNode = new MethodNode(access, name, desc, exceptions, attrs);
        this.classNode.methods.add(methodNode);
        final String internalClassName = this.classNode.name;
        TreeCodeAdapter codeVisitor = new TreeCodeAdapter(methodNode){

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                Substitue resouce = Substitue.find(opcode, owner, name);
                if (resouce == null) {
                    super.visitMethodInsn(opcode, owner, name, desc);
                } else {
                    super.visitFieldInsn(178, internalClassName, "$agitar_classloader", AsmUtil.JAVA_LANG_CLASS_LOADER_TYPE.getDescriptor());
                    super.visitMethodInsn(184, Substitue.CLASS_LOADER_RESOURCES_INTERNAL_NAME, resouce.delegateName, resouce.descriptor);
                }
            }
        };
        if ("<clinit>".equals(name)) {
            this.hasClinit = true;
            AsmUtil.initAgitarClassLoaderField((CodeVisitor)codeVisitor, (String)internalClassName);
        } else if (!(!this.withInterceptor || this.isCUT || "<init>".equals(name) || Modifier.isAbstract(access) || Modifier.isNative(access))) {
            AsmMockingbirdUtility.interceptorCode((String)internalClassName, (CodeVisitor)codeVisitor, (boolean)Modifier.isStatic(access), (String)name, (String)desc, (LocalVariables)new LocalVariables(this.countArgs(access, desc)));
        }
        return codeVisitor;
    }

    private int countArgs(int access, String desc) {
        int argCount = Modifier.isStatic(access) ? 0 : 1;
        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < argumentTypes.length; ++i) {
            argCount += argumentTypes[i].getSize();
        }
        return argCount;
    }

    private static class Substitue {
        private static final String CLASS_LOADER_RESOURCES_INTERNAL_NAME = Type.getInternalName((Class)(class$com$agitar$common$asm$ClassLoaderResources == null ? (class$com$agitar$common$asm$ClassLoaderResources = ClassLoaderFieldAndInterceptor.class$("com.agitar.common.asm.ClassLoaderResources")) : class$com$agitar$common$asm$ClassLoaderResources));
        private static final String CLASS_LOADER_NAME = AsmUtil.JAVA_LANG_CLASS_LOADER_TYPE.getInternalName();
        private static final Class[] SIGNATURE_CLASSES = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoaderFieldAndInterceptor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$lang$String == null ? (class$java$lang$String = ClassLoaderFieldAndInterceptor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoaderFieldAndInterceptor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
        private static final Class[] SYSTEM_SIGNATURE_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClassLoaderFieldAndInterceptor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoaderFieldAndInterceptor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
        private static final String GET_RESOURCE = "getResource";
        private static final String GET_RESOURCE_AS_STREAM = "getResourceAsStream";
        private static final String GET_RESOURCE_AS_STREAM_DESCRIPTOR = AsmUtil.MethodDescription.getDescriptor((Class[])SIGNATURE_CLASSES, (Class)(class$java$io$InputStream == null ? (class$java$io$InputStream = ClassLoaderFieldAndInterceptor.class$("java.io.InputStream")) : class$java$io$InputStream));
        private static final String GET_RESOURCE_DESCRIPTOR = AsmUtil.MethodDescription.getDescriptor((Class[])SIGNATURE_CLASSES, (Class)(class$java$net$URL == null ? (class$java$net$URL = ClassLoaderFieldAndInterceptor.class$("java.net.URL")) : class$java$net$URL));
        private static final String GET_RESOURCES = "getResources";
        private static final String GET_RESOURCES_DESCRIPTOR = AsmUtil.MethodDescription.getDescriptor((Class[])SIGNATURE_CLASSES, (Class)(class$java$util$Enumeration == null ? (class$java$util$Enumeration = ClassLoaderFieldAndInterceptor.class$("java.util.Enumeration")) : class$java$util$Enumeration));
        private static final String GET_SYSTEM_RESOURCE = "getSystemResource";
        private static final String GET_SYSTEM_RESOURCE_AS_STREAM = "getSystemResourceAsStream";
        private static final String GET_SYSTEM_RESOURCE_AS_STREAM_DESCRIPTOR = AsmUtil.MethodDescription.getDescriptor((Class[])SYSTEM_SIGNATURE_CLASSES, (Class)(class$java$io$InputStream == null ? (class$java$io$InputStream = ClassLoaderFieldAndInterceptor.class$("java.io.InputStream")) : class$java$io$InputStream));
        private static final String GET_SYSTEM_RESOURCE_DESCRIPTOR = AsmUtil.MethodDescription.getDescriptor((Class[])SYSTEM_SIGNATURE_CLASSES, (Class)(class$java$net$URL == null ? (class$java$net$URL = ClassLoaderFieldAndInterceptor.class$("java.net.URL")) : class$java$net$URL));
        private static final String GET_SYSTEM_RESOURCES = "getSystemResources";
        private static final String GET_SYSTEM_RESOURCES_DESCRIPTOR = AsmUtil.MethodDescription.getDescriptor((Class[])SYSTEM_SIGNATURE_CLASSES, (Class)(class$java$util$Enumeration == null ? (class$java$util$Enumeration = ClassLoaderFieldAndInterceptor.class$("java.util.Enumeration")) : class$java$util$Enumeration));
        private static final Map map = new HashMap();
        private String delegateName;
        private String descriptor;
        private int opcode;

        private static Substitue find(int opcode, String className, String methodName) {
            if (CLASS_LOADER_NAME.equals(className)) {
                Substitue substitue;
                if (map.size() == 0) {
                    Substitue.initMap();
                }
                if ((substitue = (Substitue)map.get(methodName)) != null && opcode == substitue.opcode) {
                    return substitue;
                }
            }
            return null;
        }

        private static void initMap() {
            map.put(GET_RESOURCE, new Substitue(182, GET_RESOURCE, GET_RESOURCE_DESCRIPTOR));
            map.put(GET_RESOURCES, new Substitue(182, GET_RESOURCES, GET_RESOURCES_DESCRIPTOR));
            map.put(GET_RESOURCE_AS_STREAM, new Substitue(182, GET_RESOURCE_AS_STREAM, GET_RESOURCE_AS_STREAM_DESCRIPTOR));
            map.put(GET_SYSTEM_RESOURCE, new Substitue(184, GET_SYSTEM_RESOURCE, GET_SYSTEM_RESOURCE_DESCRIPTOR));
            map.put(GET_SYSTEM_RESOURCES, new Substitue(184, GET_SYSTEM_RESOURCES, GET_SYSTEM_RESOURCES_DESCRIPTOR));
            map.put(GET_SYSTEM_RESOURCE_AS_STREAM, new Substitue(184, GET_SYSTEM_RESOURCE_AS_STREAM, GET_SYSTEM_RESOURCE_AS_STREAM_DESCRIPTOR));
        }

        private Substitue(int opcode, String delegateName, String descriptor) {
            this.delegateName = delegateName;
            this.descriptor = descriptor;
            this.opcode = opcode;
        }
    }
}

