/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.instrument;

import com.agitar.common.asm.AsmUtil;
import com.agitar.coverage.analysis.AsmClassCache;
import com.agitar.instrument.Instrumenter;
import com.agitar.instrument.UseMocksClassAdapter;
import com.agitar.testrunner.UserProject;
import java.io.File;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class CallbackInstrumenter
implements Instrumenter {
    private static final boolean DEBUG = false;
    private static boolean alwaysOn;
    private final Set testClasses;
    private final Set targetClasses;
    private final UserProject project;

    public CallbackInstrumenter(Set testClasses, Set targetClasses) {
        this(null, testClasses, targetClasses);
    }

    public CallbackInstrumenter(UserProject project, Set testClasses, Set targetClasses) {
        this.project = project;
        this.testClasses = testClasses;
        this.targetClasses = targetClasses;
    }

    public byte[] instrument(String className, byte[] classBytes, ClassLoader callingLoader, File sourceFile, AsmClassCache classCache) {
        ClassReader cr = new ClassReader(classBytes);
        ClassWriter cw = new ClassWriter(true, true);
        cr.accept((ClassVisitor)new UseMocksClassAdapter(className, classBytes, (ClassVisitor)cw, classCache), AsmUtil.getDefaultAttributes(), false);
        return cw.toByteArray();
    }

    public boolean isInstrumentable(String className, File sourceFile) {
        boolean test = this.testClasses != null && (this.testClasses.contains(className) || this.project != null && (this.project.isSubclassOf(className, "junit.framework.TestCase") || this.project.isSubclassOf(className, "java.lang.SecurityManager")));
        boolean target = this.targetClasses != null && (this.targetClasses.contains(className) || this.project != null && this.project.shouldBeInstrumentedForCallback(className, this.targetClasses));
        boolean mockingbird = className.startsWith("com.agitar.lib.mockingbird") || className.startsWith("com.agitar.lib.junit");
        return alwaysOn || target && !test && !mockingbird;
    }

    public static void setAlwaysOn() {
        alwaysOn = true;
    }
}

