/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.RunnableSucceedsOrNot;

public class Timer {
    static final long TIMEOUT = 30000L;

    boolean time(RunnableSucceedsOrNot checkRunner, String actionType) throws InterruptedException {
        return this.time(checkRunner, actionType, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean time(final RunnableSucceedsOrNot checkRunner, final String actionType, long timeoutDuration) throws InterruptedException {
        final BooleanWrapper notifyWhenFinished = new BooleanWrapper(false);
        Thread runnerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    checkRunner.run();
                }
                catch (Exception e) {
                    LicenseLogger.log(AgitarLevel.WARNING, "exception in " + actionType + " timed thread", e);
                }
                BooleanWrapper booleanWrapper = notifyWhenFinished;
                synchronized (booleanWrapper) {
                    notifyWhenFinished.allDone = true;
                    notifyWhenFinished.notify();
                }
            }
        });
        try {
            BooleanWrapper booleanWrapper = notifyWhenFinished;
            synchronized (booleanWrapper) {
                runnerThread.start();
                notifyWhenFinished.wait(timeoutDuration);
            }
        }
        catch (InterruptedException ie) {
            LicenseLogger.log(AgitarLevel.WARNING, "interrupted while waiting for " + actionType + " to complete", ie);
        }
        if (!notifyWhenFinished.allDone && runnerThread.isAlive()) {
            runnerThread.interrupt();
            String timeoutMessage = actionType + " timed out";
            LicenseLogger.log(AgitarLevel.WARNING, timeoutMessage);
            throw new InterruptedException(timeoutMessage);
        }
        return checkRunner.getResult();
    }

    private static class BooleanWrapper {
        boolean allDone;

        BooleanWrapper(boolean b) {
            this.allDone = b;
        }
    }
}

