/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.AgitarException;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.licensechecker.Crypt;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.RunnableSucceedsOrNot;
import com.agitar.licensechecker.Timer;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ProxyInfo {
    public static final String SOCKS_PROXY_PORT = "socksProxyPort";
    public static final String HTTP_PROXY_SET = "http.proxySet";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String SOCKS_PROXY_HOST = "socksProxyHost";
    private static final String PREFERENCE_NODE = "com/agitar/agitarone/licensekey";
    private static final String PREFERENCE_PRX = "con";
    private static final String PREFERENCE_CON = "pcon";
    private static final String PREFERENCE_CON_SOCKS = "scon";
    public static final int TYPE_PROXY = 0;
    public static final int TYPE_SOCKS = 1;
    private Preferences pref;
    private Data proxy;
    private Data socks;
    private boolean proxyEnabled = false;
    private final Properties nonAgitarProxyProperties;
    private final String basePrefNode;
    private static String[] proxyPropertyKeys;

    public ProxyInfo() {
        this(PREFERENCE_NODE);
    }

    protected ProxyInfo(String basePreferenceNode) {
        this.basePrefNode = basePreferenceNode;
        this.nonAgitarProxyProperties = ProxyInfo.getAllProxyProperties();
        this.initPref();
        this.proxy = new Data(PREFERENCE_CON);
        this.socks = new Data(PREFERENCE_CON_SOCKS);
        this.proxy.load();
        this.socks.load();
        this.proxyEnabled = this.pref.get(PREFERENCE_PRX, null) != null ? "true".equals(Crypt.decrypt(this.pref.get(PREFERENCE_PRX, null))) : this.proxy.isEnable() || this.socks.isEnable();
    }

    public static Properties getAllProxyProperties() {
        Properties proxyProperties = new Properties();
        String[] keys = ProxyInfo.getProxyPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            String value = System.getProperty(keys[i]);
            if (value == null) continue;
            proxyProperties.setProperty(keys[i], value);
        }
        return proxyProperties;
    }

    public Data getProxy() {
        return this.proxy;
    }

    public Data getSocks() {
        return this.socks;
    }

    public void setData(int type, String host, int port, String user, String pass, boolean enable) {
        switch (type) {
            case 0: {
                this.setData(this.proxy, host, port, user, pass, enable);
                if (!enable) break;
                this.socks.setEnable(false);
                break;
            }
            case 1: {
                this.setData(this.socks, host, port, user, pass, enable);
                if (!enable) break;
                this.proxy.setEnable(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type can only be ProxyInfo.TYPE_PROXY or ProxyInfo.TYPE_SOCKS: found " + type);
            }
        }
    }

    private void setData(Data data, String host, int port, String user, String pass, boolean enable) {
        try {
            URL maybeFullUrl = new URL(host);
            host = maybeFullUrl.getHost();
            port = maybeFullUrl.getPort();
        }
        catch (MalformedURLException maybeJustPort) {
            try {
                int colonPosition = host.indexOf(58);
                if (colonPosition > 0) {
                    port = Integer.parseInt(host.substring(colonPosition + 1));
                    host = host.substring(0, colonPosition);
                }
            }
            catch (NumberFormatException badPortNumberSoUseParameter) {
                // empty catch block
            }
        }
        data.setHost(host);
        data.setPort(port);
        data.setUser(user);
        data.setPass(pass);
        data.setEnable(enable);
    }

    private void initPref() {
        this.pref = Preferences.userRoot().node(this.basePrefNode);
        try {
            this.pref.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public boolean isValid() {
        return this.proxy.isValid() || this.socks.isValid();
    }

    public boolean isEnable() {
        return this.isProxyEnabled() && (this.proxy.isEnable() || this.socks.isEnable());
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public void save() {
        this.pref.put(PREFERENCE_PRX, Crypt.encrypt("" + this.proxyEnabled));
        this.proxy.save();
        this.socks.save();
    }

    public void setProxy() {
        Properties properties = System.getProperties();
        if (!this.isEnable()) {
            this.clearProxyProperties(properties);
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Invalid HTTP Proxy information. Please reset the HTTP Proxy settings.");
        }
        Data d = this.proxy;
        int type = 0;
        if (this.socks.isEnable()) {
            LicenseLogger.log(AgitarLevel.FINE, "enabling socks proxy type");
            d = this.socks;
            type = 1;
        } else {
            LicenseLogger.log(AgitarLevel.FINE, "enabling http proxy type");
        }
        this.setProxyProperties(type, properties, d);
        this.setAuthentication(d);
    }

    public void logProxyAttempt() throws SocketException {
        boolean connected;
        RunnableSucceedsOrNot runnable = new RunnableSucceedsOrNot(){

            public void run() {
                this.setResult(ProxyInfo.this.tryConnect());
            }
        };
        try {
            connected = new Timer().time(runnable, "connect through proxy");
        }
        catch (InterruptedException timedOut) {
            throw new SocketException("Timeout while trying to connect through proxy. Please check your proxy settings and network connection and try again.");
        }
        if (!connected) {
            throw new SocketException("Could not connect through proxy. Please check your proxy settings and network connection and try again.");
        }
    }

    private boolean tryConnect() {
        try {
            URLConnection urlcon = new URL("http://license.agitar.com/index.jsp").openConnection();
            urlcon.setUseCaches(false);
            LicenseLogger.info("try connecting ...");
            long t = System.currentTimeMillis();
            urlcon.connect();
            InputStream is = urlcon.getInputStream();
            is.close();
            LicenseLogger.info("... done try connect. elapsed : " + (System.currentTimeMillis() - t));
            return true;
        }
        catch (Exception x) {
            LicenseLogger.log(Level.WARNING, x.toString(), x);
            return false;
        }
    }

    private void setAuthentication(Data data) {
        String u = data.getUser();
        if (u != null) {
            final String user = u;
            final String pass = data.getPass();
            Authenticator auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            };
            Authenticator.setDefault(auth);
            LicenseLogger.info("setting proxy auth user = " + user);
        } else {
            Authenticator.setDefault(null);
        }
    }

    private void setProxyProperties(int type, Properties properties, Data pData) {
        switch (type) {
            case 0: {
                properties.setProperty(HTTP_PROXY_HOST, pData.getHost());
                properties.setProperty(HTTP_PROXY_PORT, String.valueOf(pData.getPort()));
                properties.setProperty(HTTP_PROXY_SET, "true");
                properties.remove(SOCKS_PROXY_HOST);
                properties.remove(SOCKS_PROXY_PORT);
                LicenseLogger.info("setting http.proxyHost = " + System.getProperty(HTTP_PROXY_HOST));
                LicenseLogger.info("setting http.proxyPort = " + System.getProperty(HTTP_PROXY_PORT));
                LicenseLogger.info("setting http.proxySet  = " + System.getProperty(HTTP_PROXY_SET));
                break;
            }
            case 1: {
                properties.setProperty(SOCKS_PROXY_HOST, pData.getHost());
                properties.setProperty(SOCKS_PROXY_PORT, String.valueOf(pData.getPort()));
                properties.remove(HTTP_PROXY_HOST);
                properties.remove(HTTP_PROXY_PORT);
                properties.remove(HTTP_PROXY_SET);
                LicenseLogger.info("setting socksProxyHost = " + System.getProperty(SOCKS_PROXY_HOST));
                LicenseLogger.info("setting socksProxyPort = " + System.getProperty(SOCKS_PROXY_PORT));
                break;
            }
            default: {
                throw new IllegalArgumentException("Type can only be ProxyInfo.TYPE_PROXY or ProxyInfo.TYPE_SOCKS: found " + type);
            }
        }
    }

    private void clearProxyProperties(Properties properties) {
        Authenticator.setDefault(null);
        properties.remove(HTTP_PROXY_HOST);
        properties.remove(HTTP_PROXY_PORT);
        properties.remove(HTTP_PROXY_SET);
        properties.remove(SOCKS_PROXY_HOST);
        properties.remove(SOCKS_PROXY_PORT);
    }

    public void clear() {
        this.clearProxyProperties(System.getProperties());
        Authenticator.setDefault(null);
        this.pref.remove(PREFERENCE_PRX);
        this.proxy.clear();
        this.socks.clear();
    }

    static String[] getProxyPropertyKeys() {
        if (proxyPropertyKeys == null) {
            proxyPropertyKeys = new String[]{SOCKS_PROXY_HOST, SOCKS_PROXY_PORT, HTTP_PROXY_HOST, HTTP_PROXY_PORT, HTTP_PROXY_SET};
        }
        return proxyPropertyKeys;
    }

    public void unsetProxy() {
        LicenseLogger.fine("finished with network operations; unsetting proxy");
        Authenticator.setDefault(null);
        String[] keys = ProxyInfo.getProxyPropertyKeys();
        Properties systemProperties = System.getProperties();
        for (int i = 0; i < keys.length; ++i) {
            if (!systemProperties.containsKey(keys[i])) continue;
            systemProperties.remove(keys[i]);
        }
        Enumeration<Object> e = this.nonAgitarProxyProperties.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            System.getProperties().put(key, this.nonAgitarProxyProperties.get(key));
        }
    }

    public String currentProxyPropertiesToString() {
        StringBuffer buf = new StringBuffer("Current proxy properties:\n");
        String[] keys = ProxyInfo.getProxyPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            buf.append('\t').append(keys[i]).append('\t').append(System.getProperty(keys[i]));
        }
        return buf.toString();
    }

    public class Data {
        private final String pKey;
        private String host;
        private int port;
        private String user;
        private String pass;
        private boolean enable;

        private Data(String storageKey) {
            this.pKey = storageKey;
        }

        public void clear() {
            ProxyInfo.this.pref.remove(this.pKey);
            try {
                ProxyInfo.this.pref.flush();
            }
            catch (Exception e) {
                throw new AgitarException(e.getMessage());
            }
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            if (host == null || host.length() == 0) {
                throw new IllegalArgumentException("Host name cannot be empty.");
            }
            this.host = host;
        }

        public String getPass() {
            return this.pass;
        }

        public void setPass(String pass) {
            this.pass = pass;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            if (port < 1) {
                throw new IllegalArgumentException("Invalid port number: " + port);
            }
            this.port = port;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void save() {
            if (!this.isValid()) {
                return;
            }
            ProxyInfo.this.pref.put(this.pKey, this.serialize());
            try {
                ProxyInfo.this.pref.flush();
            }
            catch (BackingStoreException e) {
                System.err.println(e.toString());
            }
        }

        private void load() {
            String pSettings = ProxyInfo.this.pref.get(this.pKey, null);
            if (pSettings != null) {
                pSettings = Crypt.decrypt(pSettings);
                StringTokenizer st = new StringTokenizer(pSettings, "\n");
                this.host = st.nextToken();
                this.port = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    this.enable = "true".equals(t);
                }
                if (st.hasMoreTokens()) {
                    this.user = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    this.pass = st.nextToken();
                }
            }
        }

        public boolean isValid() {
            return this.host != null && this.host.length() > 0;
        }

        private String serialize() {
            StringBuffer sb = this.toUnencryptedStr();
            return Crypt.encrypt(sb.toString());
        }

        private StringBuffer toUnencryptedStr() {
            StringBuffer sb = new StringBuffer(this.host);
            sb.append('\n');
            sb.append(this.port);
            sb.append('\n');
            sb.append(this.enable);
            sb.append('\n');
            if (this.user != null) {
                sb.append(this.user).append('\n');
            }
            if (this.pass != null) {
                sb.append(this.pass).append('\n');
            }
            return sb;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Data) {
                Data data = (Data)obj;
                return this.equals(this.host, data.host) && this.port == data.port && this.enable == data.enable && this.equals(this.user, data.user) && this.equals(this.pass, data.pass);
            }
            return false;
        }

        public int hashCode() {
            return this.toUnencryptedStr().toString().hashCode();
        }

        private boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }
    }
}

