/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.licensechecker.AbstractLicenseChecker;
import com.agitar.licensechecker.ApplicationInfo;
import com.agitar.licensechecker.CheckoutContext;
import com.agitar.licensechecker.IlsLicenserFactory;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.InvalidLicenseFeatureException;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.LicensedFeature;
import com.agitar.licensechecker.Licenser;
import com.agitar.licensechecker.LicenserFactory;
import com.agitar.licensechecker.OnlineApplicationInfo;
import com.agitar.licensechecker.OnlineLicenseServerUrl;
import com.agitar.licensechecker.ProxyInfo;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;

public class OnlineLicenseChecker
extends AbstractLicenseChecker {
    public static String TOKEN = "1234509876";
    protected HashMap infoToLicenser = new HashMap();

    protected OnlineLicenseChecker() {
    }

    public OnlineLicenseChecker(String serverUrl) {
        this(new IlsLicenserFactory(), serverUrl);
    }

    protected OnlineLicenseChecker(LicenserFactory licenserGenerator, String url) {
        if (licenserGenerator == null) {
            throw new IllegalArgumentException("licenserfactory cannot be null");
        }
        this.machineName = null;
        this.licenserFactory = licenserGenerator;
        try {
            this.serverUrl = new OnlineLicenseServerUrl(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed server url.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationInfo commandLineCheck(LicensedFeature feature, String customer_id, String user_email, String machine_name, String sessionId) throws InvalidLicenseException, InterruptedException {
        LicenseLogger.info("checking license from command-line tool");
        ApplicationInfo info = this.getApplicationInfo(customer_id, machine_name, user_email, true);
        OnlineLicenseChecker.overrideSessionId(info, sessionId);
        int retry = 4;
        boolean contacted = false;
        try {
            do {
                try {
                    this.checkLicense(feature, info);
                    contacted = true;
                }
                catch (SocketException ex) {
                    if (--retry <= 0) {
                        throw ex;
                    }
                    OnlineLicenseChecker onlineLicenseChecker = this;
                    synchronized (onlineLicenseChecker) {
                        this.wait(5000L);
                    }
                }
            } while (!contacted);
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception x) {
            String msg = x.getMessage();
            System.out.println("OnlineLicenseChecker.commandLineCheck, server : " + this.serverUrl.toString());
            System.out.println("OnlineLicenseChecker.commandLineCheck, info.toString(): " + info.toString());
            System.out.println("OnlineLicenseChecker.commandLineCheck, error: " + msg);
            System.out.println("*** Online license check failed:\n");
            if (x instanceof SocketException) {
                throw new InvalidLicenseException(msg + ": tried to contact ils server for 4 times (20 seconds)", x);
            }
            throw new InvalidLicenseException(msg, x);
        }
        return info;
    }

    static void overrideSessionId(ApplicationInfo info, String sessionId) {
        int sessionHash;
        if (info instanceof OnlineApplicationInfo) {
            StringBuffer sb = new StringBuffer();
            String clientMachineName = ((OnlineApplicationInfo)info).getClientMachineName();
            if (clientMachineName == null || clientMachineName.equals("null")) {
                clientMachineName = "";
            }
            sb.append(info.getEmailAddress() == null ? "" : info.getEmailAddress());
            sb.append("@");
            sb.append(clientMachineName);
            sessionId = sb.toString();
        }
        if ((sessionHash = sessionId.hashCode()) < 0) {
            sessionHash *= -1;
        }
        info.setSessionIdOverrides(new Long(sessionHash));
    }

    public synchronized void checkLicenseWithoutFeature() throws InvalidLicenseException, SocketException {
        throw new UnsupportedOperationException("");
    }

    public synchronized void checkLicense(LicensedFeature feature) throws InvalidLicenseException, SocketException {
        throw new UnsupportedOperationException("");
    }

    public final synchronized void checkLicense(LicensedFeature feature, ApplicationInfo info) throws InvalidLicenseException, SocketException {
        LicenseLogger.info("checking license (deep)");
        this.checkLicense(feature, info, true);
    }

    protected synchronized void checkLicense(LicensedFeature feature, ApplicationInfo info, boolean gotoServer) throws InvalidLicenseException, SocketException {
        if (!info.isValid()) {
            throw new InvalidLicenseException("Please register Agitar client to continue.");
        }
        try {
            LicenseLogger.fine("deep check in foreground");
            this.checkout(info, true);
            Licenser client = this.getLicenser(info);
            CheckoutContext context = this.createCheckoutContext(client);
            if (feature != null && !context.isFeatureAllowed(feature)) {
                LicenseLogger.fine("Feature not allowed: " + feature.toString());
                throw new InvalidLicenseFeatureException(feature.toString());
            }
        }
        catch (SocketException se) {
            LicenseLogger.fine("server check failed");
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void checkout(ApplicationInfo info, boolean fingerChanged) throws InvalidLicenseException, SocketException {
        if (!info.isValid()) {
            throw new IllegalArgumentException("cannot checkout on invalid info");
        }
        Licenser licenser = this.getLicenser(info);
        ProxyInfo pInfo = this.enableProxyIfNeeded();
        try {
            boolean checkoutSuccess;
            LicenseLogger.fine("checking out with " + info.toString() + ")");
            try {
                checkoutSuccess = this.timedCheckout(licenser, info.getCheckoutDuration());
            }
            catch (InterruptedException e) {
                throw new SocketException("Network timeout while checking license.");
            }
            if (!checkoutSuccess && licenser.getStatus() == 29) {
                this.handleFailedCheckout(licenser, pInfo);
            }
            if (!checkoutSuccess) {
                this.handleFailedCheckout(licenser, pInfo);
            } else {
                CheckoutContext context = new CheckoutContext(licenser);
                context.checkVersion();
                context.saveToServer(info.getEmailAddress(), ((OnlineApplicationInfo)info).getClientMachineName(), licenser);
                this.manageQuota(info, licenser);
            }
        }
        finally {
            if (pInfo.isValid()) {
                pInfo.unsetProxy();
            }
        }
    }

    public Licenser getLicenser(ApplicationInfo info) {
        if (info == null || info.getCustomerId() == null || info.getProductKey() == null && !info.isFloating()) {
            throw new IllegalArgumentException("licenser info cannot be null or invalid");
        }
        Licenser licenser = (Licenser)this.infoToLicenser.get(info);
        if (licenser == null) {
            licenser = this.getLicenser(info.getCustomerId(), info.getProductKey(), info.isFloating(), info.getSessionId());
            this.infoToLicenser.put(info, licenser);
        }
        return licenser;
    }

    protected Licenser getLicenser(String customerId, String productKey, boolean isFloating, long sessionId) {
        return this.licenserFactory.getLicenser(this.getServerUrl().getUrl(), null, customerId, null, true, sessionId);
    }

    public String getMachineFingerprint() {
        throw new UnsupportedOperationException("");
    }

    protected CheckoutContext createCheckoutContext(Licenser client) throws InvalidLicenseException {
        CheckoutContext context = new CheckoutContext(client);
        return context;
    }

    public synchronized void checkin() throws InvalidLicenseException {
        throw new UnsupportedOperationException("");
    }

    protected void restoreStateDuringCheckin(ApplicationInfo info, Licenser licenser) throws InvalidLicenseException {
    }

    public void cleanLicenserChecker(ApplicationInfo info) {
        this.infoToLicenser.remove(info);
    }

    public final synchronized void applicationExit() {
        LicenseLogger.info("exiting application");
        Iterator iter = this.infoToLicenser.keySet().iterator();
        while (iter.hasNext()) {
            ApplicationInfo info = (ApplicationInfo)iter.next();
            LicenseLogger.info("exiting application; releasing context for" + info.toString());
            try {
                this.timedCheckin(info);
            }
            catch (InterruptedException e) {
                LicenseLogger.log(AgitarLevel.INFO, "Network timeout while releasing license on application exit", e);
            }
        }
        this.infoToLicenser.clear();
    }

    protected ApplicationInfo getApplicationInfo() throws InvalidLicenseException {
        return OnlineApplicationInfo.getSavedInfo();
    }

    protected ApplicationInfo getApplicationInfo(String customerId, String machineName, String emailAddress, boolean floating) throws InvalidLicenseException {
        return OnlineApplicationInfo.getNewInfo(customerId, machineName, emailAddress, floating);
    }

    public synchronized void deductQuota(ApplicationInfo info, int quantity) throws InvalidLicenseException, SocketException {
        LicenseLogger.info("deduct license quota for " + info.getCustomerId() + " " + info.getSessionId());
        Licenser client = this.getLicenser(info);
        boolean status = client.upQuotaUseLevel(quantity);
        if (!status) {
            this.handleFailedCheckout(client, null);
        }
    }
}

