/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.AgitarException;
import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.util.EvilTwin;
import com.agitar.common.util.JarFinder;
import com.agitar.lib.NoObfuscation;
import com.agitar.license.LicenseManager;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseChecker;
import com.agitar.licensechecker.LicenseLogger;
import com.vs.ils.client.IlsClient;
import com.vs.ils.crypt.PkCrypt;
import com.vs.ils.crypt.Signature;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MachineName {
    private static Boolean isWindows = null;
    private static Boolean isLinux = null;
    private static boolean nativeLoaded;
    private static boolean canMakeFingerPrint;
    private final String machineId;
    private String userName;

    public MachineName(String machineName) {
        this.machineId = machineName;
        this.userName = System.getProperty("user.name", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void verifyJar(String mainDir) throws IllegalStateException {
        LicenseLogger.log(AgitarLevel.FINER, "LicenseManager: Main directory is " + mainDir);
        String jar0 = mainDir + File.separator + "ilsclient10.jar";
        LicenseLogger.finer("LicenseManager jar at: " + jar0);
        String[] sigs = Signature.makeLibDigest((String)jar0, (String)"LLTsMdXTCLPnKYasDaH/IbHXGL+nNK2pIbTHLanZDe==", (String)"AgilisIlsClient", (boolean)false);
        String savedSig = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(LicenseChecker.class.getResourceAsStream("ilsclient.sig"), "UTF-8"));
            savedSig = br.readLine().trim();
            br.close();
            String curSig = PkCrypt.encryptWithPublicKey((String)sigs[0], (String)"YspFFMlQEOtMaOVhYuxvFMtAT+4=");
            LicenseLogger.finer("LicenseManager  sigs: " + sigs[0] + "\t" + sigs[1]);
            LicenseLogger.finer("LicenseManager ssigs: " + curSig + "\t" + savedSig);
            if (!curSig.equals(sigs[1])) {
                // empty if block
            }
            if (sigs[1].equals(savedSig)) return;
        }
        catch (Exception x) {
            LicenseLogger.log(AgitarLevel.WARNING, "Throwing illegal state exception", x);
            IllegalStateException isx = new IllegalStateException("Cannot verify code authenticity : " + x.getMessage());
            isx.setStackTrace(new StackTraceElement[0]);
            throw isx;
        }
    }

    private static void loadLibraries(String mainDir) {
        File f = null;
        if (mainDir != null) {
            File dir = new File(mainDir);
            f = new File(dir, "lib");
            if (!f.isDirectory()) {
                f = new File(dir.getParentFile(), "lib");
            }
        } else {
            String libpath = System.getProperty("license.native.lib.path");
            if (libpath != null) {
                f = new File(libpath);
            }
        }
        if (f != null) {
            String libname = EvilTwin.isMe() ? "xxxmachineid" : "machineid";
            String fname = f.getPath();
            if (MachineName.isWindows()) {
                fname = fname + File.separatorChar + libname + ".dll";
            } else if (MachineName.isLinux()) {
                fname = fname + File.separatorChar + "lib" + libname + ".so";
            } else {
                nativeLoaded = false;
                return;
            }
            System.load(fname);
            nativeLoaded = true;
        }
    }

    static boolean isWindows() {
        if (isWindows == null) {
            String osname = System.getProperty("os.name").toLowerCase();
            isWindows = new Boolean(osname.startsWith("windows"));
        }
        return isWindows;
    }

    private static boolean isLinux() {
        if (isLinux == null) {
            String osname = System.getProperty("os.name").toLowerCase();
            isLinux = new Boolean(osname.startsWith("linux") && System.getProperty("os.arch").toLowerCase().matches("i[3456]86"));
        }
        return isLinux;
    }

    void checkMachineFingerprint(String fingerprint) throws InvalidLicenseException {
        if (!nativeLoaded && (MachineName.isWindows() || MachineName.isLinux())) {
            if (canMakeFingerPrint) {
                throw new NativeLibrariesNotLoadedException();
            }
            LicenseLogger.warning("Cannot load native library.");
        } else if (nativeLoaded) {
            if (fingerprint == null) {
                throw new InvalidLicenseException("null fingerprint");
            }
            if (canMakeFingerPrint) {
                int status = LicenseManager.checkMachineFingerprint(MachineName.getPKForLocalSignature(), fingerprint, null, 1);
                if (status < 0) {
                    throw new InvalidLicenseException("Your license does not match your hardware profile. Please re-register your Agitar client to sync your hardware profile to your license.");
                }
            } else {
                LicenseLogger.warning("Check finger print succeeds as we couldn't make finger print.");
            }
        }
    }

    public static MachineName getDefaultMachineName() {
        String hostName;
        if (nativeLoaded) {
            String id = null;
            try {
                id = LicenseManager.makeMachineFingerprint(MachineName.getPKForLocalSignature(), null);
            }
            catch (Throwable th) {
                LicenseLogger.warning("could not make machine finger print");
            }
            if (id != null) {
                canMakeFingerPrint = true;
                return new MachineName(id);
            }
        }
        if ((hostName = MachineName.getHostName()) == null) {
            hostName = "";
            LicenseLogger.warning("could not obtain host name while generating machine fingerprint");
        }
        return new MachineName(hostName);
    }

    static String getHostName() {
        try {
            if (MachineName.isLinux()) {
                if (!nativeLoaded) {
                    throw new NativeLibrariesNotLoadedException();
                }
                return LicenseManager.getHostName();
            }
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LicenseLogger.log(AgitarLevel.WARNING, "could not get host name", e);
            return null;
        }
    }

    public String getMachineFingerprint() {
        return this.machineId;
    }

    static String getPKForLocalSignature() {
        return PkCrypt.makePublicKey((String)"AgitarOne");
    }

    public boolean equals(String machineName) {
        if (machineName == null) {
            return this.machineId == null;
        }
        return machineName.equals(this.machineId);
    }

    public long getHashedFingerprint() {
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AgitarException("unabled to use MD5 algorithm", (Throwable)e);
        }
        byte[] digest = digester.digest((this.machineId + this.userName).getBytes());
        BigInteger fullHash = new BigInteger(digest);
        long justLow64Bits = fullHash.longValue();
        return justLow64Bits;
    }

    public String getActivationID() {
        StringBuffer imPretty = new StringBuffer(Long.toHexString(this.getHashedFingerprint()));
        while (imPretty.length() < 16) {
            imPretty.insert(0, '0');
        }
        for (int i = 0; i < 3; ++i) {
            int offset = i * 5 + 4;
            imPretty.insert(offset, '-');
        }
        return imPretty.toString();
    }

    void setUserName(String userNameOverride) {
        this.userName = userNameOverride;
    }

    static {
        canMakeFingerPrint = false;
        String mainDir = null;
        mainDir = JarFinder.getContainingDir((Class)IlsClient.class);
        MachineName.verifyJar(mainDir);
        try {
            MachineName.loadLibraries(mainDir);
        }
        catch (Throwable ex) {
            nativeLoaded = false;
            if (MachineName.isWindows() || MachineName.isLinux()) {
                if (ex.getMessage().matches(".*already loaded in another classloader.*")) {
                    LicenseLogger.log(AgitarLevel.SEVERE, "native library already loaded by other classloader, local license checking disabled on windows and linux: " + ex.getMessage(), true);
                } else {
                    LicenseLogger.log(AgitarLevel.SEVERE, "Could not load libraries: " + ex.getMessage(), true);
                }
            }
            LicenseLogger.log(AgitarLevel.WARNING, "Could not load libraries: " + ex.getMessage(), true);
        }
    }

    private static final class NativeLibrariesNotLoadedException
    extends AgitarException
    implements NoObfuscation {
        private NativeLibrariesNotLoadedException() {
            super("Native libraries could not be loaded, possibly because this process is being run from a second classloader within the same VM. Check classpath, or fork process if possible.");
        }
    }
}

