/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class LicenseServerUrl {
    static final String DEFAULT_SERVER = "license.agitar.com";
    static final String SERVER_HOST_KEY = "license.server.hostname";
    static final String SERVER_PORT_KEY = "license.server.port";
    static final String ILS_JSP_PATH = "/ils/ils.jsp";
    private static final String SERVER_PREFERENCES_KEY = "targetserver";
    private static final String TARGET_PORT_PREFERENCES_KEY = "targetport";
    private static final String TARGET_SSL_PREFERENCES_KEY = "serverssl";
    private static final String TARGET_ENABLED_PREFERENCES_KEY = "targetenabled";
    public static final String DEFAULT_LICENSE_URL_PREFERENCES_NODE = "com/agitar/agitarone/licenseserver";
    private final String licenseUrlPreferenceNode;
    private final String targetHost;
    private Integer targetPort;
    public static final int DEFAULT_PORT = 80;
    private boolean targetEnabled = false;
    private boolean useSSL = false;

    public LicenseServerUrl() {
        this(DEFAULT_LICENSE_URL_PREFERENCES_NODE);
    }

    public LicenseServerUrl(String targetServer, int nonDefaultTargetPort) {
        this(targetServer, nonDefaultTargetPort, false);
    }

    public LicenseServerUrl(String targetServer, int nonDefaultTargetPort, boolean useSSL) {
        this(DEFAULT_LICENSE_URL_PREFERENCES_NODE, targetServer, nonDefaultTargetPort == -1 ? 80 : nonDefaultTargetPort, useSSL);
    }

    LicenseServerUrl(String preferencesNode, String targetServer) {
        this(preferencesNode, targetServer, 80);
    }

    public LicenseServerUrl(String preferencesNode, String targetServer, int nonDefaultTargetPort) {
        this(preferencesNode, targetServer, nonDefaultTargetPort, false);
    }

    public LicenseServerUrl(String preferencesNode, String targetServer, int nonDefaultTargetPort, boolean useSSL) {
        if (preferencesNode == null) {
            throw new IllegalArgumentException("preferences node cannot be null");
        }
        if (nonDefaultTargetPort < 0 || nonDefaultTargetPort > 65535) {
            throw new IllegalArgumentException("port number must be between 0 and 65535");
        }
        this.licenseUrlPreferenceNode = preferencesNode;
        this.targetHost = targetServer != null ? targetServer : DEFAULT_SERVER;
        this.targetPort = new Integer(nonDefaultTargetPort);
        this.useSSL = useSSL;
    }

    public LicenseServerUrl(String preferencesNode) {
        if (preferencesNode == null) {
            throw new IllegalArgumentException("preferences node cannot be null");
        }
        this.licenseUrlPreferenceNode = preferencesNode;
        String serverHostProperty = System.getProperty(SERVER_HOST_KEY);
        String serverPortProperty = System.getProperty(SERVER_PORT_KEY);
        if (serverHostProperty != null || serverPortProperty != null) {
            this.targetHost = serverHostProperty != null ? serverHostProperty : DEFAULT_SERVER;
            this.targetPort = serverPortProperty != null ? Integer.valueOf(serverPortProperty) : new Integer(80);
            this.targetEnabled = true;
        } else {
            String targetFromPreferences = this.loadTargetUrl();
            if (targetFromPreferences != null) {
                this.targetHost = targetFromPreferences;
                this.targetPort = this.loadTargetPort();
                this.targetEnabled = this.loadTargetEnabled();
                this.useSSL = this.loadUseSSL();
            } else {
                this.targetHost = DEFAULT_SERVER;
                this.targetPort = new Integer(80);
            }
        }
    }

    private boolean loadTargetEnabled() {
        Preferences serverUrlNode = Preferences.userRoot().node(this.licenseUrlPreferenceNode);
        String value = serverUrlNode.get(TARGET_ENABLED_PREFERENCES_KEY, null);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private String loadTargetUrl() {
        Preferences serverUrlNode = Preferences.userRoot().node(this.licenseUrlPreferenceNode);
        return serverUrlNode.get(SERVER_PREFERENCES_KEY, null);
    }

    private boolean loadUseSSL() {
        Preferences serverUrlNode = Preferences.userRoot().node(this.licenseUrlPreferenceNode);
        return serverUrlNode.getBoolean(TARGET_SSL_PREFERENCES_KEY, false);
    }

    private Integer loadTargetPort() {
        Preferences serverUrlNode = Preferences.userRoot().node(this.licenseUrlPreferenceNode);
        return Integer.valueOf(serverUrlNode.get(TARGET_PORT_PREFERENCES_KEY, new Integer(80).toString()));
    }

    public String getUrl() {
        String targetString = null;
        targetString = this.isTargetEnabled() && this.targetHost != null ? "http://" + this.targetHost + ":" + this.getTargetPort() + ILS_JSP_PATH : "http://license.agitar.com:80/ils/ils.jsp";
        return targetString;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public void save() throws BackingStoreException {
        Preferences serverUrlNode = Preferences.userRoot().node(this.licenseUrlPreferenceNode);
        serverUrlNode.put(SERVER_PREFERENCES_KEY, this.targetHost);
        serverUrlNode.put(TARGET_PORT_PREFERENCES_KEY, this.targetPort.toString());
        serverUrlNode.put(TARGET_ENABLED_PREFERENCES_KEY, Boolean.toString(this.targetEnabled));
        serverUrlNode.putBoolean(TARGET_SSL_PREFERENCES_KEY, this.useSSL);
        serverUrlNode.flush();
    }

    public void clear() throws BackingStoreException {
        Preferences serverUrlNode = Preferences.userRoot().node(this.licenseUrlPreferenceNode);
        serverUrlNode.remove(SERVER_PREFERENCES_KEY);
        serverUrlNode.flush();
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public boolean isTargetEnabled() {
        return this.targetEnabled;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setTargetEnabled(boolean enabled) {
        this.targetEnabled = enabled;
    }
}

