/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.licensechecker.LicensedFeature;

public class LicenseOptionCheck {
    LicenseOption agLic = null;
    LicenseOption genLic = null;
    long quotaCap = -1L;

    public void setAgitationLicenseOption(boolean remote, boolean local) {
        this.agLic = new LicenseOption(remote, local, false);
    }

    public void setGenerationLicenseOption(boolean remote, boolean local) {
        this.genLic = new LicenseOption(remote, local, true);
    }

    public void setQuotaCap(long quota) {
        this.quotaCap = quota;
    }

    public boolean isQuota() {
        return this.quotaCap > -1L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isQuota() ? "Quota" : "Quotaless");
        sb.append(this.agLic != null ? this.agLic.toString() : "");
        sb.append(',');
        sb.append(this.genLic != null ? this.genLic.toString() : "");
        return sb.toString();
    }

    public boolean checkFeature(LicensedFeature feature) {
        if (feature.isGeneration()) {
            if (this.genLic == null) {
                return false;
            }
            if (feature.isLocal()) {
                return this.genLic.isLocal;
            }
            return this.genLic.isRemote;
        }
        if (this.agLic == null) {
            return false;
        }
        if (feature.isLocal()) {
            return this.agLic.isLocal;
        }
        return this.agLic.isRemote;
    }

    public boolean checkHasOfflineFeature() {
        if (!this.isQuota()) {
            return true;
        }
        return this.agLic != null && this.agLic.isLocal() || this.genLic != null && this.genLic.isLocal();
    }

    public class LicenseOption {
        boolean isLocal;
        boolean isRemote;
        boolean isGeneration;
        String label;

        public LicenseOption(boolean server, boolean local, boolean generation) {
            this.isGeneration = generation;
            this.isLocal = local;
            this.isRemote = server;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public boolean isServer() {
            return this.isRemote;
        }

        public String toString() {
            if (this.label == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.isLocal ? "Local" : "");
                sb.append(' ');
                sb.append(this.isRemote ? "Remote" : "");
                sb.append(' ');
                sb.append(this.isGeneration ? "Test Generation" : "Agitation");
                this.label = sb.toString();
            }
            return this.label;
        }

        public boolean equals(LicenseOption target) {
            return target.isLocal == this.isLocal && target.isRemote == this.isRemote && target.isGeneration == this.isGeneration;
        }
    }
}

