/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.common.logging.AgitarLevel;
import com.agitar.common.logging.AgitarLogger;
import com.agitar.common.util.AgitarProperties;
import com.agitar.common.util.MessageFormatter;
import com.agitar.common.util.StringUtility;
import com.agitar.licensechecker.AbstractLicenseChecker;
import com.agitar.licensechecker.ApplicationInfo;
import com.agitar.licensechecker.CheckoutContext;
import com.agitar.licensechecker.IlsLicenserFactory;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.InvalidLicenseFeatureException;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.LicensedFeature;
import com.agitar.licensechecker.Licenser;
import com.agitar.licensechecker.LicenserFactory;
import com.agitar.licensechecker.LicensingVersion;
import com.agitar.licensechecker.MachineName;
import com.agitar.licensechecker.ProxyInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class LicenseChecker
extends AbstractLicenseChecker {
    public static final String DEFAULT_PRODUCT = "AgitarOne";
    public static final String TOKEN = "asdfghjkl;";
    static final String HFILE_KEY = "user.home";
    static final String ILS_FILE = ".ils10jk";
    private static final long rudimentaryUniqueProcessID = System.currentTimeMillis();
    private String hFileDir = null;
    private boolean hFileDirRehabilitated = false;
    private static boolean telemetryEnabledForTesting = false;
    private boolean backgroundChecks = true;
    public static final String LOCKFILENAME = "liclock";
    private static InvalidLicenseException exceptionInBackgroundThread = null;
    Object criticalSectionLock = new Object();
    private FileLock flock;
    public static LicensedFeature FEATURE_SERVER_AGITATION = new ServerAgitation();
    public static LicensedFeature FEATURE_SERVER_GENERATION = new ServerTestGeneration();
    public static LicensedFeature FEATURE_LOCAL_AGITATION = new LocalAgitation();
    public static LicensedFeature FEATURE_LOCAL_GENERATION = new LocalTestGeneration();
    private static final int LOCK_TRIES = 10;

    public LicenseChecker() {
        this(new IlsLicenserFactory(), null);
    }

    protected LicenseChecker(LicenserFactory licenserGenerator, MachineName machine) {
        if (licenserGenerator == null) {
            throw new IllegalArgumentException("licenserfactory cannot be null");
        }
        this.machineName = machine == null ? MachineName.getDefaultMachineName() : machine;
        this.licenserFactory = licenserGenerator;
        this.initHdir();
        LicenseLogger.fine("saving cache at " + this.hFileDir);
    }

    public final synchronized boolean isLicenseKeySet() {
        try {
            return this.getApplicationInfo().isValid();
        }
        catch (InvalidLicenseException e) {
            LicenseLogger.log(AgitarLevel.SEVERE, "error checking license key", e);
            return false;
        }
    }

    private String getPostTwoFiveOhHdir() throws UnknownHostException {
        String hostName = MachineName.getHostName();
        if (hostName == null) {
            throw new UnknownHostException("could not access local host name");
        }
        String userDir = AgitarProperties.USER_HOME.getAbsolutePath();
        String postTwoFiveOhHdir = userDir + File.separatorChar + ".agitar" + File.separatorChar + ".hdir" + File.separatorChar + hostName;
        return postTwoFiveOhHdir;
    }

    private void initHdir() {
        this.hFileDir = AgitarProperties.USER_HOME.getAbsolutePath();
        try {
            String postTwoFiveOhHdir = this.getPostTwoFiveOhHdir();
            File newIlsFile = new File(postTwoFiveOhHdir + File.separatorChar + ILS_FILE);
            if (newIlsFile.exists()) {
                this.hFileDir = postTwoFiveOhHdir;
                this.hFileDirRehabilitated = true;
            } else {
                if (!newIlsFile.getParentFile().exists() && !newIlsFile.getParentFile().mkdirs()) {
                    LicenseLogger.severe("could not write ils dir " + this.hFileDir);
                    throw new IllegalStateException("could not write to " + this.hFileDir + ". aborting");
                }
                File oldIlsFile = new File(this.hFileDir + File.separatorChar + ILS_FILE);
                if (oldIlsFile.exists()) {
                    this.hFileDirRehabilitated = false;
                } else {
                    this.hFileDir = postTwoFiveOhHdir;
                    this.hFileDirRehabilitated = true;
                }
            }
        }
        catch (UnknownHostException e) {
            LicenseLogger.log(AgitarLevel.WARNING, "hostname not available; using default hdir", e);
        }
    }

    String getHdir() {
        return this.hFileDir;
    }

    public final synchronized void register(String customerId, String productKey, String emailAddress, long duration) throws InvalidLicenseException, SocketException {
        LicenseLogger.info("attempting registration");
        ApplicationInfo prev = this.getApplicationInfo();
        ApplicationInfo info = this.checkRegistrationInfo(customerId, productKey, emailAddress, true, duration);
        this.useHashedMachineID = false;
        if (prev.isValid() && !prev.equals(info)) {
            boolean checkinSuccess;
            try {
                checkinSuccess = this.timedCheckin(prev);
            }
            catch (InterruptedException timeout) {
                checkinSuccess = false;
            }
            LicenseLogger.finer("attempted to check in old license during registration. success? " + checkinSuccess);
        }
        prev.deleteInfo();
        this.setDurationBasedOnFeature(info);
        info.save();
        this.checkout(info);
    }

    public final synchronized ApplicationInfo registerWithoutChecks(String customerId, String productKey, String emailAddress) throws SocketException, InvalidLicenseException {
        return this.registerWithoutChecks(customerId, productKey, emailAddress, 86400L);
    }

    public final synchronized ApplicationInfo registerWithoutChecks(String customerId, String productKey, String emailAddress, long duration) throws InvalidLicenseException, SocketException {
        LicenseLogger.info("attempting registration");
        ApplicationInfo prev = this.getApplicationInfo();
        ApplicationInfo info = this.checkRegistrationInfo(customerId, productKey, emailAddress, true, duration);
        prev.deleteInfo();
        info.save();
        if (prev.isValid() && !prev.equals(info)) {
            return prev;
        }
        return null;
    }

    private ApplicationInfo checkRegistrationInfo(String customerId, String productKey, String emailAddress, boolean floating, long duration) throws InvalidLicenseException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Cannot register with negative duration");
        }
        if (floating) {
            productKey = null;
        }
        ApplicationInfo info = this.getApplicationInfo(customerId, productKey, emailAddress, floating);
        info.setDuration(duration);
        return info;
    }

    private void setDurationBasedOnFeature(ApplicationInfo info) throws InvalidLicenseException {
        Licenser licenser = this.getLicenser(info);
        CheckoutContext ctx = new CheckoutContext(licenser.getOptions(), licenser.getAppCtx(), licenser.getQuotaCap());
        if (ctx.hasLocalDurationFeature()) {
            info.setDuration(86400L);
        }
    }

    private synchronized Licenser checkout(ApplicationInfo info) throws InvalidLicenseException, SocketException {
        return this.checkout(info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Licenser checkout(ApplicationInfo info, boolean fingerChanged) throws InvalidLicenseException, SocketException {
        if (!info.isValid()) {
            throw new IllegalArgumentException("cannot checkout on invalid info");
        }
        ApplicationInfo prev = this.getApplicationInfo();
        Licenser licenser = this.getLicenser(info);
        ProxyInfo pInfo = this.enableProxyIfNeeded();
        try {
            boolean checkoutSuccess;
            if (prev.isValid() && prev.equals(info) && fingerChanged) {
                LicenseLogger.fine("finger fuzzy; checking in with customerid, productKey (" + info.getCustomerId() + "," + info.getProductKey() + ") to renew checkout");
                try {
                    this.timedCheckin(prev);
                }
                catch (InterruptedException timeoutOnCheckinIgnored) {
                    LicenseLogger.fine("finger fuzzy; checking in with customerid, productKey (" + info.getCustomerId() + "," + info.getProductKey() + ") to renew checkout timedout");
                }
            }
            LicenseLogger.fine("checking out with customerid, productKey (" + info.getCustomerId() + "," + info.getProductKey() + ")");
            try {
                checkoutSuccess = this.timedCheckout(licenser, info.getCheckoutDuration());
            }
            catch (InterruptedException e) {
                throw new SocketException("Network timeout while checking Agitar license.");
            }
            if (!checkoutSuccess) {
                if (licenser.getStatus() == 29) {
                    this.handleFailedCheckout(licenser, pInfo);
                } else if (licenser.getStatus() == 17 || licenser.getStatus() == 13) {
                    checkoutSuccess = this.tryCheckingInSessionWithOldSessionId(info, licenser);
                }
            }
            if (!checkoutSuccess) {
                this.handleFailedCheckout(licenser, pInfo);
            } else {
                CheckoutContext context = new CheckoutContext(licenser);
                context.checkVersion();
                this.setDurationBasedOnFeature(info);
                context.saveToServer(info.getEmailAddress(), licenser);
                this.saveIlsState(info, licenser);
            }
            exceptionInBackgroundThread = null;
        }
        finally {
            if (pInfo.isValid()) {
                pInfo.unsetProxy();
            }
        }
        return licenser;
    }

    protected boolean tryCheckingInSessionWithOldSessionId(ApplicationInfo info, Licenser licenser) throws InvalidLicenseException {
        info.setSessionIdOverrides(new Long(1L));
        Licenser oldLicenser = this.getLicenser(info);
        try {
            boolean checkoutOldLicenseOkay = this.timedCheckout(oldLicenser, info.getCheckoutDuration());
            if (checkoutOldLicenseOkay) {
                this.saveIlsState(info, oldLicenser);
                if (this.timedCheckin(info)) {
                    info.setSessionIdOverrides(null);
                    return this.timedCheckout(licenser, info.getCheckoutDuration());
                }
            }
        }
        catch (InterruptedException fromTimeout) {
            return false;
        }
        return false;
    }

    final synchronized void rehydrateLicenseString(String licenseInfo) throws InvalidLicenseException {
        if (StringUtility.nullOrEmpty((String)licenseInfo)) {
            throw new InvalidLicenseException("A license key is required for product activation.");
        }
        Licenser licenser = this.getLicenser(licenseInfo);
        CheckoutContext context = new CheckoutContext(licenser.getOptions(), licenser.getAppCtx(), licenser.getQuotaCap());
        ApplicationInfo previous = this.getApplicationInfo();
        previous.deleteInfo();
        ApplicationInfo info = this.getApplicationInfo(licenser.getCustomerID(), licenser.getProductKey(), context.getEmailAddress(), StringUtility.nullOrEmpty((String)licenser.getProductKey()));
        info.setDuration(licenser.getDuration());
        info.setLicenseString(licenseInfo);
        info.save();
        this.saveIlsState(info, licenser);
    }

    private Licenser getLicenser(String licenseInfo) throws InvalidLicenseException {
        return this.licenserFactory.getLicenser(licenseInfo, this.getHdir());
    }

    public Licenser getLicenser(ApplicationInfo info) {
        if (info == null || info.getCustomerId() == null || info.getProductKey() == null && !info.isFloating()) {
            throw new IllegalArgumentException("licenser info cannot be null or invalid");
        }
        return this.getLicenser(info.getCustomerId(), info.getProductKey(), info.isFloating(), info.getSessionId());
    }

    public synchronized void checkin() throws InvalidLicenseException {
        ApplicationInfo info = this.getApplicationInfo();
        this.checkin(info);
    }

    protected void cleanLicenserChecker(ApplicationInfo info) {
    }

    protected void restoreStateDuringCheckin(ApplicationInfo info, Licenser licenser) throws InvalidLicenseException {
        if (!this.restoreIlsState(info, licenser)) {
            LicenseLogger.warning("failed to restore local info during checkin attempt; proceeding with checkin anyhow");
        }
    }

    void saveIlsState(ApplicationInfo info, Licenser c) throws InvalidLicenseException {
        String state;
        LicenseLogger.finer("saving out ils checkout state");
        if (!this.hFileDirRehabilitated) {
            try {
                this.hFileDir = this.getPostTwoFiveOhHdir();
                this.hFileDirRehabilitated = true;
            }
            catch (UnknownHostException uhe) {
                LicenseLogger.log(AgitarLevel.WARNING, "hostname not available; using default hdir", uhe);
            }
        }
        if ((state = c.saveCheckoutState(this.getHdir())) == null) {
            throw new InvalidLicenseException("Error persisting license.", c);
        }
        info.setLicenseString(state);
        info.save();
    }

    public synchronized void checkLicenseWithoutFeature() throws InvalidLicenseException, SocketException {
        this.checkLicense(null);
    }

    public synchronized void checkLicense(LicensedFeature feature) throws InvalidLicenseException, SocketException {
        this.checkLicense(feature, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void checkLicense(LicensedFeature feature, ApplicationInfo info) throws InvalidLicenseException, SocketException {
        LicenseLogger.info("checking license (deep)");
        Object object = this.criticalSectionLock;
        synchronized (object) {
            this.startCriticalSection(false);
            try {
                this.checkLicense(feature, info, true);
            }
            finally {
                this.endCriticalSection();
            }
        }
    }

    boolean restoreIlsState(ApplicationInfo info, Licenser licenser) throws InvalidLicenseException {
        if (info == null) {
            throw new IllegalArgumentException("info cannot be null");
        }
        if (licenser == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        try {
            return licenser.restoreCheckoutState(info.getLicenseString(), info.getDurationInHours(), this.getHdir());
        }
        catch (NullPointerException fromIlsBug) {
            return false;
        }
    }

    public final synchronized void checkLocalLicenseWithoutFeature() throws InvalidLicenseException, SocketException {
        this.checkLocalLicense(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void checkLocalLicense(LicensedFeature feature) throws InvalidLicenseException, SocketException {
        if (AgitarProperties.LICENSE_SKIP_CHECK) {
            return;
        }
        LicenseLogger.info("checking license (shallow)");
        Object object = this.criticalSectionLock;
        synchronized (object) {
            this.startCriticalSection(false);
            try {
                this.checkLicense(feature, null, false);
            }
            finally {
                this.endCriticalSection();
            }
        }
    }

    public synchronized String getSavedLicenseKey() throws InvalidLicenseException {
        ApplicationInfo info = this.getApplicationInfo();
        if (!info.isValid() || StringUtility.nullOrEmpty((String)info.getLicenseString())) {
            throw new InvalidLicenseException("Registration information not found.");
        }
        return info.getLicenseString();
    }

    protected synchronized void checkLicense(LicensedFeature feature, ApplicationInfo iinfo, boolean gotoServer) throws InvalidLicenseException, SocketException {
        CheckoutContext context1;
        if (AgitarProperties.LICENSE_SKIP_CHECK) {
            return;
        }
        ApplicationInfo info = this.getApplicationInfo();
        if (!info.isValid()) {
            throw new InvalidLicenseException("Please register Agitar client to continue.");
        }
        Licenser client = this.getLicenser(info);
        boolean restoreOkay = this.restoreIlsState(info, client);
        boolean checkoutDurationOkay = true;
        if (restoreOkay) {
            checkoutDurationOkay = client.checkInCheckoutDuration(this.getHdir());
        }
        boolean fingerExact = this.getMachineFingerprint().equals(client.getMachineName());
        InvalidLicenseException fingerFailedException = null;
        if (checkoutDurationOkay) {
            LicenseLogger.fine("checking machine fingerprint");
            try {
                this.getMachineName().checkMachineFingerprint(client.getMachineName());
                LicenseLogger.fine("fuzzy check succeeded");
            }
            catch (InvalidLicenseException fromFingerprintCheck) {
                LicenseLogger.fine("fuzzy check failed");
                fingerFailedException = fromFingerprintCheck;
            }
        }
        boolean localChecksOkay = restoreOkay && fingerFailedException == null && checkoutDurationOkay && exceptionInBackgroundThread == null;
        LicenseLogger.fine("local checks status [" + localChecksOkay + "]. subchecks: licenserestore[" + restoreOkay + "]," + " fuzzycheck[" + (fingerFailedException != null) + "], durationcheck[" + checkoutDurationOkay + "]," + " no exception from previous background check[" + (exceptionInBackgroundThread == null) + "]");
        boolean doingBackGroundCheck = false;
        if (gotoServer || !localChecksOkay) {
            if (localChecksOkay) {
                LicenseLogger.fine("local checks okay; deep check in background");
                if (this.backgroundChecks) {
                    doingBackGroundCheck = true;
                    this.launchBackgroundCheckout(info, fingerExact);
                    LicenseLogger.fine("local checks okay; deep check in background");
                } else {
                    this.autoCheckout(info, !fingerExact);
                }
            } else {
                try {
                    LicenseLogger.fine("deep check in foreground");
                    client = this.checkout(info, !fingerExact);
                }
                catch (SocketException se) {
                    LicenseLogger.fine("local check failed and could not connect to server to refresh");
                    if (fingerFailedException != null) {
                        throw fingerFailedException;
                    }
                    if (exceptionInBackgroundThread != null) {
                        throw exceptionInBackgroundThread;
                    }
                    if (!restoreOkay && info.getLicenseString() != null) {
                        LicenseLogger.fine("could not restore checkout state");
                        throw new InvalidLicenseException("Saved license information is invalid. Please connect to network to re-acquire license.");
                    }
                    if (!checkoutDurationOkay) {
                        LicenseLogger.fine("local checkout expired");
                        String msg = info.getDuration() == 0L ? "License was released (due to checkout duration of 0)." : "License is expired.";
                        throw new InvalidLicenseException(msg + " Please connect to network to re-acquire license.");
                    }
                    throw se;
                }
            }
        }
        if (feature != null && !doingBackGroundCheck && !(context1 = this.createCheckoutContext(client)).isFeatureAllowed(feature)) {
            LicenseLogger.fine("Feature not allowed: " + feature.toString());
            throw new InvalidLicenseFeatureException(feature.toString());
        }
    }

    protected CheckoutContext createCheckoutContext(Licenser client) throws InvalidLicenseException {
        CheckoutContext context = new CheckoutContext(client);
        LicenseLogger.fine("using activation model? " + this.useHashedMachineID);
        return context;
    }

    protected void launchBackgroundCheckout(final ApplicationInfo info, final boolean fingerExact) {
        new Thread(new Runnable(){

            public void run() {
                LicenseChecker.this.insideBackgroundThread(info, fingerExact);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void insideBackgroundThread(ApplicationInfo info, boolean fingerExact) {
        Object object = this.criticalSectionLock;
        synchronized (object) {
            if (this.startCriticalSection(true)) {
                try {
                    this.autoCheckout(info, !fingerExact);
                }
                finally {
                    this.endCriticalSection();
                }
            } else {
                this.endCriticalSection();
            }
        }
    }

    public synchronized boolean isModuleLicensed(String moduleName, String currentModuleVersion, boolean requiresExplicitLicense) throws InvalidLicenseException {
        if (AgitarProperties.LICENSE_SKIP_CHECK) {
            return true;
        }
        LicenseLogger.info("checking licensing for module " + moduleName + ", current version [" + currentModuleVersion + "], requires license: " + requiresExplicitLicense);
        ApplicationInfo info = this.getApplicationInfo();
        if (!info.isValid() || StringUtility.nullOrEmpty((String)info.getLicenseString())) {
            throw new InvalidLicenseException("Registration information not found.");
        }
        Licenser client = this.getLicenser(info);
        boolean restoreOkay = this.restoreIlsState(info, client);
        if (!restoreOkay) {
            throw new InvalidLicenseException("License must be checked out to check module version.");
        }
        LicensingVersion maxModuleVersion = new CheckoutContext(client.getOptions(), client.getAppCtx(), client.getQuotaCap()).getMaxVersion(moduleName);
        boolean success = maxModuleVersion.isLicensed(currentModuleVersion, requiresExplicitLicense);
        LicenseLogger.info("module check for " + moduleName + " success? " + success);
        return success;
    }

    protected synchronized void autoCheckout(ApplicationInfo info, boolean fuzzy) {
        try {
            this.checkout(info, fuzzy);
        }
        catch (InvalidLicenseException ile) {
            exceptionInBackgroundThread = ile;
        }
        catch (SocketException se) {
            LicenseLogger.log(AgitarLevel.FINE, "could not reach license server after local checkout succeeded", se);
        }
        catch (Throwable te) {
            LicenseLogger.log(AgitarLevel.FINE, "parent thread killed?" + te.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void commandLineCheck(LicensedFeature feature, boolean ask) throws InvalidLicenseException {
        if (AgitarProperties.LICENSE_SKIP_CHECK) {
            return;
        }
        LicenseLogger.info("checking license from command-line tool");
        LicenseChecker lm = new LicenseChecker();
        ApplicationInfo info = lm.getApplicationInfo();
        if (!info.isValid()) {
            if (!ask) throw new InvalidLicenseException("*** Unregistered Product: Please register using the Agitar GUI or the register command.");
            info = ApplicationInfo.commandLineInput();
            try {
                lm.register(info.getCustomerId(), info.getProductKey(), info.getEmailAddress(), info.getDuration());
            }
            catch (Throwable problemRegistering) {
                System.err.println("*** Registration failed:\n");
                throw new InvalidLicenseException(problemRegistering.getMessage());
            }
            System.out.println("*** Registration successful");
            return;
        }
        try {
            lm.checkLicense(feature);
            return;
        }
        catch (Throwable x) {
            System.err.println("*** License check failed:\n");
            throw new InvalidLicenseException(x.getMessage());
        }
    }

    public synchronized void applicationExit() {
        block5: {
            LicenseLogger.info("exiting application");
            try {
                ApplicationInfo aInfo = this.getApplicationInfo();
                if (aInfo.isValid() && !StringUtility.nullOrEmpty((String)aInfo.getLicenseString()) && aInfo.getDuration() == 0L) {
                    LicenseLogger.info("exiting application; releasing license");
                    try {
                        this.timedCheckin(aInfo);
                    }
                    catch (InterruptedException e) {
                        LicenseLogger.log(AgitarLevel.INFO, "Network timeout while releasing license on application exit", e);
                    }
                    this.saveIlsState(aInfo, this.getLicenser(aInfo));
                    break block5;
                }
                LicenseLogger.info("exiting application without license release");
            }
            catch (InvalidLicenseException e) {
                LicenseLogger.log(AgitarLevel.SEVERE, "unexpected exception while exiting application", e);
            }
        }
    }

    protected ApplicationInfo getApplicationInfo() throws InvalidLicenseException {
        return ApplicationInfo.getSavedInfo();
    }

    protected ApplicationInfo getApplicationInfo(String customerId, String productKey, String emailAddress, boolean floating) throws InvalidLicenseException {
        return ApplicationInfo.getNewInfo(customerId, productKey, emailAddress, floating);
    }

    public void setBackgroundChecks(boolean backgroundChecks) {
        this.backgroundChecks = backgroundChecks;
    }

    public void setUseHashedMachineId(boolean useHashedMachineId) {
        this.useHashedMachineID = useHashedMachineId;
    }

    boolean startCriticalSection(boolean checkPid) {
        try {
            int read;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.getLockFile(), "rw");
            FileChannel channel = randomAccessFile.getChannel();
            int tries = 0;
            do {
                this.flock = channel.tryLock();
                ++tries;
                if (this.flock != null) continue;
                Thread.sleep(1000L);
            } while (this.flock == null && tries < 10);
            if (this.flock == null) {
                throw new InvalidLicenseException(MessageFormatter.format((String)"Could not acquire exclusive lock on file {0}. If no other Agitar processes are running, please delete this file and try again.", (Object)this.getLockFile().getAbsolutePath()));
            }
            ByteBuffer buf = ByteBuffer.allocate(8);
            if (checkPid && (read = channel.read(buf)) > 0) {
                buf.flip();
                long otherPid = buf.getLong();
                if (otherPid != this.getPid()) {
                    return false;
                }
                buf.flip();
            }
            buf.putLong(this.getPid());
            buf.flip();
            channel.write(buf);
            channel.force(true);
        }
        catch (Exception e) {
            AgitarLogger.getDiagnosticLogger().log(AgitarLevel.WARNING, "could not acquire file lock", e);
        }
        return true;
    }

    File getLockFile() {
        return new File(this.getHdir(), ".lock");
    }

    void endCriticalSection() {
        try {
            if (this.flock != null) {
                this.flock.release();
                this.flock.channel().close();
            }
        }
        catch (IOException e) {
            AgitarLogger.getDiagnosticLogger().log(AgitarLevel.WARNING, "could not release file lock", e);
        }
    }

    long getPid() {
        return rudimentaryUniqueProcessID;
    }

    private static class LocalAgitation
    implements LicensedFeature {
        private LocalAgitation() {
        }

        public boolean isGeneration() {
            return false;
        }

        public boolean isLocal() {
            return true;
        }

        public String toString() {
            return "Local Agitation";
        }
    }

    private static class LocalTestGeneration
    implements LicensedFeature {
        private LocalTestGeneration() {
        }

        public boolean isGeneration() {
            return true;
        }

        public boolean isLocal() {
            return true;
        }

        public String toString() {
            return "Local Test Generation";
        }
    }

    private static class ServerAgitation
    implements LicensedFeature {
        private ServerAgitation() {
        }

        public boolean isGeneration() {
            return false;
        }

        public boolean isLocal() {
            return false;
        }

        public String toString() {
            return "Server Agitation";
        }
    }

    private static class ServerTestGeneration
    implements LicensedFeature {
        private ServerTestGeneration() {
        }

        public boolean isGeneration() {
            return true;
        }

        public boolean isLocal() {
            return false;
        }

        public String toString() {
            return "Server Test Generation";
        }
    }
}

