/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.licensechecker.Licenser;
import java.util.HashMap;

public class InvalidLicenseException
extends Exception {
    static final String CANNOT_CONNECT_MESSAGE = "Cannot connect to the license server. Please check your server settings or network connectivity and retry.";
    private static HashMap ERR_MESSAGES = new HashMap();
    private static final String expirationMsg = "License expired. Please contact Agitar to purchase/extend your license.";
    private static final String invalidLicenseKeyMsg = "Invalid license key. Please make sure you enter the key correctly or contact Agitar to purchase a license key.";
    private static final String clockMsg = "An error in the system clock setting was detected. Please check your clock and re-enter your registration/authorization information.";
    public static final String UNREGISTERED = "Please register Agitar client to continue.";
    public static final String DEHYDRATED_STATE_NEEDED = "A license key is required for product activation.";
    public static final String ACTIVATED_PRODUCT_EXPIRED = "Your product activation has expired. Please reactivate or register your product.";
    public static final String NODE_CHANGED = "This license can only be used on the computer where it was originally registered or activated.";
    public static final String HARDWARD_PROFILE_CHANGED = "Your license does not match your hardware profile. Please re-register your Agitar client to sync your hardware profile to your license.";
    public static final String BAD_LICENSE_KEY = "Your license key does not appear to be valid.";
    public static final String HOSTS_FILE = "Problems with your proxy settings or your host file have interfered with your Agitar license. Please check them and re-register or re-activate your license.";
    public static final String FLOATING_DOMAIN_FULL = "All licenses for your license id are in use. Please contact Agitar for additional licenses.";
    public static final String UNKNOWN_ISSUE = "Your license key could not be accepted due to error with status code ";
    public static final String KEY_TIME_OFF = "Your license could not be accepted because your computer's system clock is incorrect or your license key has expired. Please check your system clock and re-activate your product.";
    static final String PROXY_PROBLEM_BASE = "Please check your proxy settings and network connection and try again.";
    public static final String TIMEOUT_THROUGH_PROXY = "Timeout while trying to connect through proxy. Please check your proxy settings and network connection and try again.";
    public static final String NO_CONNECT_THROUGH_PROXY = "Could not connect through proxy. Please check your proxy settings and network connection and try again.";
    public static final String COULD_NOT_ACQUIRE_LOCK = "Could not acquire exclusive lock on file {0}. If no other Agitar processes are running, please delete this file and try again.";
    public static final String SERVER_LICENSE_CHECK_FAILED = "Server license key check failed.";
    private String details = "";

    public InvalidLicenseException(String msg, Licenser client) {
        super(msg);
        this.details = InvalidLicenseException.getStatus(client);
    }

    public InvalidLicenseException(String msg) {
        super(msg);
    }

    public InvalidLicenseException(String msg, Exception cause) {
        super(msg, cause);
    }

    public String getDetails() {
        return this.details;
    }

    public String getMessage() {
        String m = super.getMessage();
        m = m != null && m.length() > 0 ? m + '\n' : "";
        return m + this.details;
    }

    public String toString() {
        return super.toString() + "\n" + this.details;
    }

    private static String getStatus(Licenser client) {
        StringBuffer sb = new StringBuffer();
        int status = client.getStatus();
        String m = (String)ERR_MESSAGES.get(new Integer(status));
        if (m == null) {
            String msg = client.getMsg();
            if (status == 1000 && msg != null && msg.toLowerCase().indexOf("time difference too great") >= 0) {
                sb.append(clockMsg);
            } else {
                sb.append("License checking error. Please retry later, if the problem persists, contact Agitar for a new license key:\n");
                if (msg != null && !"".equals(msg)) {
                    sb.append("[Message: ").append(msg).append("]");
                }
            }
        } else {
            sb.append(m);
        }
        sb.append(" [" + status + "]");
        sb.append('\n');
        return sb.toString();
    }

    static {
        ERR_MESSAGES.put(new Integer(18), "Do not have access right to the license server. Please check your network connectivity or contact Agitar.");
        ERR_MESSAGES.put(new Integer(13), "The license key is in use. Please register with a different key or contact Agitar for new license keys.");
        ERR_MESSAGES.put(new Integer(103), clockMsg);
        ERR_MESSAGES.put(new Integer(29), CANNOT_CONNECT_MESSAGE);
        ERR_MESSAGES.put(new Integer(11), "Incorrect license id. Please check that the id entered is correct or contact Agitar for your authorization info.");
        ERR_MESSAGES.put(new Integer(12), "Incorrect product key. Please check that the key entered is correct or contact Agitar for your authorization info.");
        ERR_MESSAGES.put(new Integer(5), expirationMsg);
        ERR_MESSAGES.put(new Integer(4), "The license information was invalid or expired. Please re-register to continue.");
        ERR_MESSAGES.put(new Integer(22), "Your license information does not match our record. Please make sure it is not copied from a different machine and re-register.");
        ERR_MESSAGES.put(new Integer(8), "Invalid license id. Please make sure you enter the field correctly.");
        ERR_MESSAGES.put(new Integer(2), "Invalid machine id. Please make sure the product is originally installed on this machine or re-register.");
        ERR_MESSAGES.put(new Integer(1), "Invalid license information. Please re-register.");
        ERR_MESSAGES.put(new Integer(3), "Invalid date time information. Please check your clock and re-enter your registration/authorization information.");
        ERR_MESSAGES.put(new Integer(9), invalidLicenseKeyMsg);
        ERR_MESSAGES.put(new Integer(17), FLOATING_DOMAIN_FULL);
        ERR_MESSAGES.put(new Integer(26), invalidLicenseKeyMsg);
        ERR_MESSAGES.put(new Integer(-2), "License is expired and currently in grace period. Please contact Agitar to purchase/extend your license.");
        ERR_MESSAGES.put(new Integer(-1), "License is about to expire. Please contact Agitar to purchase/extend your license.");
        ERR_MESSAGES.put(new Integer(-3), "Quota limit is acout to expire. Please contact Agitar to increase your quota.");
        ERR_MESSAGES.put(new Integer(-4), "Quota limit is reached, and currently grace period. Please contact Agitar to increase your quota.");
        ERR_MESSAGES.put(new Integer(6), "Quota limit is reached. Please contact Agitar to increase your quota.");
        ERR_MESSAGES.put(new Integer(7), "The Agitar server has not been registered.  Please visit the \"License Registration\" page on the Agitar server admin page.");
    }
}

