/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.Licenser;
import com.vs.ils.client.IlsClient;

public class IlsLicenser
implements Licenser {
    private final IlsClient client;
    private final int DEFAULT_TIME_TOLERANCE_HOURS = 1;
    static final String LICENSER_OVERDRAFT_LIMIT = "licenser.overdraft.limit";
    static final String HYDRATION_PASS = "AgitarOne";
    private static final long ACTIVATION_SHELF_LIFE_IN_HOURS = 336L;

    IlsLicenser(String serverUrl, String machineName, String customerId, String productKey, long sessionId) {
        this(serverUrl, machineName, customerId, productKey, sessionId, null, null, null);
    }

    IlsLicenser(String serverUrl, String machineName, String customerId, String productKey, long sessionId, String product, String userPassword, String publicKey) {
        int overdrafts;
        LicenseLogger.finer("constructing new Ils client");
        String overdraftLimit = System.getProperty(LICENSER_OVERDRAFT_LIMIT);
        try {
            overdrafts = overdraftLimit != null ? Integer.parseInt(overdraftLimit) : 0;
        }
        catch (NumberFormatException nfe) {
            overdrafts = 0;
        }
        long start = System.currentTimeMillis();
        this.client = new IlsClient(serverUrl, null, machineName, sessionId, product == null ? HYDRATION_PASS : product, customerId, productKey, userPassword, 1, 1, publicKey, overdrafts);
        LicenseLogger.finer("finished constructing ils client after " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        LicenseLogger.info("using overdraft limit of " + overdrafts);
    }

    IlsLicenser(String checkoutState, String fileDir) throws InvalidLicenseException {
        this.client = new IlsClient();
        boolean restoreSuccess = this.restoreCheckoutState(checkoutState, 336L, fileDir);
        if (!restoreSuccess) {
            if (this.client.getStatus() == 0) {
                throw new InvalidLicenseException("Your license key does not appear to be valid.");
            }
            if (this.client.getStatus() == 103) {
                throw new InvalidLicenseException("Your license could not be accepted because your computer's system clock is incorrect or your license key has expired. Please check your system clock and re-activate your product.");
            }
            throw new InvalidLicenseException("Your license key could not be accepted due to error with status code " + this.client.getStatus());
        }
    }

    public boolean checkout(long time) {
        LicenseLogger.fine("starting checkout");
        long startTime = System.currentTimeMillis();
        boolean success = this.client.checkout(time, "*");
        this.logNetworkAction("checkout", success, startTime);
        return success;
    }

    public String saveCheckoutState(String fileDir) {
        LicenseLogger.finer("saving checkout state to " + fileDir);
        return this.client.saveCheckoutState(HYDRATION_PASS, fileDir);
    }

    public int getStatus() {
        return this.client.getStatus();
    }

    public String getMsg() {
        return this.client.getMsg();
    }

    public String getOptions() {
        return this.client.getOptions();
    }

    public boolean doGetAppCtx() {
        LicenseLogger.finer("getting app context from server");
        long startTime = System.currentTimeMillis();
        boolean success = this.client.doGetAppCtx();
        this.logNetworkAction("app context retrieval", success, startTime);
        return success;
    }

    public String getAppCtx() {
        return this.client.getAppCtx();
    }

    public boolean restoreCheckoutState(String licenseString, long shelfLifeInHours, String fileDir) {
        LicenseLogger.finer("restoring checkout state");
        boolean restoreOkay = this.client.restoreCheckoutState(licenseString, HYDRATION_PASS, shelfLifeInHours, 1, fileDir);
        LicenseLogger.finer("restoration of ils state successful? " + restoreOkay);
        LicenseLogger.finer("restored state good for: " + this.client.getDuration());
        LicenseLogger.finer("restored state status: " + this.client.getStatus());
        return restoreOkay;
    }

    public String getMachineName() {
        return this.client.getMachineName();
    }

    public boolean checkInCheckoutDuration(String fileDir) {
        return this.client.checkInCheckoutDuration(1, fileDir, true);
    }

    public boolean doSetAppCtx(String appContext) {
        LicenseLogger.fine("setting app context [" + appContext + "]");
        long startTime = System.currentTimeMillis();
        this.setLocalAppCtx(appContext);
        boolean toReturn = this.client.doSetAppCtx(appContext);
        this.logNetworkAction("set app context", toReturn, startTime);
        this.setLocalAppCtx(appContext);
        return toReturn;
    }

    public boolean checkin() {
        LicenseLogger.fine("starting checkin");
        long startTime = System.currentTimeMillis();
        boolean toReturn = this.client.checkin();
        this.logNetworkAction("checkin", toReturn, startTime);
        return toReturn;
    }

    private void logNetworkAction(String msg, boolean success, long startTime) {
        if (success) {
            LicenseLogger.fine(msg + " successful; took " + (System.currentTimeMillis() - startTime) + "ms");
        } else {
            LicenseLogger.fine(msg + " failed; took " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    public long getSessionId() {
        return this.client.getSessionId();
    }

    int getOverdraftLimit() {
        return this.client.getOverdraftLimit();
    }

    public String getCustomerID() {
        return this.client.getDomainName();
    }

    public String getProductKey() {
        return this.client.getUserName();
    }

    void setLocalAppCtx(String appContext) {
        this.client.setAppCtx(appContext);
    }

    public long getDuration() {
        return this.client.getDuration();
    }

    public long getBalanceQuota() {
        return this.client.getBalanceQuota();
    }

    public long getQuotaCap() {
        return this.client.getQuotaCap();
    }

    public boolean upQuotaUseLevel(int arg0) {
        return this.client.upQuotaUseLevel(arg0);
    }

    public String getAuthToken() {
        return this.client.getToken();
    }
}

