/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.common.util.StringUtility;
import com.agitar.licensechecker.ApplicationInfo;
import com.agitar.licensechecker.InvalidLicenseException;
import java.util.prefs.Preferences;

public class ClientApplicationInfo {
    private Preferences preferences = Preferences.userNodeForPackage(this.getClass()).node("info");
    private static final String LICENSE_ID = "licenseID";
    private static final String USE_LICENSE_DOMAIN_AUTHENTICATION = "useLicenseDomainAuthentication";
    private static final String EMAIL_ADDRESSS = "emailAddress";
    private static final String ACCESS_KEY = "accessKey";
    public static final String NO_LICENSE_STRING = "-none-";

    public String getLicenseID() {
        String id = this.preferences.get(LICENSE_ID, "");
        if ("".equals(id)) {
            try {
                id = ApplicationInfo.getSavedInfo().getCustomerId();
                if (id == null) {
                    id = "";
                }
            }
            catch (InvalidLicenseException invalidLicenseException) {
                // empty catch block
            }
        }
        return NO_LICENSE_STRING.equals(id) ? "" : id;
    }

    public void setLicenseID(String id) {
        if (StringUtility.nullOrEmpty((String)id)) {
            id = NO_LICENSE_STRING;
        }
        this.preferences.put(LICENSE_ID, id);
    }

    public boolean getUseLicenseDomainAuthentication() {
        return this.preferences.getBoolean(USE_LICENSE_DOMAIN_AUTHENTICATION, false);
    }

    public void setUseLicenseDomainAuthentication(boolean use) {
        this.preferences.putBoolean(USE_LICENSE_DOMAIN_AUTHENTICATION, use);
    }

    public String getEmailAddress() {
        return this.preferences.get(EMAIL_ADDRESSS, "");
    }

    public void setEmailAdddress(String emailAddress) {
        this.preferences.put(EMAIL_ADDRESSS, emailAddress);
    }

    public String getAccessKey() {
        return this.preferences.get(ACCESS_KEY, "");
    }

    public void setAccessKey(String key) {
        this.preferences.put(ACCESS_KEY, key);
    }
}

