/*
 * Decompiled with CFR 0.152.
 */
package com.agitar.licensechecker;

import com.agitar.common.util.StringUtility;
import com.agitar.common.util.Version;
import com.agitar.licensechecker.InvalidLicenseException;
import com.agitar.licensechecker.LicenseLogger;
import com.agitar.licensechecker.LicenseOptionCheck;
import com.agitar.licensechecker.LicensedFeature;
import com.agitar.licensechecker.Licenser;
import com.agitar.licensechecker.LicensingVersion;

class CheckoutContext {
    private static final String APPCONTEXT_DELIMITER = "&";
    private static final String ILS_OPTIONS_DELIMITER = ";";
    private static final String LIC_OPTIONS_DELIMITER = ",";
    private static final String EMAIL = "email";
    private static final String CLIENT_MACHINE = "clientmachine";
    private static final String REMOTE = "remote";
    private static final String LOCAL = "local";
    private static final String GENERATION = "generation";
    private static final String AGITATION = "agitation";
    private final String ilsOptions;
    private final String appContext;
    private final LicenseOptionCheck licOptions;
    public static final int DEFAULT_DONT_MOVE_DURATION = 30;
    static long DAYS_TO_SECOND = 86400000L;

    CheckoutContext(Licenser licenser) throws InvalidLicenseException {
        if (licenser == null) {
            throw new IllegalArgumentException("ilsClient cannot be null");
        }
        this.ilsOptions = licenser.getOptions();
        licenser.doGetAppCtx();
        this.appContext = licenser.getAppCtx();
        this.licOptions = new LicenseOptionCheck();
        this.initializeLicenseOptionCheck(licenser.getQuotaCap());
    }

    CheckoutContext(String options, String appCtx) throws InvalidLicenseException {
        this(options, appCtx, -1L);
    }

    CheckoutContext(String options, String appCtx, long quotaCap) throws InvalidLicenseException {
        this.ilsOptions = options;
        this.appContext = appCtx;
        this.licOptions = new LicenseOptionCheck();
        this.initializeLicenseOptionCheck(quotaCap);
    }

    public boolean isAppContextDefined() {
        return !StringUtility.nullOrEmpty((String)this.appContext);
    }

    private static String parseFromNameValueDelimitedString(String encodedString, String delimiter, String key) {
        if (StringUtility.nullOrEmpty((String)encodedString)) {
            return null;
        }
        int index = encodedString.indexOf(key + "=");
        if (index < 0) {
            return null;
        }
        int optionalDelim = encodedString.indexOf(delimiter, index += key.length() + 1);
        return encodedString.substring(index, optionalDelim < 0 ? encodedString.length() : optionalDelim);
    }

    public void saveToServer(String emailAddress, String clientMachineName, Licenser licenser) throws InvalidLicenseException {
        CheckoutContext newContext = new CheckoutContext(this.ilsOptions, "email=" + emailAddress + CLIENT_MACHINE + "=" + clientMachineName, licenser.getQuotaCap());
        newContext.saveToServer(licenser);
    }

    public void saveToServer(String emailAddress, Licenser licenser) throws InvalidLicenseException {
        CheckoutContext newContext = new CheckoutContext(this.ilsOptions, "email=" + emailAddress, licenser.getQuotaCap());
        newContext.saveToServer(licenser);
    }

    private void saveToServer(Licenser licenser) throws InvalidLicenseException {
        LicenseLogger.info("saving context to server");
        if (licenser == null) {
            throw new IllegalArgumentException("licenser cannot be null");
        }
        if (!licenser.doSetAppCtx(this.appContext)) {
            LicenseLogger.warning("Failed to set user parameter : " + licenser.getMsg());
            throw new InvalidLicenseException("Failed to set user parameter :" + licenser.getMsg());
        }
    }

    public String toString() {
        return "context[" + this.appContext + "], options[" + this.ilsOptions + "]";
    }

    public String getEmailAddress() {
        if (!this.isAppContextDefined()) {
            throw new IllegalStateException("cannot get email from undefined app context");
        }
        return CheckoutContext.parseFromNameValueDelimitedString(this.appContext, APPCONTEXT_DELIMITER, EMAIL);
    }

    public LicensingVersion getMaxVersion(String moduleName) {
        return new LicensingVersion(moduleName, CheckoutContext.parseFromNameValueDelimitedString(this.ilsOptions, ILS_OPTIONS_DELIMITER, "maxVersion_" + moduleName));
    }

    String getAppContext() {
        return this.appContext;
    }

    String getIlsOptions() {
        return this.ilsOptions;
    }

    public void checkVersion() throws InvalidLicenseException {
        if (StringUtility.nullOrEmpty((String)this.ilsOptions)) {
            return;
        }
        LicensingVersion maximumVersion = this.getMaxVersion("Agitator");
        boolean agitatorVersionOptionRequired = false;
        if (!maximumVersion.isLicensed(Version.getInstance().getVersion(), false)) {
            throw new InvalidLicenseException("This license is valid for Agitator Versions up to " + maximumVersion.getVersion() + ". You are attempting to run " + Version.getInstance().getSimpleNumber());
        }
    }

    public void initializeLicenseOptionCheck(long quotaCap) throws InvalidLicenseException {
        this.licOptions.setQuotaCap(quotaCap);
        this.setLicenseOption(this.ilsOptions, AGITATION, this.licOptions);
        this.setLicenseOption(this.ilsOptions, GENERATION, this.licOptions);
    }

    void setLicenseOption(String optStr, String feature, LicenseOptionCheck opt) throws InvalidLicenseException {
        boolean remote = false;
        boolean local = false;
        boolean hasFeature = false;
        if (optStr != null) {
            boolean bl = hasFeature = optStr.indexOf(feature) >= 0;
            if (hasFeature) {
                remote = this.getFeatureOption(REMOTE, feature, optStr);
                local = this.getFeatureOption(LOCAL, feature, optStr);
                if (feature.equals(AGITATION)) {
                    opt.setAgitationLicenseOption(remote, local);
                } else {
                    opt.setGenerationLicenseOption(remote, local);
                }
            }
        }
    }

    private boolean getFeatureOption(String remoteOrLocal, String feature, String optStr) throws InvalidLicenseException {
        boolean option = false;
        String featureOption = CheckoutContext.parseFromNameValueDelimitedString(optStr, ILS_OPTIONS_DELIMITER, remoteOrLocal + "-" + feature);
        String[] opts = StringUtility.split((String)featureOption, (String)LIC_OPTIONS_DELIMITER);
        if (opts.length > 0) {
            try {
                option = Integer.parseInt(opts[0]) > 0;
            }
            catch (NumberFormatException ne) {
                LicenseLogger.severe("Invalid option: " + opts[0] + " . Agitation or Generation option is an integer 0 or 1.");
                throw new InvalidLicenseException("Invalid option: " + opts[0] + " . Agitation or Generation option is 0 or 1.");
            }
        }
        return option;
    }

    public boolean isFeatureAllowed(LicensedFeature feature) {
        return this.licOptions.checkFeature(feature);
    }

    public boolean hasLocalDurationFeature() {
        return this.licOptions.checkHasOfflineFeature();
    }
}

